/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.colorchooser.NumericDocument;

class JIntegerTextField
extends JTextField {
    public JIntegerTextField(int n, int n2, int n3) {
        super(new NumericDocument(n, n2), n3 + "", String.valueOf(n2).length() + 1);
        this.installKeyboardActions();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke("KP_UP");
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke("KP_DOWN");
            inputMap.put(keyStroke, "incrementValue");
            inputMap.put(keyStroke2, "decrementValue");
            if (keyStroke != keyStroke3) {
                inputMap.put(keyStroke3, "incrementValue");
                inputMap.put(keyStroke4, "decrementValue");
            }
            actionMap.put("incrementValue", new ValueDelta(1));
            actionMap.put("decrementValue", new ValueDelta(-1));
        }
    }

    public int getIntegerValue() {
        return ((NumericDocument)this.getDocument()).getIntegerValue();
    }

    public void setText(String string) {
        NumericDocument numericDocument = (NumericDocument)this.getDocument();
        int n = numericDocument.currentVal;
        try {
            numericDocument.currentVal = numericDocument.parse(string);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (n != numericDocument.currentVal) {
            numericDocument.checkingEnabled = false;
            super.setText(string);
            numericDocument.checkingEnabled = true;
        }
    }

    class ValueDelta
    extends AbstractAction {
        int delta;

        public ValueDelta(int n) {
            this.delta = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NumericDocument numericDocument = (NumericDocument)JIntegerTextField.this.getDocument();
            int n = numericDocument.min;
            int n2 = numericDocument.max;
            int n3 = JIntegerTextField.this.getIntegerValue();
            if ((n3 += this.delta) < n) {
                n3 = n2;
            } else if (n3 > n2) {
                n3 = n;
            }
            JIntegerTextField.this.setText(String.valueOf(n3));
        }
    }
}

