/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;

public final class UnresolvedPermission
extends Permission
implements Serializable {
    private String type;
    private String name;
    private String actions;
    private transient Certificate[] certs;
    private static final Class[] PARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UnresolvedPermission.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UnresolvedPermission.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public UnresolvedPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException("type can't be null");
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n = 0;
            while (n < certificateArray.length) {
                if (!(certificateArray[n] instanceof X509Certificate)) {
                    this.certs = (Certificate[])certificateArray.clone();
                    break;
                }
                ++n;
            }
            if (this.certs == null) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < certificateArray.length) {
                    ++n3;
                    while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                        ++n2;
                    }
                    ++n2;
                }
                if (n3 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList arrayList = new ArrayList();
                    n2 = 0;
                    while (n2 < certificateArray.length) {
                        arrayList.add(certificateArray[n2]);
                        while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                            ++n2;
                        }
                        ++n2;
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }

    Permission resolve(Permission permission, Certificate[] certificateArray) {
        if (this.certs != null) {
            if (certificateArray == null) {
                return null;
            }
            int n = 0;
            while (n < this.certs.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < certificateArray.length) {
                    if (this.certs[n].equals(certificateArray[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return null;
                }
                ++n;
            }
        }
        try {
            Class clazz = permission.getClass();
            Constructor constructor = clazz.getConstructor(PARAMS);
            return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof UnresolvedPermission)) {
            return false;
        }
        UnresolvedPermission unresolvedPermission = (UnresolvedPermission)object;
        if (!(this.type.equals(unresolvedPermission.type) && this.name.equals(unresolvedPermission.name) && this.actions.equals(unresolvedPermission.actions))) {
            return false;
        }
        if (this.certs.length != unresolvedPermission.certs.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.certs.length) {
            bl = false;
            n = 0;
            while (n < unresolvedPermission.certs.length) {
                if (this.certs[n2].equals(unresolvedPermission.certs[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < unresolvedPermission.certs.length) {
            bl = false;
            n = 0;
            while (n < this.certs.length) {
                if (unresolvedPermission.certs[n2].equals(this.certs[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n ^= this.actions.hashCode();
        }
        return n;
    }

    public String getActions() {
        return "";
    }

    public String toString() {
        return "(unresolved " + this.type + " " + this.name + " " + this.actions + ")";
    }

    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.certs.length);
            int n = 0;
            while (n < this.certs.length) {
                Certificate certificate = this.certs[n];
                try {
                    objectOutputStream.writeUTF(certificate.getType());
                    byte[] byArray = certificate.getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException(certificateEncodingException.getMessage());
                }
                ++n;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable hashtable = null;
        objectInputStream.defaultReadObject();
        if (this.type == null) {
            throw new NullPointerException("type can't be null");
        }
        int n = objectInputStream.readInt();
        if (n > 0) {
            hashtable = new Hashtable(3);
            this.certs = new Certificate[n];
        }
        int n2 = 0;
        while (n2 < n) {
            CertificateFactory certificateFactory;
            String string = objectInputStream.readUTF();
            if (hashtable.containsKey(string)) {
                certificateFactory = (CertificateFactory)hashtable.get(string);
            } else {
                try {
                    certificateFactory = CertificateFactory.getInstance(string);
                }
                catch (CertificateException certificateException) {
                    throw new ClassNotFoundException("Certificate factory for " + string + " not found");
                }
                hashtable.put(string, certificateFactory);
            }
            byte[] byArray = null;
            try {
                byArray = new byte[objectInputStream.readInt()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("Certificate too big");
            }
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.certs[n2] = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            byteArrayInputStream.close();
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

