/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.InetAddressImpl;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.HashMap;
import sun.net.InetAddressCachePolicy;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public final class InetAddress
implements Serializable {
    String hostName;
    int address;
    int family;
    private static final long serialVersionUID = 3286316764910316507L;
    private static HashMap addressCache;
    private static InetAddress unknownAddress;
    private static InetAddress localHost;
    private static InetAddress[] unknown_array;
    static InetAddress anyLocalAddress;
    static InetAddressImpl impl;
    private static HashMap lookupTable;
    private static InetAddress loopbackHost;

    InetAddress() {
        this.family = impl.getInetFamily();
    }

    InetAddress(String string, byte[] byArray) {
        this.hostName = string;
        this.family = impl.getInetFamily();
        this.address = byArray[3] & 0xFF;
        this.address |= byArray[2] << 8 & 0xFF00;
        this.address |= byArray[1] << 16 & 0xFF0000;
        this.address |= byArray[0] << 24 & 0xFF000000;
    }

    public boolean isMulticastAddress() {
        return (this.address & 0xF0000000) == -536870912;
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean bl) {
        if (this.hostName == null) {
            try {
                InetAddress[] inetAddressArray;
                this.hostName = impl.getHostByAddr(this.address);
                if (bl && (inetAddressArray = System.getSecurityManager()) != null) {
                    inetAddressArray.checkConnect(this.hostName, -1);
                }
                inetAddressArray = InetAddress.getAllByName0(this.hostName, bl);
                boolean bl2 = false;
                if (inetAddressArray != null) {
                    int n = 0;
                    while (!bl2 && n < inetAddressArray.length) {
                        bl2 = this.address == inetAddressArray[n].address;
                        ++n;
                    }
                }
                if (!bl2) {
                    this.hostName = this.getHostAddress();
                    return this.getHostAddress();
                }
            }
            catch (SecurityException securityException) {
                this.hostName = this.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostName = this.getHostAddress();
            }
        }
        return this.hostName;
    }

    public byte[] getAddress() {
        byte[] byArray = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return byArray;
    }

    public String getHostAddress() {
        return (this.address >>> 24 & 0xFF) + "." + (this.address >>> 16 & 0xFF) + "." + (this.address >>> 8 & 0xFF) + "." + (this.address >>> 0 & 0xFF);
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof InetAddress && ((InetAddress)object).address == this.address;
    }

    public String toString() {
        return this.getHostName() + "/" + this.getHostAddress();
    }

    private static void cacheAddress(String string, Object object) {
        int n = InetAddressCachePolicy.get();
        if (n == 0) {
            return;
        }
        long l = -1L;
        if (n != -1) {
            l = System.currentTimeMillis() + (long)(n * 1000);
        }
        InetAddress.cacheAddress(string, object, l);
    }

    private static void cacheAddress(String string, Object object, long l) {
        string = string.toLowerCase();
        HashMap hashMap = addressCache;
        synchronized (hashMap) {
            CacheEntry cacheEntry = (CacheEntry)addressCache.get(string);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(string, object, l);
                addressCache.put(string, cacheEntry);
            } else {
                cacheEntry.address = object;
                cacheEntry.expiration = l;
            }
        }
    }

    private static Object getCachedAddress(String string) {
        string = string.toLowerCase();
        if (InetAddressCachePolicy.get() == 0) {
            return null;
        }
        HashMap hashMap = addressCache;
        synchronized (hashMap) {
            CacheEntry cacheEntry = (CacheEntry)addressCache.get(string);
            if (cacheEntry != null && cacheEntry.expiration < System.currentTimeMillis() && cacheEntry.expiration >= 0L) {
                cacheEntry = null;
            }
            Object object = cacheEntry != null ? cacheEntry.address : null;
            return object;
        }
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        Object var1_1 = null;
        if (string == null || string.length() == 0) {
            return loopbackHost;
        }
        if (!Character.isDigit(string.charAt(0))) {
            return InetAddress.getAllByName0(string)[0];
        }
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (c < '0' || c > '9') {
                return InetAddress.getAllByName0(string)[0];
            }
            int n4 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return InetAddress.getAllByName0(string)[0];
                }
                n4 = n4 * 10 + c - 48;
                if (++n3 >= cArray.length) break;
                c = cArray[n3];
            }
            if (n4 > 255) {
                return InetAddress.getAllByName0(string)[0];
            }
            n = (n << 8) + n4;
            ++n2;
            ++n3;
        }
        if (n2 != 4 || string.endsWith(".")) {
            return InetAddress.getAllByName0(string)[0];
        }
        InetAddress inetAddress = new InetAddress();
        inetAddress.address = n;
        inetAddress.hostName = null;
        return inetAddress;
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            throw new UnknownHostException("empty string");
        }
        if (Character.isDigit(string.charAt(0))) {
            InetAddress[] inetAddressArray = new InetAddress[]{InetAddress.getByName(string)};
            return inetAddressArray;
        }
        return InetAddress.getAllByName0(string);
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        return InetAddress.getAllByName0(string, true);
    }

    static InetAddress[] getAllByName0(String string, boolean bl) throws UnknownHostException {
        SecurityManager securityManager;
        Object object = null;
        Object object2 = null;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(string, -1);
        }
        if ((object = InetAddress.getCachedAddress(string)) == null) {
            object = InetAddress.getAddressFromNameService(string);
        }
        if (object == unknown_array) {
            throw new UnknownHostException(string);
        }
        try {
            object2 = ((InetAddress[])object).clone();
            if (object2 == null) {
                throw new CloneNotSupportedException();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return (InetAddress[])object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getAddressFromNameService(String string) {
        InetAddress[] inetAddressArray = null;
        inetAddressArray = InetAddress.checkLookupTable(string);
        if (inetAddressArray != null) return inetAddressArray;
        try {
            try {
                byte[][] byArray = impl.lookupAllHostAddr(string);
                InetAddress[] inetAddressArray2 = new InetAddress[byArray.length];
                int n = 0;
                while (true) {
                    if (n >= byArray.length) {
                        inetAddressArray = inetAddressArray2;
                        break;
                    }
                    byte[] byArray2 = byArray[n];
                    inetAddressArray2[n] = new InetAddress(string, byArray2);
                    ++n;
                }
            }
            catch (UnknownHostException unknownHostException) {
                inetAddressArray = unknown_array;
                Object var7_8 = null;
                InetAddress.cacheAddress(string, inetAddressArray);
                InetAddress.updateLookupTable(string);
                return inetAddressArray;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            InetAddress.cacheAddress(string, inetAddressArray);
            InetAddress.updateLookupTable(string);
            throw throwable;
        }
        InetAddress.cacheAddress(string, inetAddressArray);
        InetAddress.updateLookupTable(string);
        return inetAddressArray;
    }

    /*
     * Unable to fully structure code
     */
    private static Object checkLookupTable(String var0) {
        var1_1 = null;
        var2_2 = InetAddress.lookupTable;
        synchronized (var2_2) {
            if (InetAddress.lookupTable.containsKey(var0)) ** GOTO lbl15
            InetAddress.lookupTable.put(var0, null);
            var3_3 = var1_1;
            return var3_3;
lbl-1000:
            // 1 sources

            {
                try {
                    InetAddress.lookupTable.wait();
                    continue;
                }
                catch (InterruptedException var3_4) {
                    // empty catch block
                }
lbl15:
                // 3 sources

                ** while (InetAddress.lookupTable.containsKey((Object)var0))
            }
lbl16:
            // 1 sources

        }
        var1_1 = InetAddress.getCachedAddress(var0);
        if (var1_1 == null) {
            var3_5 = InetAddress.lookupTable;
            synchronized (var3_5) {
                InetAddress.lookupTable.put(var0, null);
            }
        }
        return var1_1;
    }

    private static void updateLookupTable(String string) {
        HashMap hashMap = lookupTable;
        synchronized (hashMap) {
            lookupTable.remove(string);
            lookupTable.notifyAll();
        }
    }

    public static synchronized InetAddress getLocalHost() throws UnknownHostException {
        if (localHost.equals(unknownAddress)) {
            throw new UnknownHostException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        try {
            if (InetAddress.localHost.address == -1) {
                localHost = InetAddress.getAllByName(InetAddress.localHost.hostName)[0];
            }
            if (securityManager != null) {
                securityManager.checkConnect(localHost.getHostName(), -1);
            }
        }
        catch (SecurityException securityException) {
            return loopbackHost;
        }
        return localHost;
    }

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        InetAddress.init();
        addressCache = new HashMap();
        lookupTable = new HashMap();
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        try {
            impl = null;
            impl = (InetAddressImpl)Class.forName("java.net." + string + "InetAddressImpl").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string + "InetAddressImpl:\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string + "InetAddressImpl:\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string + "InetAddressImpl:\ncheck impl.prefix property " + "in your properties file.");
        }
        if (impl == null) {
            try {
                impl = (InetAddressImpl)Class.forName("java.net.InetAddressImpl").newInstance();
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        unknownAddress = new InetAddress();
        anyLocalAddress = new InetAddress();
        impl.makeAnyLocalAddress(anyLocalAddress);
        byte[] byArray = new byte[]{127, 0, 0, 1};
        loopbackHost = new InetAddress("localhost", byArray);
        try {
            localHost = new InetAddress();
            InetAddress.localHost.hostName = impl.getLocalHostName();
            InetAddress.localHost.address = -1;
        }
        catch (Exception exception) {
            localHost = unknownAddress;
        }
        String string2 = "0.0.0.0";
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = new InetAddress(string2, unknownAddress.getAddress());
        InetAddress.cacheAddress(string2, unknown_array, -1L);
    }

    static final class CacheEntry {
        String hostname;
        Object address;
        long expiration;

        CacheEntry(String string, Object object, long l) {
            this.hostname = string;
            this.address = object;
            this.expiration = l;
        }
    }
}

