/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener {
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private DragSource dragSource;
    private DragSourceContextPeer peer;
    private DragGestureEvent trigger;
    private Cursor cursor;
    private Component component;
    private int actions;
    private int currentDropAction;
    private Image image;
    private Point offset;
    private Transferable transferable;
    private DragSourceListener listener;
    private boolean useCustomCursor = false;

    public DragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        this.peer = dragSourceContextPeer;
        if (this.peer == null) {
            throw new NullPointerException("DragSourceContextPeer");
        }
        this.trigger = dragGestureEvent;
        if (this.trigger == null) {
            throw new NullPointerException("Trigger");
        }
        this.dragSource = dragGestureEvent.getDragSource();
        if (this.dragSource == null) {
            throw new NullPointerException("DragSource");
        }
        this.component = dragGestureEvent.getComponent();
        if (this.component == null) {
            throw new NullPointerException("Component");
        }
        this.actions = dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions();
        if (this.actions == 0) {
            throw new IllegalArgumentException("source actions");
        }
        this.currentDropAction = dragGestureEvent.getDragAction();
        if (this.currentDropAction == 0) {
            throw new IllegalArgumentException("no drag action");
        }
        if (transferable == null) {
            throw new NullPointerException("Transferable");
        }
        if (dragSourceListener == null) {
            throw new NullPointerException("DragSourceListener");
        }
        if (this.image != null && point == null) {
            throw new NullPointerException("offset");
        }
        this.cursor = cursor;
        this.image = image;
        this.offset = point;
        this.transferable = transferable;
        this.listener = dragSourceListener;
        if (cursor != null) {
            this.useCustomCursor = true;
        }
        this.updateCurrentCursor(this.currentDropAction, this.actions, 0);
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Component getComponent() {
        return this.component;
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        return this.actions;
    }

    public void setCursor(Cursor cursor) {
        this.useCustomCursor = cursor != null;
        this.setCursorImpl(cursor);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public synchronized void addDragSourceListener(DragSourceListener dragSourceListener) throws TooManyListenersException {
        if (dragSourceListener == null) {
            return;
        }
        if (this.equals(dragSourceListener)) {
            throw new IllegalArgumentException("DragSourceContext may not be its own listener");
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = dragSourceListener;
    }

    public synchronized void removeDragSourceListener(DragSourceListener dragSourceListener) {
        if (this.listener == null || !this.listener.equals(dragSourceListener)) {
            throw new IllegalArgumentException();
        }
        this.listener = null;
    }

    public void transferablesFlavorsChanged() {
        if (this.peer != null) {
            this.peer.transferablesFlavorsChanged();
        }
    }

    public synchronized void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        if (this.listener != null) {
            this.listener.dragEnter(dragSourceDragEvent);
        }
        this.updateCurrentCursor(dragSourceDragEvent.getDropAction(), dragSourceDragEvent.getTargetActions(), 1);
    }

    public synchronized void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        if (this.listener != null) {
            this.listener.dragOver(dragSourceDragEvent);
        }
        this.updateCurrentCursor(dragSourceDragEvent.getDropAction(), dragSourceDragEvent.getTargetActions(), 2);
    }

    public synchronized void dragExit(DragSourceEvent dragSourceEvent) {
        if (this.listener != null) {
            this.listener.dragExit(dragSourceEvent);
        }
        this.updateCurrentCursor(this.currentDropAction, 0, 0);
    }

    public synchronized void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        this.currentDropAction = dragSourceDragEvent.getDropAction();
        if (this.listener != null) {
            this.listener.dropActionChanged(dragSourceDragEvent);
        }
        this.updateCurrentCursor(this.currentDropAction, dragSourceDragEvent.getTargetActions(), 3);
    }

    public synchronized void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (this.listener != null) {
            this.listener.dragDropEnd(dragSourceDropEvent);
        }
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected void updateCurrentCursor(int n, int n2, int n3) {
        if (this.useCustomCursor) {
            return;
        }
        Cursor cursor = null;
        switch (n3) {
            default: {
                n2 = 0;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        int n4 = n & n2;
        cursor = n4 == 0 ? ((n & 0x40000000) == 0x40000000 ? DragSource.DefaultLinkNoDrop : ((n & 2) == 2 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultCopyNoDrop)) : ((n4 & 0x40000000) == 0x40000000 ? DragSource.DefaultLinkDrop : ((n4 & 2) == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop));
        this.setCursorImpl(cursor);
    }

    private void setCursorImpl(Cursor cursor) {
        if (this.cursor == null || !this.cursor.equals(cursor)) {
            this.cursor = cursor;
            if (this.peer != null) {
                this.peer.setCursor(this.cursor);
            }
        }
    }
}

