/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.Serializable;

public abstract class ColorSpace
implements Serializable {
    private int type;
    private int numComponents;
    private static ColorSpace sRGBspace;
    private static ColorSpace XYZspace;
    private static ColorSpace PYCCspace;
    private static ColorSpace GRAYspace;
    private static ColorSpace LINEAR_RGBspace;
    public static final int TYPE_XYZ = 0;
    public static final int TYPE_Lab = 1;
    public static final int TYPE_Luv = 2;
    public static final int TYPE_YCbCr = 3;
    public static final int TYPE_Yxy = 4;
    public static final int TYPE_RGB = 5;
    public static final int TYPE_GRAY = 6;
    public static final int TYPE_HSV = 7;
    public static final int TYPE_HLS = 8;
    public static final int TYPE_CMYK = 9;
    public static final int TYPE_CMY = 11;
    public static final int TYPE_2CLR = 12;
    public static final int TYPE_3CLR = 13;
    public static final int TYPE_4CLR = 14;
    public static final int TYPE_5CLR = 15;
    public static final int TYPE_6CLR = 16;
    public static final int TYPE_7CLR = 17;
    public static final int TYPE_8CLR = 18;
    public static final int TYPE_9CLR = 19;
    public static final int TYPE_ACLR = 20;
    public static final int TYPE_BCLR = 21;
    public static final int TYPE_CCLR = 22;
    public static final int TYPE_DCLR = 23;
    public static final int TYPE_ECLR = 24;
    public static final int TYPE_FCLR = 25;
    public static final int CS_sRGB = 1000;
    public static final int CS_LINEAR_RGB = 1004;
    public static final int CS_CIEXYZ = 1001;
    public static final int CS_PYCC = 1002;
    public static final int CS_GRAY = 1003;

    protected ColorSpace(int n, int n2) {
        this.type = n;
        this.numComponents = n2;
    }

    public static ColorSpace getInstance(int n) {
        ColorSpace colorSpace;
        switch (n) {
            case 1000: {
                if (sRGBspace == null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(1000);
                    sRGBspace = new ICC_ColorSpace(iCC_Profile);
                }
                colorSpace = sRGBspace;
                break;
            }
            case 1001: {
                if (XYZspace == null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(1001);
                    XYZspace = new ICC_ColorSpace(iCC_Profile);
                }
                colorSpace = XYZspace;
                break;
            }
            case 1002: {
                if (PYCCspace == null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(1002);
                    PYCCspace = new ICC_ColorSpace(iCC_Profile);
                }
                colorSpace = PYCCspace;
                break;
            }
            case 1003: {
                if (GRAYspace == null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(1003);
                    GRAYspace = new ICC_ColorSpace(iCC_Profile);
                }
                colorSpace = GRAYspace;
                break;
            }
            case 1004: {
                if (LINEAR_RGBspace == null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(1004);
                    LINEAR_RGBspace = new ICC_ColorSpace(iCC_Profile);
                }
                colorSpace = LINEAR_RGBspace;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown color space");
            }
        }
        return colorSpace;
    }

    public boolean isCS_sRGB() {
        return this == sRGBspace;
    }

    public abstract float[] toRGB(float[] var1);

    public abstract float[] fromRGB(float[] var1);

    public abstract float[] toCIEXYZ(float[] var1);

    public abstract float[] fromCIEXYZ(float[] var1);

    public int getType() {
        return this.type;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getName(int n) {
        return new String("Unnamed color component(" + n + ")");
    }

    static boolean isCS_CIEXYZ(ColorSpace colorSpace) {
        return colorSpace == XYZspace;
    }
}

