/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;

public class SystemEventQueueUtilities {
    public static void invokeLater(Runnable runnable) {
        SystemEventQueueUtilities.postRunnable(runnable, null);
    }

    public static void invokeAndWait(final Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        Object object = new Object(){

            public String toString() {
                return "SwingUtilities.invokeAndWait() lock for " + runnable;
            }
        };
        Exception exception = null;
        Object object2 = object;
        synchronized (object2) {
            exception = SystemEventQueueUtilities.postRunnable(runnable, object);
            object.wait();
        }
        if (exception != null) {
            throw new InvocationTargetException(exception);
        }
    }

    private static Exception postRunnable(Runnable runnable, Object object) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        RunnableEvent runnableEvent = new RunnableEvent(runnable, object);
        eventQueue.postEvent(runnableEvent);
        return runnableEvent.exception;
    }

    private static void processRunnableEvent(RunnableEvent runnableEvent) {
        Object object = runnableEvent.lock;
        if (object == null) {
            runnableEvent.doRun.run();
        } else {
            Object object2 = object;
            synchronized (object2) {
                try {
                    try {
                        runnableEvent.doRun.run();
                    }
                    catch (Exception exception) {
                        runnableEvent.exception = exception;
                        Object var5_4 = null;
                        if (runnableEvent.lock != null) {
                            runnableEvent.lock.notify();
                        }
                    }
                    Object var5_3 = null;
                    if (runnableEvent.lock != null) {
                        runnableEvent.lock.notify();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (runnableEvent.lock != null) {
                        runnableEvent.lock.notify();
                    }
                    throw throwable;
                }
            }
        }
    }

    private static class RunnableTarget
    extends Component {
        RunnableTarget() {
            this.enableEvents(2999L);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof RunnableEvent) {
                SystemEventQueueUtilities.processRunnableEvent((RunnableEvent)aWTEvent);
            }
        }
    }

    private static class RunnableEvent
    extends AWTEvent {
        static final int EVENT_ID = 2999;
        static final Component target = new RunnableTarget();
        final Runnable doRun;
        final Object lock;
        Exception exception;

        RunnableEvent(Runnable runnable, Object object) {
            super(target, 2999);
            this.doRun = runnable;
            this.lock = object;
        }
    }
}

