/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.webclient.UnimplementedException;
import org.mozilla.webclient.wrapper_native.ISupportsPeer;
import org.mozilla.webclient.wrapper_native.RDFEnumeration;

public abstract class RDFTreeNode
extends ISupportsPeer
implements MutableTreeNode {
    protected int nativeRDFNode = -1;
    private RDFTreeNode parent;
    Properties properties = null;
    public int nativeWebShell = -1;

    protected RDFTreeNode(int n, int n2, RDFTreeNode rDFTreeNode) {
        this.nativeWebShell = n;
        this.nativeRDFNode = n2;
        this.parent = rDFTreeNode;
    }

    public Properties getProperties() {
        if (null == this.properties && null == (this.properties = new Properties())) {
            throw new IllegalStateException("Can't create properties table");
        }
        return this.properties;
    }

    protected abstract RDFTreeNode newRDFTreeNode(int var1, int var2, RDFTreeNode var3);

    int getNativeRDFNode() {
        return this.nativeRDFNode;
    }

    private void setNativeRDFNode(int n) {
        if (-1 != this.nativeRDFNode) {
            throw new IllegalStateException("Can't call setNativeRDFNode() more than once on an instance.");
        }
        this.nativeRDFNode = n;
    }

    protected void finalize() throws Throwable {
        if (-1 != this.nativeRDFNode) {
            this.nativeRelease(this.nativeRDFNode);
        }
        super.finalize();
    }

    public String toString() {
        String string = null;
        string = -1 != this.nativeRDFNode ? this.nativeToString(this.nativeWebShell, this.nativeRDFNode) : super.toString();
        return string;
    }

    public Enumeration children() {
        Assert.assert_it(-1 != this.nativeRDFNode);
        RDFEnumeration rDFEnumeration = null;
        rDFEnumeration = new RDFEnumeration(this.nativeWebShell, this);
        return rDFEnumeration;
    }

    public boolean getAllowsChildren() {
        throw new UnimplementedException("\nUnimplementedException-----\n API Function RDFTreeNode.getAllowsChildren() has not yet been implemented.\n");
    }

    public TreeNode getChildAt(int n) {
        int n2;
        Assert.assert_it(-1 != this.nativeRDFNode);
        RDFTreeNode rDFTreeNode = null;
        if (!this.isLeaf() && -1 != (n2 = this.nativeGetChildAt(this.nativeWebShell, this.nativeRDFNode, n))) {
            rDFTreeNode = this.newRDFTreeNode(this.nativeWebShell, n2, this);
        }
        return rDFTreeNode;
    }

    public int getChildCount() {
        Assert.assert_it(-1 != this.nativeRDFNode);
        int n = -1;
        n = this.nativeGetChildCount(this.nativeWebShell, this.nativeRDFNode);
        return n;
    }

    public int getIndex(TreeNode treeNode) {
        Assert.assert_it(-1 != this.nativeRDFNode);
        int n = -1;
        if (treeNode instanceof RDFTreeNode) {
            n = this.nativeGetIndex(this.nativeWebShell, this.nativeRDFNode, ((RDFTreeNode)treeNode).nativeRDFNode);
        }
        return n;
    }

    public TreeNode getParent() {
        Assert.assert_it(-1 != this.nativeRDFNode);
        return this.parent;
    }

    public boolean isLeaf() {
        Assert.assert_it(-1 != this.nativeRDFNode);
        return this.nativeIsLeaf(this.nativeWebShell, this.nativeRDFNode);
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!(mutableTreeNode instanceof RDFTreeNode)) {
            throw new IllegalArgumentException("Can't insert non-RDFTreeNode children");
        }
        Assert.assert_it(-1 != this.nativeRDFNode);
        RDFTreeNode rDFTreeNode = (RDFTreeNode)mutableTreeNode;
        if (rDFTreeNode.isFolder()) {
            Assert.assert_it(-1 == rDFTreeNode.getNativeRDFNode());
            Assert.assert_it(null != rDFTreeNode.getProperties());
            int n2 = this.nativeNewFolder(this.nativeWebShell, this.nativeRDFNode, rDFTreeNode.getProperties());
            rDFTreeNode.setNativeRDFNode(n2);
        } else {
            Assert.assert_it(-1 != rDFTreeNode.getNativeRDFNode());
            int n3 = rDFTreeNode.getNativeRDFNode();
            this.nativeInsertElementAt(this.nativeWebShell, this.nativeRDFNode, n3, rDFTreeNode.getProperties(), n);
        }
        rDFTreeNode.setParent(this);
    }

    public void remove(int n) {
        throw new UnimplementedException("\nUnimplementedException-----\n API Function RDFTreeNode.remove(int) has not yet been implemented.\n");
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        throw new UnimplementedException("\nUnimplementedException-----\n API Function RDFTreeNode.remove(MutableTreeNode) has not yet been implemented.\n");
    }

    public void removeFromParent() {
        throw new UnimplementedException("\nUnimplementedException-----\n API Function RDFTreeNode.removeFromParent() has not yet been implemented.\n");
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode instanceof RDFTreeNode) {
            this.parent = (RDFTreeNode)mutableTreeNode;
        }
    }

    public void setUserObject(Object object) {
        throw new UnimplementedException("\nUnimplementedException-----\n API Function RDFTreeNode.setUserObject(Object) has not yet been implemented.\n");
    }

    public boolean isFolder() {
        boolean bl = false;
        if (-1 == this.nativeRDFNode) {
            if (null != this.getProperties()) {
                bl = null != ((Hashtable)this.getProperties()).get("IsFolder");
            }
        } else {
            bl = this.nativeIsContainer(this.nativeWebShell, this.getNativeRDFNode());
        }
        return bl;
    }

    public native boolean nativeIsLeaf(int var1, int var2);

    public native boolean nativeIsContainer(int var1, int var2);

    public native int nativeGetChildAt(int var1, int var2, int var3);

    public native int nativeGetChildCount(int var1, int var2);

    public native int nativeGetIndex(int var1, int var2, int var3);

    public native String nativeToString(int var1, int var2);

    public native void nativeInsertElementAt(int var1, int var2, int var3, Properties var4, int var5);

    public native int nativeNewFolder(int var1, int var2, Properties var3);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("RDFTreeNode");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: RDFTreeNode.java,v 1.5 2001/05/29 18:36:11 ashuk%eng.sun.com Exp $");
    }
}

