/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.util.Enumeration;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.webclient.wrapper_native.RDFTreeNode;

public class RDFEnumeration
implements Enumeration {
    private int nativeRDFNode = -1;
    private RDFTreeNode parent;
    private int nativeEnum = -1;
    private int nativeContainer = -1;
    public int nativeWebShell = -1;

    public RDFEnumeration(int n, RDFTreeNode rDFTreeNode) {
        this.nativeWebShell = n;
        this.parent = rDFTreeNode;
        this.nativeRDFNode = this.parent.getNativeRDFNode();
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize(this.nativeWebShell);
        super.finalize();
    }

    public boolean hasMoreElements() {
        Assert.assert_it(-1 != this.nativeRDFNode);
        return this.nativeHasMoreElements(this.nativeWebShell, this.nativeRDFNode);
    }

    public Object nextElement() {
        Assert.assert_it(null != this.parent);
        RDFTreeNode rDFTreeNode = null;
        int n = this.nativeNextElement(this.nativeWebShell, this.nativeRDFNode);
        if (-1 != n) {
            rDFTreeNode = this.parent.newRDFTreeNode(this.nativeWebShell, n, this.parent);
        }
        return rDFTreeNode;
    }

    private native boolean nativeHasMoreElements(int var1, int var2);

    private native int nativeNextElement(int var1, int var2);

    protected native void nativeFinalize(int var1);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("RDFEnumeration");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: RDFEnumeration.java,v 1.3 2001/05/29 18:36:11 ashuk%eng.sun.com Exp $");
    }
}

