/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.util.Properties;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.PrefChangedCallback;
import org.mozilla.webclient.Preferences;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_native.ImplObjectNative;

public class PreferencesImpl
extends ImplObjectNative
implements Preferences {
    private Properties props = null;

    public PreferencesImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl);
    }

    public void delete() {
    }

    public void setPref(String string, String string2) {
        if (null == string) {
            return;
        }
        if (null == string2) {
            return;
        }
        try {
            Integer n = Integer.valueOf(string2);
            this.nativeSetIntPref(this.nativeWebShell, string, n);
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.equals("true") || string2.equals("false")) {
                Boolean bl = Boolean.valueOf(string2);
                this.nativeSetBoolPref(this.nativeWebShell, string, bl);
            }
            this.nativeSetUnicharPref(this.nativeWebShell, string, string2);
        }
    }

    public Properties getPrefs() {
        this.props = this.nativeGetPrefs(this.nativeWebShell, this.props);
        return this.props;
    }

    public void registerPrefChangedCallback(PrefChangedCallback prefChangedCallback, String string, Object object) {
        ParameterCheck.nonNull(prefChangedCallback);
        ParameterCheck.nonNull(string);
        this.nativeRegisterPrefChangedCallback(this.nativeWebShell, prefChangedCallback, string, object);
    }

    public native void nativeSetUnicharPref(int var1, String var2, String var3);

    public native void nativeSetIntPref(int var1, String var2, int var3);

    public native void nativeSetBoolPref(int var1, String var2, boolean var3);

    public native Properties nativeGetPrefs(int var1, Properties var2);

    public native void nativeRegisterPrefChangedCallback(int var1, PrefChangedCallback var2, String var3, Object var4);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("PreferencesImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: PreferencesImpl.java,v 1.3 2001/05/29 18:36:10 ashuk%eng.sun.com Exp $");
        try {
            BrowserControlFactory.setAppData(stringArray[0]);
            BrowserControl browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            Preferences preferences = (Preferences)browserControl.queryInterface("webclient.WindowControl");
            Assert.assert_it(preferences != null);
        }
        catch (Exception exception) {
            System.out.println("got exception: " + exception.getMessage());
        }
    }
}

