/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.util;

import java.awt.Component;
import java.awt.Container;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.util.Log;

public class Utilities {
    public static Vector vectorFromString(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public static String stringFromVector(Vector vector, String string) {
        String string2 = null;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            if (string == null) {
                string = "";
            }
            while (enumeration.hasMoreElements()) {
                string2 = string2 == null ? "" : string2 + string;
                string2 = string2 + enumeration.nextElement();
            }
        }
        return string2 == null ? "" : string2;
    }

    public static Vector vectorFromArray(Object[] objectArray) {
        Vector<Object> vector;
        if (objectArray != null && objectArray.length > 0) {
            vector = new Vector(objectArray.length);
            int n = objectArray.length - 1;
            while (n >= 0) {
                vector.addElement(objectArray[n]);
                --n;
            }
        } else {
            vector = new Vector<Object>(0);
        }
        return vector;
    }

    public static boolean vectorsAreEqual(Vector vector, Vector vector2) {
        int n;
        boolean bl = vector.equals(vector2);
        if (!bl && vector != null && vector2 != null && (n = vector.size()) == vector2.size()) {
            int n2 = 0;
            while (n2 < n) {
                if (!vector.elementAt(n2).equals(vector2.elementAt(n2))) break;
                ++n2;
            }
            if (n2 == n) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean arrayContainsElement(Object[] objectArray, Object object) {
        boolean bl = false;
        if (objectArray != null) {
            int n = 0;
            while (!bl && n < objectArray.length) {
                if (objectArray[n].equals(object)) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    public static String removeAllWhitespace(String string) {
        String string2 = string;
        if (string != null) {
            string2 = string.trim();
            Vector vector = Utilities.vectorFromString(string, " ");
            string2 = Utilities.stringFromVector(vector, "");
        }
        return string2;
    }

    public static String currentTimeString(boolean bl, boolean bl2) {
        String string = new Date().toString().substring(11, 19);
        if (!bl) {
            Vector vector = Utilities.vectorFromString(string, ":");
            try {
                String string2;
                int n = Integer.parseInt((String)vector.elementAt(0));
                if (n > 12) {
                    string2 = "pm";
                    vector.setElementAt(Integer.toString(n -= 12), 0);
                    string = Utilities.stringFromVector(vector, ":");
                } else {
                    string2 = n == 12 ? "pm" : "am";
                }
                if (bl2) {
                    string = string + string2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    public static Component getTopLevelParent(Component component) {
        Component component2 = component;
        if (component != null) {
            Component component3 = component;
            do {
                if (component3 instanceof Container) {
                    component2 = component3;
                    component3 = ((Container)component3).getParent();
                    continue;
                }
                component3 = null;
            } while (component3 != null);
        }
        return component2;
    }

    public static String getPackageName(Class clazz) {
        if (null == clazz) {
            return null;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(0, n + 1);
    }

    public static ResourceBundle getResourceBundle(String string) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.logError("Missing resource bundle: " + string);
        }
        return resourceBundle;
    }

    public static boolean endsWithIgnoringCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (string.length() < n) {
            return false;
        }
        return string.regionMatches(true, string.length() - n, string2, 0, n);
    }
}

