/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.util;

import java.io.Serializable;
import org.mozilla.util.ParameterCheck;

public class Range
implements Cloneable,
Serializable {
    private static final String RCSID = "$Id: Range.java,v 1.2 1999/11/06 02:25:56 dmose%mozilla.org Exp $";
    public static final Range ZeroRange = new Range(-1, 0);
    protected int start;
    protected int count;

    public Range(Range range) {
        ParameterCheck.nonNull(range);
        this.start = range.getStart();
        this.count = range.getCount();
    }

    public Range(int n, int n2) {
        this.start = n;
        this.count = n2;
    }

    public synchronized int getStart() {
        return this.start;
    }

    public synchronized int getCount() {
        return this.count;
    }

    public synchronized int getEnd() {
        return this.getStart() + this.getCount() - 1;
    }

    public synchronized int getMax() {
        return this.getStart() + this.getCount();
    }

    protected int getConstrainedInt(int n) {
        int n2 = n < this.getStart() ? this.getStart() : (n > this.getEnd() ? this.getEnd() : n);
        return n2;
    }

    public synchronized boolean containsIndex(int n) {
        if (this.getCount() == 0) {
            return false;
        }
        return n >= this.getStart() && n <= this.getEnd();
    }

    public synchronized boolean isAfterIndex(int n) {
        return this.getStart() > n;
    }

    public synchronized boolean isBeforeIndex(int n) {
        return this.getEnd() < n;
    }

    public synchronized boolean containsRange(Range range) {
        ParameterCheck.nonNull(range);
        if (this.getCount() == 0) {
            return false;
        }
        if (range.getCount() == 0) {
            return true;
        }
        return this.getStart() <= range.getStart() && this.getEnd() >= range.getEnd();
    }

    public synchronized boolean intersectsWithRange(Range range) {
        return this.overlapWithRange(range) > 0;
    }

    public synchronized int overlapWithRange(Range range) {
        if (this.getCount() == 0 || range.getCount() == 0) {
            return 0;
        }
        return Math.max(0, Math.min(this.getEnd(), range.getEnd()) - Math.max(this.getStart(), range.getStart()) + 1);
    }

    public synchronized boolean isAdjacentToRange(Range range) {
        ParameterCheck.nonNull(range);
        if (this.getCount() == 0 || range.getCount() == 0) {
            return false;
        }
        return Math.max(this.getStart(), range.getStart()) == Math.min(this.getEnd(), range.getEnd()) + 1;
    }

    public synchronized boolean isBeforeRange(Range range) {
        ParameterCheck.nonNull(range);
        return this.getEnd() < range.getStart();
    }

    protected boolean isAfterRange(Range range) {
        ParameterCheck.nonNull(range);
        return range.isBeforeRange(this);
    }

    public synchronized Range rangeFromIntersection(Range range) {
        ParameterCheck.nonNull(range);
        if (this.intersectsWithRange(range)) {
            int n = Math.max(this.getStart(), range.getStart());
            int n2 = Math.min(this.getEnd(), range.getEnd());
            return new Range(n, n2 - n + 1);
        }
        return ZeroRange;
    }

    public synchronized Range rangeFromUnion(Range range) {
        Range range2;
        ParameterCheck.nonNull(range);
        int n = this.getCount();
        int n2 = range.getCount();
        if (n == 0 && n2 == 0) {
            range2 = ZeroRange;
        } else if (n == 0) {
            range2 = new Range(range);
        } else if (n2 == 0) {
            range2 = new Range(this);
        } else {
            int n3 = Math.min(this.getStart(), range.getStart());
            int n4 = Math.max(this.getEnd(), range.getEnd());
            return new Range(n3, n4 - n3 + 1);
        }
        return range2;
    }

    public synchronized Range rangeShiftedByOffset(int n) {
        return new Range(this.getStart() + n, this.getCount());
    }

    public synchronized String toString() {
        return "start = " + this.getStart() + ", count = " + this.getCount();
    }

    public boolean isMutable() {
        return false;
    }

    public synchronized Object clone() {
        if (this.isMutable()) {
            Range range;
            try {
                range = (Range)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.toString());
            }
            return range;
        }
        return this;
    }

    public synchronized boolean equals(Object object) {
        return object == this || object != null && object instanceof Range && this.getStart() == ((Range)object).getStart() && this.getEnd() == ((Range)object).getEnd();
    }

    public synchronized int hashCode() {
        return Math.round(this.getStart()) ^ Math.round(this.getCount());
    }
}

