/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.dom.NodeEventListener;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeImpl
implements Node,
EventTarget {
    private long p_nsIDOMNode = 0L;
    private static Hashtable javaDOMlisteners = new Hashtable();

    protected NodeImpl() {
    }

    protected NodeImpl(long l) {
        this.p_nsIDOMNode = l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeImpl)) {
            return false;
        }
        return this.XPCOM_equals(object);
    }

    public int hashCode() {
        return this.XPCOM_hashCode();
    }

    public String toString() {
        return "<" + this.getNodeName() + " t=" + NodeImpl.nodeTypeString(this.getNodeType()) + " c=org.mozilla.dom.NodeImpl p=" + Long.toHexString(this.p_nsIDOMNode) + ">";
    }

    private static String nodeTypeString(int n) {
        switch (n) {
            case 1: {
                return "ELEMENT";
            }
            case 2: {
                return "ATTRIBUTE";
            }
            case 3: {
                return "TEXT";
            }
            case 4: {
                return "CDATA_SECTION";
            }
            case 5: {
                return "ENTITY_REFERENCE";
            }
            case 6: {
                return "ENTITY";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION";
            }
            case 8: {
                return "COMMENT";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 10: {
                return "DOCUMENT_TYPE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT";
            }
            case 12: {
                return "NOTATION";
            }
        }
        return "ERROR";
    }

    public native boolean isSupported(String var1, String var2);

    public native boolean hasAttributes();

    public native Node appendChild(Node var1) throws DOMException;

    public native Node cloneNode(boolean var1);

    public native NamedNodeMap getAttributes();

    public native NodeList getChildNodes();

    public native Node getFirstChild();

    public native Node getLastChild();

    public native Node getNextSibling();

    public native String getNodeName();

    public native short getNodeType();

    public native String getNodeValue();

    public native Document getOwnerDocument();

    public native Node getParentNode();

    public native Node getPreviousSibling();

    public native boolean hasChildNodes();

    public native Node insertBefore(Node var1, Node var2) throws DOMException;

    public native Node removeChild(Node var1) throws DOMException;

    public native Node replaceChild(Node var1, Node var2) throws DOMException;

    public native void setNodeValue(String var1);

    protected native void finalize();

    private native boolean XPCOM_equals(Object var1);

    private native int XPCOM_hashCode();

    public native boolean supports(String var1, String var2);

    public native String getNamespaceURI();

    public native String getPrefix();

    public native void setPrefix(String var1);

    public native String getLocalName();

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        Vector<NodeEventListener> vector;
        long l = this.addNativeEventListener(string, eventListener, bl);
        Long l2 = new Long(this.p_nsIDOMNode);
        Hashtable hashtable = javaDOMlisteners;
        synchronized (hashtable) {
            vector = (Vector<NodeEventListener>)javaDOMlisteners.get(l2);
            if (vector == null) {
                vector = new Vector<NodeEventListener>();
                javaDOMlisteners.put(l2, vector);
            }
        }
        if (l != 0L) {
            NodeEventListener nodeEventListener = new NodeEventListener(string, eventListener, bl, l);
            vector.add(nodeEventListener);
        }
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        Vector vector = (Vector)javaDOMlisteners.get(new Long(this.p_nsIDOMNode));
        if (vector == null) {
            return;
        }
        NodeEventListener nodeEventListener = new NodeEventListener(string, eventListener, bl, 0L);
        int n = vector.indexOf(nodeEventListener);
        if (n == -1) {
            return;
        }
        nodeEventListener = (NodeEventListener)vector.remove(n);
        this.removeNativeEventListener(string, nodeEventListener.nativeListener, bl);
    }

    public boolean dispatchEvent(Event event) throws DOMException {
        throw new UnsupportedOperationException();
    }

    private native long addNativeEventListener(String var1, EventListener var2, boolean var3);

    private native void removeNativeEventListener(String var1, long var2, boolean var4);

    public void normalize() {
        throw new UnsupportedOperationException();
    }
}

