/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;

namespace LocaleInpector
{

internal sealed class Keys
{

private Keys()
{
}

public static Status Check(string originalDir, string translatedDir)
{
    Output.OpenH1("Key parity");
    Status stat = new Status();


    List<string> fileList = BPIO.GetFileList(originalDir, "*");
    for (int idx = 0; idx < fileList.Count; idx++) {
        stat.Add(CompareKeyFile(originalDir, translatedDir, fileList[idx]));
    }

    Output.WriteLine("Original files have " + stat.Comparisons.ToString() + " keys (" + stat.Files.ToString() +" files analysed).");

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}

private static Status CompareKeyFile(string originalDir, string translatedDir, string file)
{
    Status stat = new Status();
    NameValueFile originalFile = NameValueFile.Load(originalDir + file);
    if (originalFile == null) {
        // unknown format (binary, html, ...)
        return stat;
    }

    Dictionary<string, string> originalKeys = originalFile.LoadHashtableLogged();
    stat.Files++;
    stat.Comparisons += originalKeys.Count;


    NameValueFile translatedFile = NameValueFile.LoadTranslated(translatedDir + file);
    Dictionary<string, string> translatedKeys;
    if (translatedFile == null) {
        // translated file is empty
        translatedKeys = new Dictionary<string, string>();
    } else {
        translatedKeys = translatedFile.LoadHashtableLogged();
    }


    // loop em translatedFile: alguma não existe em originalFile?
    Dictionary<string, string>.Enumerator translatedKeyNames = translatedKeys.GetEnumerator();
    while (translatedKeyNames.MoveNext()) {
        if (originalKeys.ContainsKey(translatedKeyNames.Current.Key) == false) {
            // key em translatedFile está sobrando
            if (file.EndsWith(".inc")) {
                // LOCALE_HAS_HELP etc aren't errors
                Output.WriteWarning("Extra key at " + file + " => " + translatedKeyNames.Current.Key);
                stat.Warnings++;
            } else {
                Output.WriteLine("ERROR:   Extra key at " + file + " => " + translatedKeyNames.Current.Key);
                stat.Errors++;
            }
        }
    }

    // loop em originalFile: alguma não existe em translatedFILE?
    Dictionary<string, string>.Enumerator originalKeyNames = originalKeys.GetEnumerator();
    while (originalKeyNames.MoveNext()) {
        if (translatedKeys.ContainsKey(originalKeyNames.Current.Key) == false) {
            // há uma chave em originalFile que não existe em translatedFile: falta uma key em translatedFile
            Output.WriteLine("ERROR: Missing key at " + file + " => " + originalKeyNames.Current.Key);
            stat.Errors++;
        }
    }

    return stat;
}

}//class
}//ns