
     /*      **
    * *       *
      *    ** *  Window-Q 0.1d : rue + Jordan
      *   *  **
 *  *****  ** */



// moz1.3.1 doesn't do anything if the listener isn't set to capture
//   -- further, we can't remove a listener if it has inline-code.
function wqClickParse(evt) { if (evt.originalTarget.ownerDocument && !evt.originalTarget.ownerDocument.defaultView.wqMainWindow) WindowQ.parseFrames(evt.originalTarget.ownerDocument.defaultView.top); } // replace window.open() for all (sub)contexts
function wqLoadParse(evt) { if (evt.originalTarget.defaultView && !evt.originalTarget.defaultView.wqMainWindow) WindowQ.parseFrames(evt.originalTarget.defaultView.top); } // replace window.open() for all (sub)contexts
function wqActivityMonitor(evt) { WindowQ.activityMonitor(evt); } // check that the user initiated the window-open call
function wqLoadPtII(evt) { WindowQ.loadPtII(); }

/*
** Main Routine
*/

var WindowQ = {
	
	// Called after obj-init (below)
	load: function() {
		this.console = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
		
		// attach listeners
		window.wqMainWindow = true;
		window.addEventListener('load', wqLoadParse, true); // (sub)document-load listener
		window.getBrowser().addEventListener("mousedown", wqClickParse, true); // user-click listener
		
		// pref-override
		this.setPrefs(); // set built-in suppression prefs
		
		// so we know if an "unrequested" popup should be allowed
		this.cd = window.top.document.commandDispatcher;

		// for JS-links
		this.scriptLoader = Components.classes["@mozilla.org/moz/jssubscript-loader;1"].createInstance(Components.interfaces.mozIJSSubScriptLoader);
		
		// start activity-monitor
		this.initActivityMonitor(); // from this, we call loadPtII()
	},
	
	initActivityMonitor: function() {
		var prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
		this.allowed = prefService.prefHasUserValue("dom.popup_allowed_events") ? 
				prefService.getCharPref("dom.popup_allowed_events").toLowerCase()
				:
				"change keypress click dblclick reset submit"; // our allowed "opens-a-window" events

		if (this.allowed === null) this.allowed = "change keypress click dblclick reset submit"; // XXX Remove ?

		window.addEventListener("load", wqLoadPtII, true);
	},

	loadPtII: function() {
		window.removeEventListener("load", wqLoadPtII, true);
		var allowedString = WindowQ.allowed;
		if (allowedString.indexOf("click") != -1) allowedString += " mousedown"; // we need to listen for mousedown first, to trap link-local onclick handlers
		var allowedArray = allowedString.split(" ");
		for (var r = 0 ; r < allowedArray.length ; r++)
			window.getBrowser().addEventListener(allowedArray[r], wqActivityMonitor, true);

		// Universal handling for newTabWith  (-- moz + firefox)
		var newTabWith_Params = openNewTabWith.toString().match(/openNewTabWith\s*\(([^\)]+)\)/i)[1]; // [0] is whole match, [1..n] the backrefs
		var replacementValues = 
				{"url":"href", "sendReferrer":"true", "reverseBackgroundPref":"event.shiftKey", // old-style mozilla
				 "securityCheck":"true", "postData":"null"}; // new-style firefox
		for (var n in replacementValues) newTabWith_Params = newTabWith_Params.replace(new RegExp(n), replacementValues[n]);
		this.newTabWith_Content = "openNewTabWith("+newTabWith_Params+");";

		// Universal conversion:  newWindowWith -> newTabWith   (-- moz + firefox)
		newTabWith_Params = openNewTabWith.toString().match(/openNewTabWith\s*\(([^\)]+)\)/i)[1].split(","); // [0] is whole match, [1..n] the backrefs
		var newWindowWith_Params = openNewWindowWith.toString().match(/openNewWindowWith\s*\(([^\)]+)\)/i)[1].split(","); // [0] is whole match, [1..n] the backrefs
		for (var t in newTabWith_Params) newTabWith_Params[t].replace(/\s+/g, "");
		for (var w in newWindowWith_Params) newWindowWith_Params[w].replace(/\s+/g, "");
		var passedParams = {};
		for (var a in newWindowWith_Params) passedParams[ newWindowWith_Params[a] ] = "arguments["+a+"]";
		for (var s in newTabWith_Params) newTabWith_Params[s] = passedParams[ newTabWith_Params[s] ] ?
				passedParams[ newTabWith_Params[s] ] : "null";
		this.newTabWith_FromWindow = "openNewTabWith("+newTabWith_Params.join(", ")+");";
		
		// function override
		this.origContentAreaClick = window.contentAreaClick;   // backup the original
		window.contentAreaClick = this.contentClick;           // see ya -!
		this.origOpenNewWindowWith = window.openNewWindowWith; // backup the original
		window.openNewWindowWith = this.newWindow;             // cheers
	},
	
	activityMonitor: function(evt) {
		if (typeof(evt.type) == 'undefined') return;
		
		var view = window._content || window.getBrowser().selectedBrowser.contentWindow;
		if (typeof(view.wqAllowed) == "undefined") view.wqAllowed = WindowQ.allowed;
		else if (view.wqActivityWipe) { view.clearTimeout(view.wqActivityWipe); delete view.wqActivityWipe; }
		
		view._recordedEvent = evt.type;
		view.wqActivityWipe = view.setTimeout("delete _recordedEvent",3000); // we allow 3secs for a "good" event to trigger a popup
	},
	
	// Replacement for openNewWindowWith()
	newWindow: function() {
		eval(WindowQ.newTabWith_FromWindow);
	},
	
	// Replacement for contentAreaClick()
	contentClick: function(event, fieldNormalClicks, s1, s2, s3, s4, s5) {
		WindowQ.activityMonitor(event);
		var linkNode = event.target;

		var isLink = ("alinkarea".indexOf(linkNode.localName.toLowerCase()) != -1);
		if (!isLink || (isLink && !linkNode.hasAttribute("href")) )
			linkNode = findParentNode(event.originalTarget, "a");
			
		if (linkNode && linkNode.hasAttribute("href")) {
			var targetName = linkNode.getAttribute("target");
			var href = linkNode.href;
				
			if (!targetName) {
				var focusedDocument = document.commandDispatcher.focusedWindow.document;
				if (focusedDocument) var base = focusedDocument.getElementsByTagName("base");
				if (base && base.length > 0) targetName = base[0].getAttribute("target"); }
			
			var willOpenNew = (targetName
					&& ! (targetName.toLowerCase() in {_self:null,_parent:null,_top:null,_content:null,_main:null}) // odd - i found a site using "_Blank"
					&& ! WindowQ.targetCheck(document.commandDispatcher.focusedWindow.top, targetName) )
				? true : false;
			var newOnMiddleClick = WindowQ.openTabForBranch.prefHasUserValue("middleclick") && WindowQ.openTabForBranch.getBoolPref("middleclick"); // default: false
			var isSpecial =   ((linkNode && linkNode.getAttribute("rel") == "sidebar") || (targetName && targetName == "_search")); // sidebar-calls are routed to special-handling in origContentAreaClicks()
			var unmodified =  (!event.ctrlKey && !event.shiftKey && !event.altKey);
			var normalClick = (event.button == 0 && !event.metaKey && unmodified);
			var middleClick = ((event.button == 0 &&  event.metaKey) || (event.button == 1 && !event.metaKey)) && unmodified; // mac and win - respectively
			var jsLinkRe = /^javascript\:/i;
			var isJSLink = jsLinkRe.test(href);
			
			if (isJSLink && !isSpecial /*&& middleClick*/) {
				var getFalse = function() {return false;};
				event.button  getter = function() {return 0;};
				event.ctrlKey getter = getFalse; event.shiftKey getter = getFalse; event.altKey getter = getFalse; event.metaKey getter = getFalse; }
		}
		else { linkNode = null, href = null; }

		// Custom-handler -> leave alone
		if (linkNode && linkNode.hasAttribute("onclick") && linkNode.getAttribute("onclick"))
			return true;
		// Normal Link + Opening New -> add tab
		else if (linkNode && !isJSLink && !isSpecial && ((normalClick && willOpenNew) || (middleClick && newOnMiddleClick))) { // && openNewTabOrWindow(event, href, true)) { 
			eval(WindowQ.newTabWith_Content);
			event.preventDefault(); event.preventBubble(); event.preventCapture(); event.stopPropagation(); 
			return true; 
		}
		// JS Link -> eval in page
		else if (linkNode && isJSLink && !isSpecial) {
			urlSecurityCheck(href, document);
			if (typeof(markLinkVisited) != 'undefined' && linkNode && linkNode.href) eval("markLinkVisited(linkNode.href, linkNode);"); // avoid re-declaring if it exists
			var pageView = linkNode.ownerDocument.defaultView; if (typeof(pageView._wqScripts) == 'undefined') pageView._wqScripts = []; 
			pageView._wqScripts.push(href.replace(jsLinkRe,""));
			WindowQ.scriptLoader.loadSubScript("chrome://windowq/content/windowQ-supplement.js", pageView);
			event.preventDefault(); event.preventBubble(); event.preventCapture(); event.stopPropagation(); 
			return true; 
		}
		// Anything Else -> pass-thru
		else
			return WindowQ.origContentAreaClick(event, fieldNormalClicks, s1, s2, s3, s4, s5); // per return: we're masquerading as this in the first place, remember
	},

	// Checks if a link's target matches any document frame
	targetCheck: function(wnd, targetName) {
		//var x = function(i) { return (i==10 || i==3?i:x(++i)); }; alert(x(0))
		for (var i = 0, match=false; i < wnd.frames.length && !match ; i++)
			match = wnd.frames[i].name == targetName ||
					( wnd.frames[i].frames.length > 0
						&& this.targetCheck(wnd.frames[i], targetName) );

		return match;
	},

	// Set built-in prefs
	setPrefs: function() {
		this.prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
		this.openTabForBranch = this.prefService.getBranch("browser.tabs.opentabfor.");
		this.blockBranch = this.prefService.getBranch("browser.block.");
		this.domBranch = this.prefService.getBranch("dom.");
		//blockBranch.setBoolPref("target_new_window", true); // target-links will load in current tab
			//blockBranch.setBoolPref("target_new_window", false); // our modified window-open code will handle this
		this.domBranch.setBoolPref("disable_open_during_load", true); // enable popup-suppression
		//this.newOnMiddleClick = this.openTabForBranch.prefHasUserValue("middleclick") && this.openTabForBranch.getBoolPref("middleclick"); // default: false
		this.enabled = this.openTabForBranch.prefHasUserValue("windowopen") && this.openTabForBranch.getBoolPref("windowopen"); // default: false
	},
		
	// Disable Window-Q
	unload: function() {
		window.removeEventListener('load', wqLoadParse, true); // (sub)document-load listener
		window.getBrowser().removeEventListener("mousedown", wqClickParse, true); // user-click listener
		var allowedArray = WindowQ.allowed.split(" ");
		for (var r = 0 ; r < allowedArray.length ; r++)
			window.getBrowser().removeEventListener(allowedArray[r], wqActivityMonitor, true);
	},
	
	// Replace window.open for all sub-contexts
	parseFrames: function(wnd) {
		if (!wnd.wqLoaded) {
			wnd.open = this.dock;
			wnd.wqLoaded = true; }
		for (var i=0; i<wnd.frames.length; i++)
			this.parseFrames(wnd.frames[i]); // recurse
	},
	
	// Dock this window
	dock: function(url, name, flags) {
		var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
		var baseURI  = ioService.newURI(this.document.URL, null, null);
		var urlObj = ioService.newURI(baseURI.resolve(url), null, null);

		if (!this.frameElement) var view = this;
		else if (this.top && this.top.top) view = this.top; // if the site plays nice
		else if (this._WindowQTop) view = this._WindowQTop; // if we've already been here
		else {
			var origView = this, view = this;
			while (view.frameElement) view = view.frameElement.ownerDocument.defaultView; // climb to the top
			origView._WindowQ = view; } // and report back, safely :P

		// so we know if an "unrequested" window should be allowed
		if (typeof(view._recordedEvent) == 'undefined') { // activityMonitor didn't see anything
			var popupManager = Components.classes["@mozilla.org/PopupWindowManager;1"].getService(Components.interfaces.nsIPopupWindowManager); 
			if (popupManager.testPermission(urlObj) == popupManager.DENY_POPUP) return; }
		else { 
			view.clearTimeout(view.wqActivityWipe); delete view.wqActivityWipe; delete view._recordedEvent; }
		
		var prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
		var rootBranch = prefService.getBranch(null);
		var referrerObj = baseURI; // getReferrer(window.getBrowser().ownerDocument);
		var shouldDock = rootBranch.getBoolPref("browser.tabs.opentabfor.windowopen");
		var allowFocus = ! rootBranch.getBoolPref("browser.tabs.loadInBackground");
		
		if (!shouldDock) {
			var browserChromeUrl = rootBranch.getCharPref('browser.chromeURL');
			return window.openDialog(browserChromeUrl, name, "chrome,all,dialog=no,"+flags, urlObj.spec, null, referrerObj, null); }

		//if (urlObj.scheme == "chrome") { this.WindowQ.openChrome(url, name, flags, arg1, arg2, arg3, arg4, arg5, arg6); return; }
		
		var newTab = window.getBrowser().addTab(urlObj.spec, referrerObj);
		if (allowFocus) window.getBrowser().selectedTab = newTab;
		var newBrowser = window.getBrowser().getBrowserForTab(newTab);
		var newView = newBrowser.contentWindow;
		newView._wqTab = newTab;
		if (!newView.close) {
			// add higher-level "window controls" so our opener can handle us
			newView.wqObj = {
				close: function() { if (this.parentNode) {this.closed = true; window.getBrowser().removeTab(this._wqTab);} }, // where "this" is the tab-view we've been called on
				focus: function() { if (this.parentNode) window.getBrowser().selectedTab = this._wqTab; },
				empty: function() { }
			};
			newView.close = newView.wqObj.close;
			newView.focus = (allowFocus) ? newView.wqObj.focus : newView.wqObj.empty;
		}
		//newBrowser.contentDocument.defaultView.opener = this; // set tab's opener to current (sub)document context
		newView.opener = this; // set tab-view's opener to current (sub)document context
		
		/* TBE 
		//w = b.getBrowserForTab(t).contentDocument.defaultView;
		w = t.mBrowser.contentDocument.defaultView;
		w.opener = contextWindow;*/
		
		return newView; // send back the new tab-view
	}
	

};

WindowQ.load();