
    /**     **
       *     *
      *   ** *  Session Saver 0.2d : Pike + rue
     *   *  **
 *  ****  ** */



/*
** Main object
*/

var SessionSaver = {
	
	// Pref-branch properties
	prefBranch: 'sessionsaver.',
	prefBranchWindows: 'windows.', // the "live" capture of the current session
	prefBranchStatic: 'static.', // all manually captured sessions
	staticBranchDefault: 'default.', // the default manual-session
	prefBranchSettings: 'settings.',

	// Called when window first loads
	onLoad: function(evt) {
	
		window.removeEventListener('load', ssLoad, true); // remove startup-check (only run once)
		
		// Setup object properties
		this.windowMediator = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator); // for getWindows()
		this.observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
		this.prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
		this.rootBranch = this.prefService.getBranch(null);
		this.Branch = this.prefService.getBranch(this.prefBranch);
		this.windowBranch = this.prefService.getBranch(this.prefBranch + this.prefBranchWindows);
		this.staticBranch = this.prefService.getBranch(this.prefBranch + this.prefBranchStatic);
		this.settingsBranch = this.prefService.getBranch(this.prefBranch + this.prefBranchSettings);
		this.browserChromeUrl = this.rootBranch.getCharPref('browser.chromeURL');
		this.autoLoad = !this.settingsBranch.prefHasUserValue("autoload") || this.settingsBranch.getBoolPref("autoload"); // default:true
		this.autoLoadBranch = (this.settingsBranch.prefHasUserValue('autoload.branch')) ? this.settingsBranch.getCharPref('autoload.branch') : this.prefBranchWindows; // default:'windows.'
		this.crashLoad = !this.settingsBranch.prefHasUserValue("crashload") || this.settingsBranch.getBoolPref("crashload"); // default:true
		this.crashLoadBranch = this.prefBranchWindows;
		this.overwriteWindows = !this.settingsBranch.prefHasUserValue('overwritewindows') || this.settingsBranch.getBoolPref('overwritewindows'); // default:true
		this.overwriteTabs = !this.settingsBranch.prefHasUserValue('overwritetabs') || this.settingsBranch.getBoolPref('overwritetabs'); // default:true
		this.concatenate = this.settingsBranch.prefHasUserValue('concatenate') && this.settingsBranch.getBoolPref('concatenate'); // default:false
		this.lastSessionCrashed = this.settingsBranch.prefHasUserValue("shutdown") && !this.settingsBranch.getBoolPref("shutdown"); // default:false, needs to come before "checkLoaded()"
		this.winLocalPrefix = 'session';
		this.winPrefPrefix = 'saved';
		
		// Menu handling -- for initMenu()
		this.rdf =  Components.classes['@mozilla.org/rdf/rdf-service;1'].getService(Components.interfaces.nsIRDFService);
		this.utils = Components.classes['@mozilla.org/rdf/container-utils;1'].getService(Components.interfaces.nsIRDFContainerUtils);
		this.dataPrefix = 'http://sessionsaver.mozilla.org/rdf#';
		this.mozillaMenuId = "sessionsaver-mozillamenu";
		this.firefoxMenuId = "sessionsaver-firefoxamenu";
		this.initMenu(this.mozillaMenuId);
		this.initMenu(this.firefoxMenuId);

		// Hidden window
		var appShell = Components.classes["@mozilla.org/appshell/appShellService;1"].getService(Components.interfaces.nsIAppShellService);
		//alert(appShell.hiddenWindow);
		this.hiddenWnd = appShell.hiddenDOMWindow; // global hidden-window
		this.firstWindow = !this.checkLoaded(); // load shutdown-observer / startup-flag
		this.hiddenObserver = this.hiddenWnd.SessionSaverObserver; // global shutdown-observer
		this.hiddenHash = this.hiddenObserver.activeWindows; // global-hash of "active" windows
		
		
		// If first window
		if (this.firstWindow) {
			// ..should we autoload / did the last session crash?
			if (this.autoLoad || (this.crashLoad && this.lastSessionCrashed)) {
			
				// check startup-page type (0:blank, 1:homepage(s), 2:last)
				var startupPagePref = this.rootBranch.prefHasUserValue("browser.startup.page") ? this.rootBranch.getIntPref("browser.startup.page") : 1; // the pref defaults to 1 internally, so we're good.
				switch (startupPagePref) { 
					case 0: var homepages = "about:blank"; break;
					case 1: try { homepages = new String();
								var pageArray = this.rootBranch.getChildList("browser.startup.homepage", {});
								for (var n in pageArray)
									if (! /^browser\.startup\.homepage(\.count|_)/.test(pageArray[n]))
										homepages += this.rootBranch.getComplexValue(pageArray[n], Components.interfaces.nsIPrefLocalizedString).data; }
							catch(e) { alert("Please post this error to the SessionSaver thread:\n\n"+pageArray[n]+"\n\n"+e); }
							break;
					case 2: var historyService = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIBrowserHistory);
							homepages = new String();
							homepages += historyService.lastPageVisited; // will be an empty-string "", if no page is stored
							break;
				}
				
				// check for window URL arguments
				if (window.arguments && window.arguments.length > 0)
					// overwrite existing tabs unless a non-homepage URL argument was passed
					for (var i = 0, overwriteTabs=true; i < window.arguments.length; i++) {
						var subArguments=window.arguments[i].split("\n");
						for (var j = 0; j < subArguments.length; j++) {
							if (homepages.indexOf(subArguments[j]) == -1) overwriteTabs = false;
							else { subArguments.splice(j, 1); j--; window.arguments[i]=subArguments.join("\n"); }
						}
					}
				else overwriteTabs = true; // overwrite if no window-url's were passed
				
				// Load saved session
				this.sessionRecall(overwriteTabs, this.lastSessionCrashed?this.crashLoadBranch:this.autoLoadBranch);
				return;
			}
		}
		// Not the first window:
		else if (opener && opener.SessionSaver) { // once loaded, check to see if there's any pending tabs to restore
			try { eval("var tabObject = opener.SessionSaver."+window.name); } catch(e) {tabObject = null;}
			if (tabObject && tabObject[0] == window) {
				this.windowRecall(tabObject[1], tabObject[2], tabObject[3]); // @params: storedWinName, prefArray, overwriteTabs
				eval("delete opener.SessionSaver."+window.name); // remove "pending recall" from opener
				return; }
		}

		this.onLoadPtII(); // attach the pref-observer -- no recall occurred
		
	},
	
	// Completes our load-process: called by sessionRecall, historyRecall() or onLoad()
	onLoadPtII: function() {
		if (this.activated) return; // if already loaded, don't continue
		this.activated = true;
		
		// Current window-name (will be unique)
		if (!this.winName) {
			this.winSlot = this.hiddenObserver.reserveSlot();
			this.winName = this.winLocalPrefix + this.winSlot; } // build our unique name
		this.hiddenHash[this.winName] = window; // add our window to the global-hash
		setTimeout('throw("this.winName: '+this.winName+'");');
		// Pref-Observer + cleanup
		this.prefObserver.load(this); // load pref-observer - set menuitems + listeners
		var oldPrefs = ['settings.mode', 'default_session.'];
		for (var n in oldPrefs) this.rootBranch.deleteBranch(this.prefBranch + oldPrefs[n]); // remove deprecated prefs
	},
	
	// Converts the chromeProperties from bool -> numeric (and back again)
	boolToPref: function(item) {
		switch (item) {
			case true:  return "1"; break;
			case false: return "0"; break;
			case "1":   return true; break;
			case "0":   return false; break;
		}
	},

	// Initializes the datasource for our Tools-menu
	initMenu: function(menuId) {
		var menu = document.getElementById(menuId);
		if (!menu) return;
		
		//remove the old database in case there is one
		var sources = menu.database.GetDataSources(), item, oldDataSource;
		while (sources.hasMoreElements()) {
			item = sources.getNext();
			oldDataSource = item.QueryInterface(Components.interfaces.nsIRDFDataSource);
			menu.database.RemoveDataSource(oldDataSource); }
		var datasource = Components.classes['@mozilla.org/rdf/datasource;1?name=in-memory-datasource'].createInstance(Components.interfaces.nsIRDFDataSource);
		menu.database.AddDataSource(datasource);
		
		var sequence = this.utils.MakeSeq(datasource, this.rdf.GetResource('urn:root:sessions'));
		
		// don't list duplicates (branches have multiple prefs)
		var sessionArray = this.Branch.getChildList(this.prefBranchStatic, {}); // array of pref-names holding custom-sessions
		sessionArray.sort(); // the ordering is initially skewed / random
		sessionArray.unshift(this.prefBranchStatic+this.staticBranchDefault+"zorder"); // always include the default branch
		var sessionString = "";
		while (sessionArray.length > 0) {
			var branch = sessionArray[0].match(/(.*\.)[^\.]+$/)[1];
			if (sessionString.indexOf(branch) == -1) 
				sessionString += (sessionString.length>0 ? " ":"")+branch;
			sessionArray.shift();
		}
		sessionArray = sessionString.split(" "); 
		for (var n = 0; n < sessionArray.length; n++) {
			var resource = this.rdf.GetResource(sessionArray[n]);
			var sessionDescription = sessionArray[n].match(/^[^.]+\.(.*)\.$/)[1].replace(/[_]/g, " ").split(" ");
			for (var x in sessionDescription) sessionDescription[x] = sessionDescription[x].replace(/^./, sessionDescription[x].charAt(0).toUpperCase())
			//var dscPrefix = n%2 ? " +":" -";
			sessionDescription = " -    "+sessionDescription.join(" ");
			var sessionLocation = sessionArray[n];
			datasource.Assert(resource, this.rdf.GetResource(this.dataPrefix + 'label'), this.rdf.GetLiteral(sessionDescription), true);
			datasource.Assert(resource, this.rdf.GetResource(this.dataPrefix + 'value'), this.rdf.GetLiteral(sessionLocation), true);
			sequence.AppendElement(resource);
		}
		
		menu.builder.rebuild();
	},

	// Prompts for a session-name, then captures to it
	sessionPrompt: function() {
		var done = false;
		var origEntry = "", modEntry;
		var junkTest = false, spaceTest = false;
		var junkRe = new RegExp("[^"+"wd.-+!@#$%^&*()=~?:;[]{}|\\/<>".replace(/(.)/g,"\\$1")+"]"); // -- /[^\w\d.\-+!@#$%^&*()=~?:;\[\]\{\}|\\\/\\<>]/ //[^_0-9a-zA-Z] -- en + em-dash don't play nice
		var spaceRe = new RegExp("^_*$");
		var titleText = "SessionSaver - Capture New";
		while(!done) {
			var promptText = "Session Name: ";
			var alert = new Array();
			if (junkTest) alert.push(junkTest);
			if (spaceTest) alert.push(spaceTest);
			if (alert.length > 0) alert.unshift("\n");
			promptText += alert.join("");
			var origEntry = prompt(promptText, origEntry, titleText); 
			if (typeof(origEntry) == "string") {
				modEntry = origEntry.replace(/ /g,'_'); // spaces -> underscores
				junkTest = junkRe.test(modEntry) ? "\nPlease use standard characters.":false;
				spaceTest = spaceRe.test(modEntry) ? "\nInclude at least one letter or number.":false;
				if (!junkTest && !spaceTest) {
					this.hiddenObserver.captureAll(this.prefBranchStatic+modEntry+".", true, true); // @params: prefBranchSession, suppressSave, saveOnLast
					done = true; }
			}
			else done = true; 
		}
	},
	
	// Recaptures current scroll-states on window-close -- doesn't trip for File > Close, oddly
	onClose: function(evt) {
		this.onTabLoad(); // for shutdown by windowClosure -- recapture current scroll-states
		return true;
		/*
		// if not shutting down..
		if (!this.checkShutdownRequest())
			this.observerService.notifyObservers(this.getWindows("navigator:browser").length, "SessionSaver-WindowClosed", this.winName); // notify our hidden-window observer to remove the pref-branch (unless shutting-down)
		*/
	},
	
	// Removes the stored session on window-unload -- DOES trip for File > Close
	onUnload: function(evt) {
		// if not shutting down..
		if (!this.checkShutdownRequest() && evt.target == evt.originalTarget) // the targets don't match when a new document is simply unloading the old
			if (evt.target.nodeName.toLowerCase() != "tabbrowser") { // if the window is closing, not a tab..
				var browserWindows = this.getWindows("navigator:browser");
				if (browserWindows.length == 0) // ..and we're closing the last browser
					this.observerService.notifyObservers(null, "SessionSaver-WindowClosePending", this.winName); // schedule this window for removal, when another browser opens
				else
					this.observerService.notifyObservers(null, "SessionSaver-WindowClosed", this.winName); // remove this window's session (unless shutting-down)
			}
	},
	
	// Recaptures window on tab-close
	onTabUnload: function(evt) {
		// if not shutting down..
		if (!this.checkShutdownRequest() && evt.target == evt.originalTarget) { // the targets don't match when a new document is simply unloading the old
			this.onTabLoad(); // a tab was closed -- recapture window
		 	//throw(window.getBrowser().browsers.length+" "+this.checkShutdownRequest()+"\n\n"+evt.target.nodeName.toLowerCase()+" : "+evt.target+"\n"+evt.originalTarget.nodeName.toLowerCase()+" : "+evt.originalTarget+"\nequal: "+(evt.target==evt.originalTarget));
			//throw(" _"+window.getBrowser().browsers.length); //if (window.getBrowser().browsers.length == 0) this.onClose();
		}
	},
	
	// Stores the session for this window in its corresponding pref
	onTabLoad: function(evt, prefBranchSession, suppressSave, n) {
		
		// Ignore frame-loads
		if (evt && evt.originalTarget.defaultView &&
				evt.originalTarget.defaultView != evt.originalTarget.defaultView.top) // ps: onTabUnload() calls us without an event..
			return;
		
		// Retry later, if window-content is mid transition
		var content = window._content;
		if (content == null) {
			(typeof(n) == 'undefined') ? (n=0) : n++;
			if (n < 10) window.setTimeout(function() {SessionSaver.onTabLoad(null,prefBranchSession,suppressSave,n);}, 100); // 10x retry-limit
			return; }
		
		// if the 'sessionBranch' parameter wasn't passed, assume auto-save
		if (typeof(prefBranchSession) != "string") prefBranchSession = this.prefBranchWindows;

		// Save history locations for tabs
		var selectedtab = 0;
		var tabHistoryAll = new Array(), oldHistory, tabSession;
		var Tabbrowser = window.getBrowser();

		for (var i = 0; i < Tabbrowser.browsers.length; i++) {
			var curBrowser = Tabbrowser.browsers[i];
			try { oldHistory = curBrowser.sessionHistory; } 
			catch(e) { oldHistory = null; }
			
			tabSession = new Array();
			if (oldHistory && oldHistory.count > 0) {
				tabSession.push("z"+curBrowser.markupDocumentViewer.textZoom); // text-zoom
				tabSession.push(oldHistory.index); // active-entry's index
				for (var j = 0; j < oldHistory.count; j++) {
					var historyData = new Array();
					//historyData.push( Math.max(x.value, 0)+","+Math.max(y.value, 0) ); // scroll-position
					if (j==oldHistory.index)
						historyData.push( curBrowser.contentWindow.scrollX+","+curBrowser.contentWindow.scrollY ); // active-index scroll-position
					else {
						var x={},y={};
						oldHistory.getEntryAtIndex(j, false).QueryInterface(Components.interfaces.nsISHEntry).getScrollPosition(x, y); // it's a wrapped nsISHEntry + nsISHistoryEntry
						historyData.push( String(x.value)+","+String(y.value) ); // scroll-position
					}
					historyData.push(oldHistory.getEntryAtIndex(j, false).URI.spec); // url
					historyData = historyData.join("|");
					tabSession.push(historyData); } // scroll + url

			}
			else { // if no history is available (popups, etc.), manually create the entry
				historyData = new Array();
				historyData.push("0,0"); // scroll-position
				historyData.push(curBrowser.contentDocument.location.toString().replace(/&amp;/g, "&")); // url
				historyData = historyData.join("|");
				
				tabSession.push(0); // zero-index
				tabSession.push(historyData); // scroll + url
			}
			var ordinal = Tabbrowser.mTabContainer.childNodes[i].ordinal || i; // get ordinal (tab-modifier, eg. miniT), or normal index
			tabSession = tabSession.join("||"); // join this tab's histories..
			tabHistoryAll[ordinal] = tabSession; // ..and add it (directly) to master-array
			
			// catch the current-tab
			if (Tabbrowser.browsers[i] == Tabbrowser.mCurrentBrowser)
				selectedtab = ordinal;
		}
		tabHistoryAll = tabHistoryAll.join("|||"); // join all tab-histories

		var chromeProperties = 
				this.boolToPref(menubar.visible)+this.boolToPref(toolbar.visible)+
				this.boolToPref(locationbar.visible)+this.boolToPref(personalbar.visible)+
				this.boolToPref(statusbar.visible)+this.boolToPref(scrollbars.visible); // window-chrome settings

		var prefArray = new Array(); // our window's attribute-array
		var tabCount = Tabbrowser.browsers.length;
		
		// window-zoom-state (d1 n20)
		var mainWindow = window.document.getElementById("main-window");
		var isMaximized = (window.windowState == window.STATE_MAXIMIZED);
		var ssWindowState = isMaximized ? 1:0; // the state_maximized property isn't set (yet) when we load, so we'll use our own system
		// on initial-load, the window's content-area isn't sized / positioned properly, so we'll prefer the attributes
		var width = (mainWindow.hasAttribute("width")) ? mainWindow.getAttribute("width") : content.outerWidth;     // width
		var height = (mainWindow.hasAttribute("height")) ? mainWindow.getAttribute("height") : content.outerHeight; // height
		var screenX = (mainWindow.hasAttribute("screenX")) ? mainWindow.getAttribute("screenX") : content.screenX;  // screen-pos. x
		var screenY = (mainWindow.hasAttribute("screenY")) ? mainWindow.getAttribute("screenY") : content.screenY;  // screen-pos. y
		
		//var internalName = window.name ? window.name : this.winName;
		//var savedName = this.winPrefPrefix+this.winName; // alter the name, so recalled windows aren't confused with existing ones
		prefArray.push(this.winName);       // window-name
		prefArray.push(width);              // width
		prefArray.push(height);             // height
		prefArray.push(screenX);            // screen-pos. x
		prefArray.push(screenY);            // screen-pos. y
		prefArray.push(chromeProperties);   // window chrome
		prefArray.push(selectedtab);        // selected-tab's index
		prefArray.push(tabCount);           // total tabs
		prefArray.push(tabHistoryAll);      // indexed-string of tab histories
		prefArray.push(ssWindowState);      // window-zoom-state (d1 n20)
		
		prefArray = prefArray.join(" ");

		// more uniform with sessionRecall()'s code:
		var sessionBranch = this.prefService.getBranch(this.prefBranch + prefBranchSession);
		sessionBranch.setCharPref(this.winName, prefArray);
		
		if (!suppressSave) this.observerService.notifyObservers(null, "SessionSaver-SavePrefFile", this.winName); // notify our hidden-window observer to save
	},
	
	// Loads the appropriate number of recalled-windows
	sessionRecall: function(overwriteTabs, prefBranchSession) {
		// if the 'prefBranchSession' parameter wasn't passed, assume auto-recall
		if (typeof(prefBranchSession) != 'string') prefBranchSession = this.prefBranchWindows;
		var sessionBranch = this.prefService.getBranch(this.prefBranch + prefBranchSession);
		
		// if the 'overwrite' parameter wasn't passed, get the pref
		if (typeof(overwriteTabs) != 'boolean') overwriteTabs = this.overwriteTabs;
		var wndArray, prefArray, prefName, morePrefArray;

		// if the z-order pref is present (d1 nightly 7)
		if (sessionBranch.prefHasUserValue("zorder") && sessionBranch.getCharPref("zorder") != "") {
			wndArray = sessionBranch.getCharPref("zorder").split(",");
			for (var m in wndArray) wndArray[m] = prefBranchSession + wndArray[m];
			var branches = this.Branch.getChildList(prefBranchSession, {}); // array of pref-names holding window-sessions
			var pruneString = wndArray.join(" ") +" "+ prefBranchSession+"zorder"; // ..save the z-order, too -!
			for (var b in branches) if (pruneString.indexOf(branches[b]) == -1) this.Branch.deleteBranch(branches[b]); // prune non-z-indexed branches (unneeded)
		}
		else {
			wndArray = this.Branch.getChildList(prefBranchSession, {}); // array of pref-names holding window-sessions
			function compareFunction(a, b) {
				a = parseInt(a.replace(/\D*(\d+)$/, "$1")); // get trailing digits from string
				b = parseInt(b.replace(/\D*(\d+)$/, "$1"));
				return a-b; }
			wndArray.sort(compareFunction); // the ordering is initially skewed / random
		}
		
		// ignore empty prefs (user reset) and z-order pref
		for (var i = 0 ; i < wndArray.length ; i++) 
			if (!this.Branch.prefHasUserValue(wndArray[i]) || /zorder$/.test(wndArray[i]) ) 
				wndArray.splice(i--, 1);
		
		// if overwriting windows, close excess (d1 nightly 19)
		if ((wndArray.length > 0) && (this.overwriteWindows || prefBranchSession == this.prefBranchWindows)) {
			var openWindows = this.getWindows("navigator:browser"); // Note: we can't use z-order listing, because it does something really weird when there's only one window (moz1.3.1) : the first window is ignored, while a child is force-opened, which then loads normally
			var p = -1;
			while (openWindows.length > wndArray.length)
				if (openWindows[++p] != window) { openWindows[p].close(); openWindows.splice(p, 1); }
		}
		
		// if the window-concatenation pref is present (d1 nightly 17)
		if (this.concatenate) {
			for (var more = 0, tripFlag = 0; more < wndArray.length; more++) {
				morePrefArray = this.Branch.getCharPref(wndArray[more]).split(" "); // get stored window-session from pref
				if (!prefArray) { prefArray=morePrefArray; prefName=wndArray[more]; continue; } // only get 'prefArray' once -- skip adjustments, when doing so
				
				prefArray[1]   = Math.max(prefArray[1]?prefArray[1]:morePrefArray[1], morePrefArray[1]); // use the greatest width of all
				prefArray[2]   = Math.max(prefArray[2]?prefArray[2]:morePrefArray[2], morePrefArray[2]); // use the greatest height of all
				prefArray[3]   = Math.min(prefArray[3]?prefArray[3]:morePrefArray[3], morePrefArray[3]); // use the left-most x.position
				prefArray[4]   = Math.min(prefArray[4]?prefArray[4]:morePrefArray[4], morePrefArray[4]); // use the top-most y.position
				prefArray[5]   = (tripFlag++ == 0) ? prefArray[5].replace(/0/g, "1") : prefArray[5]; // we could parseInt() and get the max, but this would (theoretically) be undesirable, since concatenated popups wouldn't have certain chrome, yet in tabbed/concatenated mode, we'd want them to
				prefArray[7]  += morePrefArray[7]; // tabCount: we don't even use this, but it doesn't hurt..
				//var localCount = morePrefArray[7];
				//selectedtab  = selectedtab + localCount-1; // selectedtab is zero-based
				prefArray[6]   = morePrefArray[6];
				prefArray[8]   = (more > 0) ? new Array(morePrefArray[8], prefArray[8]).join("|||") : prefArray[8];
				prefArray[9]   = (tripFlag++ == 1 && typeof(prefArray[9]) != "undefined") ? 0 : prefArray[9]; // don't maximize (d1 n20)
				wndArray.splice(more--, 1); }
		}

		for (var w = 0 ; w < wndArray.length ; w++) {
			if (this.concatenate) {if (!prefArray) break;}
			else {
				prefArray = this.Branch.getCharPref(wndArray[w]).split(" "); // get stored window-session from pref
				prefName = wndArray[w]; }
						
			if (openWindows && openWindows.length > 0) { // current window will be included
				openWindows[0].SessionSaver.windowRecall(prefName, prefArray, overwriteTabs);
				openWindows.shift(); }
			else this.childRecall(prefName, prefArray); // ..otherwise, load the child.
		}
		
		if (!prefArray) this.onLoadPtII(); // attach pref-observer, if load didn't complete
	},
	
	// Opens a child window with relevant session-data
	childRecall: function(prefName, prefArray) {
		var name = prefArray[0]+new Date().valueOf(); // make name "unique" (for window-mediator)
		eval("var propArray = this."+name+" = ['placeholder', prefName, prefArray, true];"); // store tab-histories as window.opener.(this.)name[]
		var windowArgs = ",width="+prefArray[1]+",height="+prefArray[2]+",screenx="+prefArray[3]+",screeny="+prefArray[4]; // doesn't always resize/position properly, so we also manually set these on window-load (first listener)
		var windowHandler = window.openDialog(this.browserChromeUrl, name, "chrome,all,dialog=no"+windowArgs, null);
		propArray[0] = windowHandler;
	},
			
	// Loads stored properties for current window
	windowRecall: function(prefName, prefArray, overwriteTabs) {
		if (prefName.match(/^[^\.]+\./)[0] == this.prefBranchWindows) { // if auto-recall (where branches / sessions are fixed)
			prefArray[0] = prefArray[0].replace(new RegExp(this.winPrefPrefix), ""); // ditch the lame "prefix" we used to attach (n19)
			this.winName = prefArray[0]; // hijacks the existing pref-branch
			this.winSlot = this.winName.match(/\d+$/)[0]; // extract index from name-string
			this.hiddenObserver.reserveSlot(this.winSlot, true); } // "reserve" index, overriding if necessary
		var content = window._content;
		if (new RegExp("^"+prefArray[0]).test(window.name) == false) window.name = prefArray[0]+new Date().valueOf(); // child-recalled windows are named when opened
		if (overwriteTabs) { // if overwriting tabs, assume layout can be overridden also
			content.outerWidth  = prefArray[1];
			content.outerHeight = prefArray[2];
			content.screenX     = prefArray[3];
			content.screenY     = prefArray[4];
			content.moveTo(prefArray[3], prefArray[4]);
			if (prefArray[9] == "1") window.maximize(); // handle window-zoom (d1 n20)
			
			var chromeProperties = prefArray[5].split("");
			menubar.visible = this.boolToPref(chromeProperties[0]);     // menubar chrome
			toolbar.visible = this.boolToPref(chromeProperties[1]);     // toolbar chrome
			locationbar.visible = this.boolToPref(chromeProperties[2]); // locationbar chrome
			personalbar.visible = this.boolToPref(chromeProperties[3]); // personalbar chrome
			statusbar.visible = this.boolToPref(chromeProperties[4]);   // statusbar chrome
			scrollbars.visible = this.boolToPref(chromeProperties[5]);  // scrollbar chrome
		}

		// restore window-tabs
		var selectedtab      = prefArray[6];
		var tabCount         = prefArray[7];
		var tabHistoryAll    = prefArray[8];
		this.tabRecall(tabHistoryAll, selectedtab, overwriteTabs);
	},
	
	// Loads the appropriate number of recalled-tabs in a window
	tabRecall: function(tabHistoryAll, selectedtab, overwriteTabs) {
		var Tabbrowser = window.getBrowser();
		var sessionTabs = tabHistoryAll.split("|||");
		var currentTabs = new Array();
		var openTabCount = Tabbrowser.browsers.length;
		
		for (var t = 0 ; t < sessionTabs.length ; t++) {
			//sessionTabs[t] = sessionTabs[t].split("||"); // we'll do this later.
			if (!overwriteTabs || t >= openTabCount) // if we're not overwriting (current-window), OR we need another tab..
				currentTabs.push(Tabbrowser.addTab()); // ..open a new tab.
			else if (overwriteTabs && t < openTabCount)
				currentTabs.push(Tabbrowser.mTabContainer.childNodes[t]); // otherwise, reuse the existing tab.
		}

		// if overwriting, close any leftover tabs
		if (overwriteTabs)
			for (var i = sessionTabs.length; i < openTabCount; i++)
				Tabbrowser.removeTab(i);
		
		// restore tab-histories
		window.setTimeout(function() {SessionSaver.historyRecall(sessionTabs, currentTabs, selectedtab, overwriteTabs);}, 100);
	},
	
	// Loads the histories into recalled-tabs
	historyRecall: function(sessionTabs, currentTabs, selectedtab, overwriteTabs, n) {
	
		var ioService = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService);
		for (var t = 0; t < sessionTabs.length; t++) {
			var curBrowser = getBrowser().getBrowserForTab(currentTabs[t]);
			var curWebNav = curBrowser.webNavigation;

			// Check if we're loaded enough to continue
			if (t == 0) {
				try { curWebNav.sessionHistory; }
				catch(e) {
					(typeof(n) == 'undefined') ? (n=0) : n++;
					if (n < 10) window.setTimeout(function() {SessionSaver.historyRecall(sessionTabs, currentTabs, selectedtab, overwriteTabs, n);}, 100); // 10x retry-limit
					return; }
			}
			
			// Retrieve session history of current tab
			var newHistory = curWebNav.sessionHistory;
			newHistory.QueryInterface(Components.interfaces.nsISHistoryInternal);
			
			// If necessary, clear current-session's history
			if (newHistory.count > 0) newHistory.PurgeHistory(newHistory.count);
			
			// tab-properties
			var tabSession = sessionTabs[t].split('||');
			if (tabSession[0].charAt(0) != "z") tabSession.splice(0, 0, "z1.0"); // add text-zoom if not stored (history-string will be in slot[1])
			var textZoom = tabSession[0].substr(1, tabSession[0].length-1); // text-zoom (nightly 13)
			var activeIndex = tabSession[1];
			var activeScrollPosition;
			var tabHistory = tabSession.slice(2); // the rest of our "session-array" is tab history

			// Reinstate saved-history
			for (var i = 0; i < tabHistory.length; i++) {
				var entry = tabHistory[i].split("|");
				var scrollPosition = entry[0].split(","); // array of x + y values
				var historyURL = entry[1];
				//if (historyURL == "about:blank" && tabHistory.length > 2) continue; // skip "blank" entries, if there's more
				
				var newEntry = Components.classes['@mozilla.org/browser/session-history-entry;1'].createInstance(Components.interfaces.nsISHEntry);
				var newURI = ioService.newURI(historyURL, null, null);
				newEntry.SetURI(newURI);
				newEntry.setScrollPosition( {value:scrollPosition[0]}, {value:scrollPosition[1]} ); // x-obj, y-obj
				newHistory.addEntry(newEntry, true);
				
				if (i == activeIndex) activeScrollPosition = scrollPosition; // get the scroll-values for the active-page
			}
			
			// Reselect tab that was open when session was stored
			if (t == selectedtab && overwriteTabs)
				getBrowser().selectedTab = currentTabs[t];

			// Jump to active history-index (stored when saved)
			if (tabSession.length > 1 && activeIndex >= 0) {
				try{ curWebNav.gotoIndex(activeIndex); }
				catch(e) { /*continue;*/ } // skip scroll-recall if we can't load the tab
			}
			
			// Restore scroll-position + text-zoom -- once tab loads
			if (activeScrollPosition[0] + activeScrollPosition[1] > 0) // only scroll if we're going anywhere..
				// we'll use uniquely-named stuff to ensure the correct values are retained
				eval("\
					var curBrowser"+t+" = window.getBrowser().getBrowserForTab(currentTabs["+t+"]);\
					function recallScroll"+t+"(evt) {\
						if (evt && evt.originalTarget && evt.originalTarget.defaultView == evt.originalTarget.defaultView.top) {\
							curBrowser"+t+".removeEventListener('load', recallScroll"+t+", true);\
							curBrowser"+t+".markupDocumentViewer.textZoom = "+textZoom+";\
							curBrowser"+t+".contentWindow.scrollTo( "+activeScrollPosition[0]+", "+activeScrollPosition[1]+" );\
						}\
					}\
					curBrowser"+t+".addEventListener('load', recallScroll"+t+", true);\
				");
	
		}
		this.onLoadPtII(); // attach pref-observer, now that load is complete
	},	
	
	// Returns all open windows of a specified type
	getWindows: function(windowType, frontToBack) {
		if (typeof(frontToBack) != "undefined") 
			var enumerator = this.windowMediator.getZOrderDOMWindowEnumerator(windowType?windowType:null, frontToBack); // windowType, eg. 'navigator:browser'
		else enumerator = this.windowMediator.getEnumerator(windowType?windowType:null);
		var windowArray = new Array();
		
		while (enumerator.hasMoreElements())
			windowArray.push(enumerator.getNext());
		
		return windowArray;
	},

	// Checks if a shutdown request has been observed
	checkShutdownRequest: function() {
		var shutdownRequested = (this.hiddenObserver && this.hiddenObserver.shutdownRequested); // check observer-object's flag
		return shutdownRequested;
	},

	// Checks if SessionSaver is loaded (to avoid "crash recovery" for new browser-windows)
	checkLoaded: function() {
		setTimeout("throw('1');");
		var alreadyLoaded = (typeof(this.hiddenWnd.SessionSaverObserver) != 'undefined'); // are we already loaded?
		
		if (!alreadyLoaded) {
			this.rootBranch.setCharPref("capability.policy.policynames", "sessionsaver");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.sites", "about:blank");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.ChromeWindow.closed", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefService.savePrefFile", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.getChildList", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.getPrefType", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.setCharPref", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.getCharPref", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.setBoolPref", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.getBoolPref", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.setIntPref", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIPrefBranch.getIntPref", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.nsIWindowMediator.getZOrderDOMWindowEnumerator", "allAccess");
			this.rootBranch.setCharPref("capability.policy.sessionsaver.window.netscape.security.PrivilegeManager.enablePrivilege", "allAccess");
			this.observerObject.enableSecurity(this.hiddenWnd);
			this.hiddenWnd.SessionSaverLoader = SessionSaver;
			this.hiddenWnd.Components.classes["@mozilla.org/moz/jssubscript-loader;1"].getService(Components.interfaces.mozIJSSubScriptLoader).loadSubScript("chrome://sessionsaver/content/sessionsaver.js");
			//this.hiddenWnd.SessionSaverObserver.loadFlag = true;
			//this.settingsBranch.setBoolPref("shutdown", false); // pref-flag, so the next session can determine if we crashed
			//this.prefService.savePrefFile(null);
			// Load shutdown observer
			//this.hiddenWnd.ssHiddenWnd = true; // flag, so the script doesn't load the normal listeners
			//this.hiddenWnd.SessionSaverLoader = this;
			//Components.classes["@mozilla.org/moz/jssubscript-loader;1"].createInstance(Components.interfaces.mozIJSSubScriptLoader).loadSubScript("chrome://sessionsaver/content/sessionsaver.js", this.hiddenWnd);
		}
		else this.observerService.notifyObservers(null, "SessionSaver-WindowCloseFlush", null); // flush any pending window-closures
		setTimeout("throw('8');");
		
		return alreadyLoaded;
	},

	// Observes shutdown-requests and SessionSaver notices
	observerObject: {
		// nsIObserver registration + flag
		load: function(loader) {
	setTimeout("throw('3');");

			this.enableSecurity(window);
			//this.hiddenWnd = loader.hiddenWnd; // global hidden-window
			this.windowMediator = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator); // for getWindows()
			this.prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
			this.prefBranch = loader.prefBranch;
			this.prefBranchWindows = loader.prefBranchWindows;
			this.prefBranchStatic = loader.prefBranchStatic; // all manually captured sessions
			this.staticBranchDefault = loader.staticBranchDefault; // the default manual-session
			this.prefBranchSettings = loader.prefBranchSettings;
			this.Branch = this.prefService.getBranch(loader.prefBranch); // sessionSaver's main branch
			this.rootBranch = this.prefService.getBranch(null);
			this.settingsBranch = this.prefService.getBranch(loader.prefBranch + loader.prefBranchSettings); // sessionSaver's settings pref-branch
			this.windowBranch = this.prefService.getBranch(loader.prefBranch + loader.prefBranchWindows); // sessionSaver's windows pref-branch
			// Placeholders - set by pref-observation
			this.autoMode = null; 
			this.autoLoad = null;
			this.autoLoadBranch = null;
			this.crashLoad = null;
			this.shutdownSave = null;
			this.shutdownSaveBranch = null;
			// Counters + Flags
			this.counter = 0; // UNUSED: unique-name counter
			this.takenSlots = new Array(); // "taken-name" array
			this.shutdownRequested = false; // "shutdown requested"-flag
			this.lastSaved = 0; // monitor's the time between pref-file saves
			this.savePending = false; // flag to indicate if a save-timeout has been set
			this.windowsPending = []; // array of windows pending closure
			this.activeWindows = []; // hash of open-windows -- appended by checkLoaded and onUnload
			this.sessionDeletePending = false; // flag to indicate if a window was closed, and it's pref-removal is pending
			this.sessionDeleteTimer = null; // UNUSED
			// QueryInterface properties
			this.nsISupports = Components.interfaces.nsISupports;
			this.nsISupportsWeakReference = Components.interfaces.nsISupportsWeakReference;
			this.nsIObserver = Components.interfaces.nsIObserver;
			this.NS_ERROR_NO_INTERFACE = Components.results.NS_ERROR_NO_INTERFACE;
	setTimeout("throw('4');");
			
			this.settingsBranch.setBoolPref("shutdown", false); // pref-flag, so the next session can determine if we crashed
			
			// in case anything delays the Hidden Window's Unload -- (and a latent session-removal timer activates)
			// ..also for [X]-closure-shutdown
			window.addEventListener("unload", function() {
					if (!SessionSaverObserver.shutdownRequested)
						SessionSaverObserver.observe(null, "latent-shutdown", null);
				}, true);

			try {
					var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
					observerService.addObserver(this, "SessionSaver-SavePrefFile", false);
					observerService.addObserver(this, "SessionSaver-WindowClosePending", false);
					observerService.addObserver(this, "SessionSaver-WindowCloseFlush", false);
					observerService.addObserver(this, "SessionSaver-WindowClosed", false);
					observerService.addObserver(this, "quit-application-requested", false); }
			catch (e) { alert("SessionSaver: exception when registering hidden observer: " + e + "\n"); }

			var pbi = this.rootBranch.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			try { pbi.addObserver(this.prefBranch + this.prefBranchSettings, this, true); } // keep this last, in case we hit an error.
			catch(e) { this.hiddenWnd.alert("SessionSaver: hidden prefs-Observer failed to attach: " + e + "\n"); return; }
			this.observe(null, null, "init"); // init pref-retrieval
		},
		// nsIObserver interface implementation
		observe: function(subject, topic, data) {
			this.enableSecurity();
			if (topic == "SessionSaver-SavePrefFile") {
				// if any saves are pending, no need to continue
				if (this.savePending || this.shutdownRequested) return;
				var newWinName = data; // make sure new windows are added to z-order ( -- window-mediator doesn't catch stuff fast enough)
				
				// if the last-save was more than 10sec's ago, save again
				var timeElapsed =  new Date().valueOf() - this.lastSaved;
				if (timeElapsed > 10000) {
					this.lastSaved = new Date().valueOf();
					this.setZorder(null, newWinName);
					this.prefService.savePrefFile(null); } // save the prefs to disk [nothing can follow]
				// otherwise, set a timeout to prevent thrashing
				else {
					this.savePending = true;
					setTimeout( function(observer, newWinName) {
								observer.enableSecurity();
								observer.lastSaved = new Date().valueOf();
								observer.savePending = false;
								observer.setZorder(null, newWinName);
								observer.prefService.savePrefFile(null); // save the prefs to disk [nothing can follow]
							}, 10000-timeElapsed, this, newWinName);
				}
				return; }			
			else if (topic == "SessionSaver-WindowClosePending") {
				var winName = data;
				this.windowsPending.push(winName);
				return; }			
			else if (topic == "SessionSaver-WindowCloseFlush") {
				for (var f in this.windowsPending) this.observe(true, "SessionSaver-WindowClosed", this.windowsPending[f]);
				return; }			
			else if (topic == "SessionSaver-WindowClosed") {
				// close-event observed: wait 3sec's, then (if really closed) remove stored window-session
				var noDelay = subject;
				var winName = data;
				setTimeout( function(observer, winName) {
							if (!observer.shutdownRequested) {
								observer.enableSecurity();
								var win = observer.retrieveWindow(winName);
								if (!win || win.closed) {
									observer.removeWindow(winName);
									if (observer.autoMode == true) {
										observer.windowBranch.deleteBranch(winName);
										observer.observe(null, 'SessionSaver-SavePrefFile', null); }
								}
							}
						}, noDelay ? 0:3000,   this, winName);
				return; }
			else if (topic == "quit-application-requested") {
				this.shutdownRequested = true; // flag: so the unload-listeners stop tripping
				this.settingsBranch.setBoolPref("shutdown", true); // set pref-flag: we didn't crash
				// if we're running partial or fully automated, save state on shutdown
				if (this.autoLoad==true || this.crashLoad==true) this.captureAll(this.autoLoadBranch, true); // auto-capture for all open windows
				if (this.shutdownSave==true) this.replicateBranch(this.prefBranchWindows, this.shutdownSaveBranch); // shutdown-copy (per pref)
				this.prefService.savePrefFile(null);
				return; }
			else if (topic == "latent-shutdown") { // at this point all windows are closed, so real captures are futile
				this.shutdownRequested = true; // flag: so the unload-listeners stop tripping
				this.settingsBranch.setBoolPref("shutdown", true); // set pref-flag: we didn't crash
				if (this.shutdownSave==true) this.replicateBranch(this.prefBranchWindows, this.shutdownSaveBranch); // shutdown-copy (per pref)
				this.prefService.savePrefFile(null);
				return; }
			else if (topic == "SessionSaver-CaptureAll") { // called by "Manual Mode" saveSession menuitem -- NOT OBSERVED: manually invoked
				this.captureAll(this.prefBranchStatic + this.staticBranchDefault, true, true); // capture all currently open windows, suppressing auto-save
				return; }
			else { // pref-change
				var prefName = data;
				
				var init = prefName == "init";
				if (!init) prefName = prefName.match(new RegExp("^"+this.prefBranch+this.prefBranchSettings+"(.*)$"))[1];
				if (prefName == "shutdown") return; // ignore the shutdown-flag

				if (init || prefName == "autoload.branch") // Autoload branch
					this.autoLoadBranch = (this.settingsBranch.prefHasUserValue('autoload.branch')) ? this.settingsBranch.getCharPref('autoload.branch') : this.prefBranchWindows; // default:'windows.'
				if (init || prefName == "autoload") // Autoload at startup
					this.autoLoad = !this.settingsBranch.prefHasUserValue('autoload') || this.settingsBranch.getBoolPref('autoload'); // default:true
				if (init || prefName == "crashload") // Crash-recovery
					this.crashLoad = !this.settingsBranch.prefHasUserValue('crashload') || this.settingsBranch.getBoolPref('crashload'); // default:true
				if (init || prefName == "shutdownsave.branch") // Shutdown-save branch
					this.shutdownSaveBranch = (this.settingsBranch.prefHasUserValue('shutdownsave.branch')) ? this.settingsBranch.getCharPref('shutdownsave.branch') : this.prefBranchStatic+this.staticBranchDefault; // default:'static.default.'
				if (init || prefName == "shutdownsave") // Shutdown-save
					this.shutdownSave = this.settingsBranch.prefHasUserValue('shutdownsave') && this.settingsBranch.getBoolPref('shutdownsave'); // default:true
				var autoPrefChanged = /init|autoload\.branch|autoload|crashload|shutdownsave/.test(prefName);
				if (autoPrefChanged) this.autoMode = this.crashLoad || (this.autoLoad && this.autoLoadBranch == this.prefBranchWindows) || this.shutdownSave;
				//alert("observer.autoMode: "+this.autoMode+"\n\n"+(this.autoMode?"true":"false")+" "+this.crashLoad+" "+autoPrefChanged+"\n\n"+prefName);
				return; }
		},
		// enable xpconnect -- anywhere!
		enableSecurity: function(context) {
			if (!context) context = window;
			var privString = "UniversalBrowserRead UniversalBrowserWrite UniversalXPConnect UniversalPreferencesRead UniversalPreferencesWrite CapabilityPreferencesAccess UniversalFileRead";
			try { context.netscape.security.PrivilegeManager.enablePrivilege(privString); }
			catch(e) { setTimeout("throw('security enable failed: "+e+"');"); }
		},
		//var appShell = Components.classes["@mozilla.org/appshell/appShellService;1"].getService(Components.interfaces.nsIAppShellService);  var hiddenWnd = appShell.hiddenWindow; hiddenWnd.SessionSaverObserver.replicateBranch("windows.","replicateTest." );
		// replicates all children from the source-branch to the target-branch
		replicateBranch: function(prefBranchSource, prefBranchTarget) {
			//alert("2");
			var branches = this.Branch.getChildList(prefBranchSource, {}); // array of pref-names holding window-sessions
			var sourceRe = new RegExp("^"+prefBranchSource);
			var sourceBranch = this.prefService.getBranch(this.prefBranch+prefBranchSource);
			var targetBranch = this.prefService.getBranch(this.prefBranch+prefBranchTarget);
			this.Branch.deleteBranch(prefBranchTarget); // empty the target, in preparation
			for (var n in branches) { 
				var prefName = branches[n].replace(sourceRe, "");
				switch (sourceBranch.getPrefType(prefName)) {
					case Components.interfaces.nsIPrefBranch.PREF_STRING: targetBranch.setCharPref(prefName, sourceBranch.getCharPref(prefName)) ; break;
					case Components.interfaces.nsIPrefBranch.PREF_INT:    targetBranch.setIntPref (prefName, sourceBranch.getIntPref (prefName)) ; break;
					case Components.interfaces.nsIPrefBranch.PREF_BOOL:   targetBranch.setBoolPref(prefName, sourceBranch.getBoolPref(prefName)) ; break;
				}
			}
			//alert(branches[0].replace(sourceRe, "")+"\n\n"+sourceBranch.getPrefType(branches[0].replace(sourceRe, ""))+" - "+Components.interfaces.nsIPrefBranch.PREF_STRING);
		},
		// captures all currently opened windows
		captureAll: function(prefBranchSession, suppressSave, saveOnLast) {
			if (prefBranchSession) this.Branch.deleteBranch(prefBranchSession); // remove old session
			for (var name in this.activeWindows) 
				if (!this.activeWindows[name].closed) 
					this.activeWindows[name].SessionSaver.onTabLoad(null, prefBranchSession, suppressSave); // save each window-state, suppressing auto-save if specified
			this.setZorder(prefBranchSession);
			if (saveOnLast) this.prefService.savePrefFile(null);
		},
		// sets z-order pref
		setZorder: function(prefBranchSession, newWinName) {
			var zOrderString = new Array();
			var enumerator = this.windowMediator.getZOrderDOMWindowEnumerator("navigator:browser", false);
			while (enumerator.hasMoreElements())
				zOrderString.push(enumerator.getNext().SessionSaver.winName); // get each window's z-order
			if (!prefBranchSession) prefBranchSession = this.prefBranchWindows; // assume auto, if unspecified
			zOrderString = zOrderString.join(",");
			if (newWinName && zOrderString.indexOf(newWinName) == -1) zOrderString = newWinName+","+zOrderString; // make sure new windows are added ( -- window-mediator doesn't catch stuff fast enough)
			this.Branch.setCharPref(prefBranchSession + "zorder", zOrderString); // store array as string
		},
		// return's the window-obj for a listing
		retrieveWindow: function(winName) {
			return this.activeWindows[winName];
		},
		// removes a window's listing, after it's been closed
		removeWindow: function(winName) {
			var winSlot = winName.match(/\d+$/)[0];
			delete this.takenSlots[winSlot];
			delete this.activeWindows[winName];
		},
		// reserves a particular slot (or next available) for window-naming
		reserveSlot: function(slot, override) {
			if (!slot || (this.takenSlots[slot] && !override)) slot = this.nameCounter();
			this.takenSlots[slot] = true;
			return slot;
		},
		// UNUSED: frees a particular slot for window-naming
		releaseSlot: function(slot) {
			delete this.takenSlots[slot];
			return slot;
		},
		// returns the next available "slot" for window-naming
		nameCounter: function() {
			var counter = 0;
			while (this.takenSlots[counter]) counter++;
			return counter;
		},
		// UNUSED: called by the hidden-wnd's unload event
		latentShutdown: function () {
			this.shutdownRequested = true; // flag: so the unload-listeners stop tripping
			this.settingsBranch.setBoolPref("shutdown", true); // set pref-flag: we didn't crash
		},
		// nsISupports interface implementation
		QueryInterface: function(iid) {
			if (!iid.equals(this.nsISupports) &&
				!iid.equals(this.nsISupportsWeakReference) &&
				!iid.equals(this.nsIObserver))
			{	dump("SessionSaver observer object: QI unknown interface: " + iid + "\n");
				throw this.NS_ERROR_NO_INTERFACE; }
	
			return this;
		}
	},
	
	// Pref-observer -- controls "Manual Mode" menuitems  +  "Auto Mode" listeners
	prefObserver: {
		load: function(loader) {
			this.loader = loader;
			this.hiddenWnd = loader.hiddenWnd; // global hidden-window
			this.hiddenObserver = loader.hiddenObserver; // global shutdown-observer
			this.windowMediator = loader.windowMediator;
			this.observerService = loader.observerService;
			this.prefService = loader.prefService;
			this.prefBranch = loader.prefBranch; // text-string for SessionSaver main
			this.prefBranchSettings = loader.prefBranchSettings; // text-string for SessionSaver settings
			this.prefBranchStatic = loader.prefBranchStatic; // text-string for SessionSaver static
			this.staticBranchDefault = loader.staticBranchDefault; // text-string for static default
			this.rootBranch = loader.rootBranch; // root-branch
			this.settingsBranch = loader.settingsBranch; // settings-branch
			this.autoMode = null; // placeholder - set by "observe()"
			this.autoLoad = null; // placeholder - set by "observe()"
			this.crashLoad = null; // placeholder - set by "observe()"
			this.shutdownSave = null; // placeholder - set by "observe()"
			this.shutdownSaveBranch = null; // placeholder - set by "observe()"
			this.fileMenu = null; // placeholder - set by "observe()"
			this.windowInit = false; // flag: are we initialized?
			
			// our "manual-mode" filemenu items
			this.menuItemArray = new Array();
			this.menuItemArray.push( document.getElementById("sessionsaver-separator-menuitem") );
			this.menuItemArray.push( document.getElementById("sessionsaver-header-menuitem") );
			this.menuItemArray.push( document.getElementById("sessionsaver-load-menuitem") );
			this.menuItemArray.push( document.getElementById("sessionsaver-save-menuitem") );

			this.pbi = this.rootBranch.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			try { this.pbi.addObserver(this.prefBranch+this.prefBranchSettings, this, true); } // keep this last, in case we hit an error.
			catch(e) { alert("SessionSaver: prefs-Observer failed to attach: " + e + "\n"); return; }
			
			this.observe(null, null, "init"); // initialize the menuitems
		},
		// nsISupports interface implementation -- for weak-reference by pref-observer service
		QueryInterface: function(iid) {
			if (!iid.equals(Components.interfaces.nsISupports)
					&& !iid.equals(Components.interfaces.nsISupportsWeakReference)
					&& !iid.equals(Components.interfaces.nsIObserver)) {
				dump("SessionSaver Window Pref-Observer factory object: QI unknown interface: " + iid + "\n");
				throw Components.results.NS_ERROR_NO_INTERFACE; }
			return this;
		},
		
		// removes the observer-object from service -- called when the window is no longer open
		removeObserver: function() {
			this.pbi.removeObserver(this.prefBranch+this.prefBranchSettings, this);
			delete this;
		},
		
		// observer-function
		/* subject: [wrapped nsISupports :: nsIPrefBranch], nsIPrefBranchInternal -- topic: "changed" */
		observe: function(subject, topic, prefName) {
	
			// if we don't have a valid window (closed)
			if ( !(typeof(document) == 'object' && document) ) {
				this.removeObserver(); // remove the observer..
				return; } // ..and don't continue
			
			var init = prefName == "init";
			if (!init) prefName = prefName.match(new RegExp("^"+this.prefBranch+this.prefBranchSettings+"(.*)$"))[1];
			if (prefName == "shutdown") return; // ignore the shutdown-flag
			
			if (init || "autoload.branch".indexOf(prefName) != -1) // Autoload branch
				this.loader.autoLoadBranch = this.autoLoadBranch = (this.settingsBranch.prefHasUserValue('autoload.branch')) ? this.settingsBranch.getCharPref('autoload.branch') : this.prefBranchWindows; // default:'windows.'
			if (init || "autoload".indexOf(prefName) != -1) // Autoload at startup
				this.loader.autoLoad = this.autoLoad = !this.settingsBranch.prefHasUserValue('autoload') || this.settingsBranch.getBoolPref('autoload'); // default:true
			if (init || "crashload".indexOf(prefName) != -1) // Crash-recovery
				this.loader.crashLoad = this.crashLoad = !this.settingsBranch.prefHasUserValue('crashload') || this.settingsBranch.getBoolPref('crashload'); // default:true
			if (init || "shutdownsave".indexOf(prefName) != -1) // Save on shutdown
				this.loader.shutdownSave = this.shutdownSave = !this.settingsBranch.prefHasUserValue('shutdownsave') || this.settingsBranch.getBoolPref('shutdownsave'); // default:true
			if (init || "shutdownsave shutdownsave.branch".indexOf(prefName) != -1) { // Alternate File-menu item (capture)
				this.loader.shutdownSaveBranch = this.shutdownSaveBranch = (this.settingsBranch.prefHasUserValue('shutdownsave.branch')) ? this.settingsBranch.getCharPref('shutdownsave.branch') : this.prefBranchStatic+this.staticBranchDefault; // default:'static.default.'
				var captureItemActive = (!this.shutdownSave || this.shutdownSaveBranch != this.prefBranchStatic+this.staticBranchDefault);
				this.menuItemArray[3].label = captureItemActive ? this.menuItemArray[3].getAttribute("activelabel") : this.menuItemArray[3].getAttribute("inactivelabel");
				this.menuItemArray[3].setAttribute("disabled", captureItemActive ? false:true);
				//alert("captureItemActive: "+captureItemActive+"\n\n"+this.shutdownSave+" "+this.shutdownSaveBranch+"\n\n"+(this.shutdownSaveBranch != this.prefBranchStatic+this.staticBranchDefault)+this.prefBranchStatic+this.staticBranchDefault);
			}
			
			var newMode = this.crashLoad || (this.autoLoad && this.autoLoadBranch==this.prefBranchWindows) || this.shutdownsave;

			// Listeners
			var autoPrefChanged = /init|autoload\.branch|autoload|crashload|shutdownsave/.test(prefName);
			if (autoPrefChanged && (newMode != this.autoMode)) {
				if (newMode){ // if entering auto-mode, add tab-load listeners
					window.getBrowser().addEventListener('load', ssTabLoad, true); // tab-save when loaded
					window.getBrowser().addEventListener('unload', ssTabUnload, true); // tab-save on close
					if (this.windowInit) this.loader.onTabLoad(); } // if already loaded, capture the current session
				else if (this.windowInit) { // remove listeners, if loaded
					window.getBrowser().removeEventListener('load', ssTabLoad, true);
					window.getBrowser().removeEventListener('unload', ssTabUnload, true); }
				this.autoMode = newMode; // store the new mode
			}
			
			if (init || "overwritewindows".indexOf(prefName) != -1) // Overwrite windows
				this.loader.overwriteWindows = this.overwriteWindows = !this.settingsBranch.prefHasUserValue('overwritewindows') || this.settingsBranch.getBoolPref('overwritewindows'); // default:true
			if (init || "overwritetabs".indexOf(prefName) != -1) // Overwrite Tabs
				this.loader.overwriteTabs = this.overwriteTabs = !this.settingsBranch.prefHasUserValue('overwritetabs') || this.settingsBranch.getBoolPref('overwritetabs'); // default:true
			if (init || "concatenate".indexOf(prefName) != -1) // Concatenate windows
				this.loader.concatenate = this.concatenate = this.settingsBranch.prefHasUserValue('concatenate') && this.settingsBranch.getBoolPref('concatenate'); // default:false
			if (init || "filemenu".indexOf(prefName) != -1) { // File-menu items
				this.loader.fileMenu = this.fileMenu = !this.settingsBranch.prefHasUserValue('filemenu') || this.settingsBranch.getBoolPref('filemenu'); // true: 'auto' -- false: 'manual'
				for (var n in this.menuItemArray) this.menuItemArray[n].hidden = !this.fileMenu; }
			
			if (init) this.windowInit = true;
			
		}

	}

	
};


/*
** Window-load listeners + Hidden observer
*/

if (typeof(window.SessionSaverLoader) != "undefined") {
setTimeout("throw('2');");
	var privString = "UniversalBrowserRead UniversalBrowserWrite UniversalXPConnect UniversalPreferencesRead UniversalPreferencesWrite CapabilityPreferencesAccess UniversalFileRead";
	try { window.netscape.security.PrivilegeManager.enablePrivilege(privString); }
	catch(e) { setTimeout("throw('security enable failed: "+e+"');"); }
	
	var SessionSaverObserver = window.SessionSaver.observerObject;
	SessionSaverObserver.load(window.SessionSaverLoader);
	//window.SessionSaverLoader = null; // we can't delete them, so here's the next best thing
	//window.SessionSaver = null;
}
else {
	// moz1.3.1 doesn't do anything if the listener isn't set to capture
	//   -- further, we can't remove a listener if it has inline-code.
	function ssLoad() { SessionSaver.onLoad(); }
	function ssClose(evt) { SessionSaver.onClose(evt); }
	function ssUnload(evt) { SessionSaver.onUnload(evt); }
	function ssTabLoad(evt) { SessionSaver.onTabLoad(evt); }
	function ssTabUnload(evt) { SessionSaver.onTabUnload(evt); }
	
	window.addEventListener('load', ssLoad, true); // window startup-check (for crash-recovery)
	window.addEventListener('close', ssClose, true); // window-capture on close
	window.addEventListener('unload', ssUnload, true); // window-remove on unload
}
