/*
** authored by rue and Wladimir, with code adapted from the optimoz project
*/

/* global vars for uninstall-status */
var removalCheckArray = new Array(); // the array of our deinstall "checks"
var reportN; // the total value of our deinstall "checks"
var syncComplete = false; // if true, all synchronous operations have completed
var quitTimer; // repeatedly checks if asynchronous disk-operations have completed
var quitTimerMonitor; // monitors the quitTimer -- stops it after 120 seconds
var isProfileInstalled = false; // if true, component-removal will be unnecessary -- set by deleteJar()


// confirm and begin the uninstall
function uninstallAdblock() {
	
  var confirmUninstall = confirm("Do you really want to deinstall Adblock?-\n..the proceedure may take up to two-minutes, and the browser will have to quit immediately afterwards." );
  
	// user choose to cancel
	if (!confirmUninstall) 
		return; // do nothing further
	
	document.getElementById("deinstall-menuitem").setAttribute("disabled", true); // disable the "DeInstall" menuitem

	// initialize our removal-check array	
	removalCheckArray[0] = 0; // removeRDFOverlayEntries
	removalCheckArray[1] = 0; // removeInstalledChrome
	removalCheckArray[2] = 0; // deleteJar				:UNAGGREGATED
	removalCheckArray[3] = 0; // deleteXULCache			:UNAGGREGATED
	removalCheckArray[4] = 0; // deleteComponent		:UNAGGREGATED
	removalCheckArray[5] = 0; // removeCompregDat
	
	setShutdownTimers(); // sets the shutdown timers, which wait a while so asynchronous disk-operations can complete

	removeChromeAndOverlayEntries(); // remove all entries from the rdf-overlays
	removeInstalledChrome(); // remove all entries from installed-chrome.txt
	//disableFurtherAdblocking(); // disable adblock services / menuitems
	deleteJar(); // delete the jar-file
	deleteXULCache(); // delete the xul cache-file
	deleteComponent(); // delete the adblock-component
	removeCompregDat(); // remove all entries from compreg.dat
	
	syncComplete = true;
	
	
}

// sets the shutdown timers -- ensures asynchronous disk-operations have completed
function setShutdownTimers() {
	// if all checks completed, or just the unaggregated-checks failed, close out -!
	quitTimer = setInterval('\
		if (syncComplete) {\
			reportN = 0;\
			for (var r = 0 ; r < removalCheckArray.length ; r++)\
				reportN += removalCheckArray[r];\
\
			if (reportN == 6) {\
				clearInterval(quitTimer);\
				clearInterval(quitTimerMonitor);\
				shutdownMonitor(); }\
			else if (reportN >= 3 && (removalCheckArray[2] + removalCheckArray[3] + removalCheckArray[4] == reportN-3)) {\
				clearInterval(quitTimer);\
				clearInterval(quitTimerMonitor); shutdownMonitor(); }\
\
		}',500);
		
	quitTimerMonitor = setInterval('clearInterval(quitTimer); clearInterval(quitTimerMonitor); failureNotify();', 120000);
}


// activates and monitors the shutdown proceedure
function shutdownMonitor() {
	if (!shutdownAppNow())
		alert("Adblock was unable to shutdown the browser. \n\nYou are strongly advised to close all windows and shutdown the app.");
}

// alerts the user to "deinstall-failure" -- the timer doesn't like string-literals
function failureNotify() {
	alert("DeInstallation failed. \n\n\ " + removalCheckArray[0] + removalCheckArray[1] + removalCheckArray[2] + removalCheckArray[3] + removalCheckArray[4] + removalCheckArray[5] + "\n\nPlease post this error-code, along with the browser-name, build date, and any other information you think might be relevant, to:\n\n	adblock.mozdev.org/forum.html/no_wrap\n\n  Thank You. \n--The Adblock Team");
}

// removes entries from the rdf-overlays in user-chrome and app-chrome and corresponding entries in chrome.rdf
function removeChromeAndOverlayEntries() {
	const DIRSERVICE_CONTRACTID	 = '@mozilla.org/file/directory_service;1';
	const IOSERVICE_CONTRACTID	  = '@mozilla.org/network/io-service;1';
	const RDFSERVICE_CONTRACTID	 = '@mozilla.org/rdf/rdf-service;1';
	const CONTAINERUTILS_CONTRACTID = '@mozilla.org/rdf/container-utils;1';
	
	var dirService = Components.classes[DIRSERVICE_CONTRACTID].getService(Components.interfaces.nsIProperties);
	var ioService = Components.classes[IOSERVICE_CONTRACTID].getService(Components.interfaces.nsIIOService);
	var fileHandler = ioService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
	var rdf  = Components.classes[RDFSERVICE_CONTRACTID].getService(Components.interfaces.nsIRDFService);
	var utils = Components.classes[CONTAINERUTILS_CONTRACTID].getService(Components.interfaces.nsIRDFContainerUtils);

	const overlayURL = 'chrome://adblock/content/adblock.xul'
	
	var dirArray = new Array();
	var nameArray = new Array();
	var overlayArray = new Array();
	var parents = new Array();
	var chromeDir, chromefile, overlay, datasource, sequence;

	dirArray[0] = "UChrm"; // profile-chrome magic-key
	dirArray[1] = "AChrom"; // application-chrome magic-key
	nameArray[0] = "browser";
	nameArray[1] = "navigator";
	//nameArray[2] = "communicator";
	//nameArray[3] = "messenger";
	const rootSequence = "urn:mozilla:package:root";
	const adblockSequence = "urn:mozilla:package:adblock";
	parents[0] = rootSequence;
	parents[1] = adblockSequence;
	parents[2] = "chrome://communicator/content/communicatorOverlay.xul";
	parents[3] = "chrome://browser/content/browser.xul";
	parents[4] = "chrome://navigator/content/navigator.xul";
	//parents[5] = "chrome://communicator/content/tasksOverlay.xul";
	//parents[6] = "chrome://messenger/content/mailWindowOverlay.xul";

	// for each chrome-dir, get all overlay files
	for (var i = 0; i < dirArray.length; i++) {
		chromeDir = dirService.get(dirArray[i], Components.interfaces.nsIFile);
		chromefile = chromeDir.clone();
		chromefile.append("chrome.rdf");
		if (chromefile.exists() && chromefile.isReadable() && chromefile.isWritable())
			overlayArray.push(chromefile); // chrome-registry
		for (var j = 0; j < nameArray.length; j++) {
			overlay = chromeDir.clone();
			overlay.append("overlayinfo");
			overlay.append(nameArray[j]);
			overlay.append("content");
			overlay.append("overlays.rdf");
			if (overlay.exists() && overlay.isReadable() && overlay.isWritable())
				overlayArray.push(overlay); // only keep if we have permissions
		}
	}

	for (i = 0; i < overlayArray.length; i++) {
		overlay = fileHandler.newFileURI(overlayArray[i]).spec;
		datasource = rdf.GetDataSourceBlocking(overlay);
		
		if (datasource) {
			for (var k = 0; k < parents.length; k++) {
				sequence = utils.MakeSeq(datasource, rdf.GetResource(parents[k]));
				if (sequence) {
					var element = (parents[k] == rootSequence && overlayArray[i].leafName == "chrome.rdf") ?
						rdf.GetResource(adblockSequence).QueryInterface(Components.interfaces.nsIRDFNode)
						:
						rdf.GetLiteral(overlayURL);
					sequence.RemoveElement(element, true);

					// Remove parent container -- if node is left empty, or we're eliminating *our* chrome.rdf-sequence
					if (sequence.GetCount() == 0 || 
							(overlayArray[i].leafName == "chrome.rdf" && parents[k] == adblockSequence)) {
						var it = datasource.ArcLabelsOut(rdf.GetResource(parents[k]));
						while (it.hasMoreElements()) {
							var property = it.getNext();
							var target = datasource.GetTarget(rdf.GetResource(parents[k]), property, true);
							if (property && target)
								datasource.Unassert(rdf.GetResource(parents[k]), property, target);
						}
					}
				}
			}

			datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
		}
	}
	removalCheckArray[0]++;
}


// removes the installed-chrome.txt entries
function removeInstalledChrome() {
	var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);

	var installedChromeArray = new Array();
	installedChromeArray[0] = dirService.get("UChrm", Components.interfaces.nsIFile); // app-chrome file
	installedChromeArray[1] = dirService.get("AChrom", Components.interfaces.nsIFile); // profile-chrome file
	
	installedChromeArray[0].append("installed-chrome.txt");
	installedChromeArray[1].append("installed-chrome.txt");
	
	var streamIn = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
	var streamOut = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
	var wrappedIn = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
	var input;
	
	var chromeRe = /.*\/chrome\/adblock\.jar\!\/content\/.*[\r\n]+/gi; // catch abberrant newlines also
	
	for (var n = 0 ; n < installedChromeArray.length ; n++) {
		if (installedChromeArray[n].exists()) {
			streamIn.init(installedChromeArray[n], 0x01, 0444, null);
			wrappedIn.init(streamIn);
			input = wrappedIn.read(streamIn.available());
			wrappedIn.close();
			streamIn.close();
			
			//alert(input);
	
			while (chromeRe.test(input))
				input = input.replace(chromeRe, '');
			
			installedChromeArray[n].remove(true); // remove the file so we can replace it
			installedChromeArray[n].create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666); // create a new, blank file -- there's no way to empty an existing one
	
			streamOut.init(installedChromeArray[n], 0x02, 0x200, null);
			streamOut.flush();
			streamOut.write(input, input.length);
			streamOut.close();
			
			removalCheckArray[1]++;
		}
	}
}


// UNUSED: never got this working -- disables adblock's services and menuitems
function disableFurtherAdblocking() {

	var windowMediator = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
	var enumerator = windowMediator.getEnumerator("navigator:browser"); // the iterator returns domWindows (using getNext() )
	var win; // enumerator reference object
	var windowObject; // the converted DOM-window object
	var browsers;
	
	while(enumerator.hasMoreElements()) {
		win = enumerator.getNext();
		browsers = win.getBrowser().browsers;

		for (var i = 0; i < browsers.length; i++) {
			try {
				browsers[i].contentDocument.removeEventListener("keypress", checkEvent, true); // remove binding listener
				browsers[i].contentDocument.removeEventListener("contextmenu", checkContextMenu, true); // remove context-click listener
				// ^^^___ contentWindow would access the local "window" object
			} catch(e) {alert("Access to browser[" + i + "].webNavigation failed: " + e);}
		}
		
	}

	
	/*
	var browsers = win.getBrowser().browsers;
	for (var i = 0; i < browsers.length; i++) {
		try {
			nextLocation = browsers[i].currentURI.hostPort;
		}
		catch(ex) { 
		//blank window
		}
		
		if (nextLocation) {
	*/

}


// deletes or renames the jar-file
function deleteJar() {
	var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
	var tempDir = dirService.get("UChrm", Components.interfaces.nsIFile);
	var dirArray = new Array();
	var chromeDir, adblockJar;
	var moveSuccess = false;
	tempDir.append("adblock-temp");
	
	dirArray[0] = "AChrom"; // application-chrome magic-key
	dirArray[1] = "UChrm"; // profile-chrome magic-key
	
	// remove any existing temp-dir and re-create ( --install cleanup)
	try {
		if (tempDir.exists()) tempDir.remove(true); 
		tempDir.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0666); // create a new temp-dir
	} catch(e) {}

	for ( var i = 0 ; i < dirArray.length ; i++) {
		chromeDir = dirService.get(dirArray[i], Components.interfaces.nsIFile);
		adblockJar = chromeDir.clone();
		adblockJar.append("adblock.jar"); // "appends" the file-string to our dir file-obj
				
		// move jar-file to temp-dir
		try {
			if (adblockJar.exists()) {
				if (dirArray[i] == "UChrm") isProfileInstalled = true; // component-removal will be unnecessary
				adblockJar.moveTo(tempDir, "adblock-jar-"+dirArray[i]+"-uninstalled"); // move the jar to the temp-dir, renaming
				if (!removalCheckArray[2]) removalCheckArray[2]++; // don't increment twice (..if adblock was double-installed)
			}
		} catch(ei) {
		
			// rename jar-file -- if move fails
			try {
				if (adblockJar.exists()) {
					var newNameMain = "adblock-uninstalled";
					var newName = newNameMain;
					var adblockJarRenamed = chromeDir.clone();
					var n = 1;
					
					adblockJarRenamed.append(newName);
					if (adblockJarRenamed.exists())
						while(adblockJarRenamed.exists()) {
							newName = new String(newNameMain + n); // + nameEnd); // find a unique-name for our "move-to" destination
							adblockJarRenamed = chromeDir.clone();
							adblockJarRenamed.append(newName);
							n++;
						}

					adblockJar.moveTo(null, newName); // rename the jar to the "unique name"
					if (!removalCheckArray[2]) removalCheckArray[2]++; // don't increment twice (..if adblock was double-installed)
				}
			} catch(eii) { /*alert("Unable to remove adblock.jar from:\n\n"+adblockJar.path+"\n\n..you'll have to quit the browser and remove it by hand.");*/ }
		}
	}
}


// deletes the xul cache-file
function deleteXULCache() {
	var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
	var profileDir = dirService.get("ProfD", Components.interfaces.nsIFile);
	var profileChromeDir = dirService.get("UChrm", Components.interfaces.nsIFile);
	var tempDir = profileChromeDir.clone();
	var cacheArray = [];
	var found = false, xulCacheFile;
	
	tempDir.append("adblock-temp");
	cacheArray[0] = "XUL FastLoad File"; // -- mac classic
	cacheArray[1] = "XUL.mfast"; // -- mac osX
	cacheArray[2] = "XUL.mfasl"; // -- linux
	cacheArray[3] = "XUL.mfl"; // -- windows + other
	
	for (var n = 0 ; n < cacheArray.length &! found ; n++) {
		xulCacheFile = profileDir.clone();
		xulCacheFile.append(cacheArray[n]);
		found = xulCacheFile.exists(); }
	
	if (!found) {
		removalCheckArray[3]++; // if there's no cache-file, we're done
		return; }
	
	// if the temp-dir doesn't exist yet, create it
	try {
		if (!tempDir.exists()) tempDir.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0666);
	} catch(e) {}
	
	try {
		xulCacheFile.moveTo(tempDir, xulCacheFile.leafName + "-uninstalled"); // move the jar to the temp-dir, renaming
		removalCheckArray[3]++;
	} catch(e) { alert("Unable to remove the XUL Cache File:  " + xulCacheFile.leafName + " \n..you'll have to quit the browser and remove it by hand.");}

}


// deletes the adblock-component
function deleteComponent() {
	/*
	if (isProfileInstalled) {
		removalCheckArray[4]++;
		return; } // component-removal was unnecessary
	*/
	var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
	var profileChromeDir = dirService.get("UChrm", Components.interfaces.nsIFile);
	var tempDir = profileChromeDir.clone();
	var component = dirService.get("ComsD", Components.interfaces.nsIFile); // http://lxr.mozilla.org/seamonkey/source/xpcom/io/nsDirectoryServiceDefs.h
	tempDir.append("adblock-temp");
	component.append("nsAdblock.js");
	
	// remove component, if it exists
	try {
		if (component.exists()) component.moveTo(tempDir, component.leafName + "-uninstalled"); // move the jar to the temp-dir, renaming
		removalCheckArray[4]++;
	} catch(e) {alert("Unable to remove Adblock's Component File:\n\n" + component.path + "\n\n..you'll have to quit the browser and remove it by hand.");}
}


// removes all entries from compreg.dat
function removeCompregDat() {
	/*
	if (isProfileInstalled) {
		removalCheckArray[5]++;
		return; } // component-removal was unnecessary
	*/
	var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
	var compRegistry = dirService.get("ComRegF", Components.interfaces.nsIFile); // http://lxr.mozilla.org/seamonkey/source/xpcom/io/nsDirectoryServiceDefs.h
	var streamIn = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
	var streamOut = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
	var wrappedIn = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
	var input;
	var restored = false;
	
	// test if magic-key is working
	if (!compRegistry.exists()) {
		// if not, manually define the registry name
		compRegistry = dirService.get("ComsD", Components.interfaces.nsIFile);
		compRegistry.append("compreg.dat");
		// test again
		if (!compRegistry.exists() && isProfileInstalled) {
			alert("Your browser's Component Registry could not be ascertained.\n\nStandby. Further instructions will follow in a minute...");
			return; // still not found -- don't continue
		}
	}
	
	// if the registry-file is readable	
	if (compRegistry.isReadable()) {
		streamIn.init(compRegistry, 0x01, 0444, null);
		wrappedIn.init(streamIn);
		input = wrappedIn.read(streamIn.available());
		wrappedIn.close();
		streamIn.close();
		
		// remove all lines concerning adblock
		var entryRemoveRe = /.*[\W\d](ns)?adblock[\W\d].*/i; // lines concerning adblock's component-loader + category
		while (entryRemoveRe.test(input)) { // [Note: the global-flag doesn't work across lines]
			input = input.replace(entryRemoveRe, ""); // purge -!
			if (!restored) restored = true; }
		
		// if no entries were found
		if (!restored) {
			removalCheckArray[5]++;
			return; // we're finished
		}
		
		// otherwise, write the restored registry
		if (compRegistry.isWritable()) {
			streamOut.init(compRegistry, 0x02, 0x200, null);
			streamOut.flush();
			streamOut.write(input, input.length);
			streamOut.close();
			
			removalCheckArray[5]++;
		}
		else alert("Your browser's Component Registry was not restored.\n\nThe registry file could not be written: \n\n" + compRegistry.path + "\n\nPlease verify that \'"+compRegistry.leafName+"\' has the necessary permissions and restart your browser.");
	
	}
	else alert("Your browser's Component Registry was not restored.\n\nThe registry file could not be read: \n\n" + compRegistry.path + "\n\nPlease verify that \'"+compRegistry.leafName+"\' has the necessary permissions and restart your browser.");
} 


// shuts down the app
//  -- copied straight from: lxr.mozilla.org/seamonkey/source/xpfe/global/resources/content/globalOverlay.js
function shutdownAppNow()  {
	var ObserverService = Components.classes["@mozilla.org/observer-service;1"].getService();
	ObserverService = ObserverService.QueryInterface(Components.interfaces.nsIObserverService);
	
	if (ObserverService) {
		try {
			// XXX FIX! we should have a way to cancel a requested quit; see
			// bugzilla bug 149764
			ObserverService.notifyObservers(null, "quit-application-requested", null);
		} catch (ex) { /* dump("no observer found \n"); */ }
	}
	
	var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
	var windowManagerInterface = windowManager.QueryInterface( Components.interfaces.nsIWindowMediator);
	var enumerator = windowManagerInterface.getEnumerator(null);
	var appShell = Components.classes['@mozilla.org/appshell/appShellService;1'].getService();
	appShell = appShell.QueryInterface( Components.interfaces.nsIAppShellService );
	var nativeAppSupport = null;
	
	try { nativeAppSupport = appShell.nativeAppSupport; } catch (ex) {}
	
	while (enumerator.hasMoreElements()) {
		var domWindow = enumerator.getNext();
		if (("tryToClose" in domWindow) && !domWindow.tryToClose())
			return false;
		domWindow.close(); }
		
	if (!nativeAppSupport || !nativeAppSupport.isServerMode)
		appShell.quit(Components.interfaces.nsIAppShellService.eAttemptQuit); // final quit
		
	return true;
}