/*
** GPL Licensed, by: Henrik, Wladimir, rue
*/

const DATASOURCE_CONTRACTID = '@mozilla.org/rdf/datasource;1?name=in-memory-datasource';
const RDFSERVICE_CONTRACTID = '@mozilla.org/rdf/rdf-service;1';
const CONTAINERUTILS_CONTRACTID = '@mozilla.org/rdf/container-utils;1';
const CONTENTPOLICY_CONTRACTID = "@mozilla.org/layout/content-policy;1";

var rdf =  Components.classes[RDFSERVICE_CONTRACTID].getService(Components.interfaces.nsIRDFService);
var utils = Components.classes[CONTAINERUTILS_CONTRACTID].getService(Components.interfaces.nsIRDFContainerUtils);
var policy = Components.classes[CONTENTPOLICY_CONTRACTID].getService(Components.interfaces.nsIContentPolicy);
var datasource, sequence;

const prefix = 'http://adblock.mozilla.org/rdf#';

var console = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);

var nodes = {};
var nodeTypes = {};

var appShell = Components.classes["@mozilla.org/appshell/appShellService;1"].getService(Components.interfaces.nsIAppShellService);
var hiddenWnd = appShell.hiddenDOMWindow; // global hidden-window
var apiConstants = hiddenWnd.apiConstants;
var treeConstants = new Object(); // the tree-object changed, per bug 221619 -- this will hold our "api-switch" bool

var typeDescr = [];
typeDescr[apiConstants.SCRIPT] = 'SCRIPT';
typeDescr[apiConstants.IMAGE] = 'IMAGE';
typeDescr[apiConstants.SUBDOCUMENT] = 'SUBDOCUMENT';
typeDescr[apiConstants.OBJECT] = 'OBJECT';
typeDescr[apiConstants.DOCUMENT] = 'DOCUMENT';

var flasher = {
	url: null,
	loopCount: 0,
	minorCount: 0,
	hiddenCount: 0,
	timeout: null,
	origOutline: [],

	flash: function(url) {
		this.stop();
		this.url = url;
		this.loopCount = 0;
		this.minorCount = 0;
		this.hiddenCount = 0;
		this.doFlash();
	},

	doFlash: function() {
		// if we've looped the max-times, stop
		if ( ! (this.loopCount < 3)) {
			this.switchOff();
			this.url = null;
			return; }

		// If we're still visible-flashing
		if (this.minorCount < 12) {
			if (this.minorCount % 2) this.switchOff();
			else this.switchOn();
			this.minorCount++; }
		// ..or we've flashed our visible-limit
		else {
			// ..and we're still hidden-flashing
			if (this.hiddenCount < 6)
				this.hiddenCount++;
			// ..otherwise, we've flashed our hidden-limit
			else {
				this.loopCount++;
				this.minorCount = 0; 
				this.hiddenCount = 0; }
		}
		
		this.timeout = setTimeout('flasher.doFlash()', 120);
	},

	stop: function() {
		if (this.url != null) {
			clearTimeout(this.timeout);
			this.switchOff(); }
	},

	switchOn: function() {
		var list = nodes[this.url];
		for (var i=0; i<list.length; i++) {
			var node = list[i];
			if (typeof(node.contentDocument) != 'undefined' && node.contentDocument 
					&& typeof(node.contentDocument.getElementsByTagName) == 'function' 
					&& node.contentDocument.getElementsByTagName('body') 
					&& node.contentDocument.getElementsByTagName('body').length > 0
				)
				node = node.contentDocument.getElementsByTagName('body')[0];
			//this.origOutline[String(i)] = node.style.MozOutline;
			if (node.style) node.style.MozOutline = "#AB0000 dotted 2px !important";
		}
	},

	switchOff: function() {
		var list = nodes[this.url];
		for (var i=0; i<list.length; i++) {
			var node = list[i];
			if (typeof(node.contentDocument) != 'undefined' && node.contentDocument 
					&& typeof(node.contentDocument.getElementsByTagName) == 'function' 
					&& node.contentDocument.getElementsByTagName('body') 
					&& node.contentDocument.getElementsByTagName('body').length > 0
				)
				node = node.contentDocument.getElementsByTagName('body')[0];
			//node.style.MozOutline = this.origOutline[String(i)] ? this.origOutline[String(i)] : 'none';
			if (node.style) node.style.MozOutline = 'none';
		}
	}
};

// if the user clicks "OK", saves the filter and refilters the document
function allOK() {
	
	var filterAccepted = tryToAddFilter();
	
	if(!filterAccepted)
		return false; // don't stop filter if the user cancels the addition
	

	flasher.stop();
	return true;
}

function tryToAddFilter() {
	var textbox = document.getElementById("filter");
	var pattern = textbox.value;

	if(pattern == null) return true; // don't add null filter
	
	// if the user didn't want to enter a regular expression, cancel the "OK"
	if ((pattern.charAt(0) == "/") && (pattern.charAt(pattern.length - 1) == "/") && !adblockWarnRegExp())
		return false;
	
	// only if an already-filtered item wasn't selected
	if (!textbox.disabled) {
		addFilter(pattern); // save the filter to prefs
		var wnd = window.arguments[0];
		refilter(wnd); // refilter the whole page
		//refilter(window.arguments[0].ownerDocument.defaultView.top);
	}
	
	return true;
}

function allCancel() {
	flasher.stop();
	return true;
}

// fill the list with external references
function init() {
	datasource = Components.classes[DATASOURCE_CONTRACTID].createInstance(Components.interfaces.nsIRDFDataSource);
	
	var tree = document.getElementById('references-tree');
	tree.database.AddDataSource(datasource);

	sequence = utils.MakeSeq(datasource, rdf.GetResource('urn:root:references'));

	/*
	if (window.arguments[1])
		addAllReferences(window.arguments[0].ownerDocument.defaultView.top);
	else
		addReferences(window.arguments[0]);
	*/
	
	var wnd = window.arguments[0];
	
	addAllReferences(wnd); // get all items for current browser-page
	
	treeConstants.oldStyleAPI = (tree.treeBoxObject.selection ? true : false); // per bug 221619 (see above)
	treeConstants.oldStyleAPI ?
		tree.treeBoxObject.selection.select(0)
		:
		tree.treeBoxObject.view.selection.select(0);
}

// on selection-change, show the item's url (if unfiltered), OR the filter that caught the item
function onSelectionChange() {
	var textbox = document.getElementById('filter');
	var tree = document.getElementById('references-tree');
	var selection = treeConstants.oldStyleAPI ?
		tree.treeBoxObject.selection
		:
		tree.treeBoxObject.view.selection;

	if (selection.count != 1 || !selection.isSelected(selection.currentIndex))
		return;
	
	//Exception is thrown when called on about:blank page.
	try {var resource = tree.builderView.getResourceAtIndex(selection.currentIndex);} catch(e) {return;}
	
	var filter = datasource.GetTarget(resource, rdf.GetResource(prefix + 'filter'), true);
	if (filter) filter = filter.QueryInterface(Components.interfaces.nsIRDFLiteral);
	if (filter && filter.Value != "NoMatch") {
		filter = filter.Value.toString();
		var simpleRe = /\(\?\:\\n\)\?/; // test for the "Adblock simple-filter" flag
		//var simpleRe = /(^\^http)|(\(ABsf\)\?\$\/\i$)/;
		// if the filter is simple, de-RegExp -- otherwise, get the pattern sans-delimiters
		if (simpleRe.test(filter)) filter = filter.replace(/^\/(.*)\(\?\:\\n\)\?\/i?$/, "$1").replace(/\\\./g, " ").replace(/\.\*/g, "*").replace(/ /g, ".").replace(/\\/g, ""); // first 'replace' is same as substr, below -- left regexp for fun
		else filter = filter.substr(0, filter.length - 1); // length isn't zero-based + / + $ + flag "i" are anchored to end
		if (!textbox.disabled) textbox.disabled = true;
		textbox.value = filter;
		flasher.stop(); }
	else {
		var url = datasource.GetTarget(resource, rdf.GetResource(prefix + 'url'), true);
		if (url) url = url.QueryInterface(Components.interfaces.nsIRDFLiteral);
		if (url) {
			if (textbox.disabled) textbox.disabled = false;
			textbox.value = url.Value;
			flasher.flash(url.Value); }
	}
}

function addNodeReferences(data) {

	var url = data.contentLocation.spec;
	var filterMatch = data.filterMatch;
	var node = data.node[0];
	var type = data.contentType;
	
	if (typeof(nodes[url]) == 'undefined') {
		nodes[url] = [];
		nodeTypes[url] = [];
		
		var resource = rdf.GetResource(url);
		datasource.Assert(resource, rdf.GetResource(prefix + 'url'), rdf.GetLiteral(url), true);
		datasource.Assert(resource, rdf.GetResource(prefix + 'type'), rdf.GetLiteral(typeDescr[type].toLowerCase()), true);
		datasource.Assert(resource, rdf.GetResource(prefix + 'elements'), rdf.GetLiteral(''), true);
		datasource.Assert(resource, rdf.GetResource(prefix + 'displaystyle'), rdf.GetLiteral(filterMatch ? "filtered" : "unfiltered"), true);
		datasource.Assert(resource, rdf.GetResource(prefix + 'filter'), rdf.GetLiteral(filterMatch ? filterMatch : "NoMatch"), true);
		
		sequence.AppendElement(resource);
	}
	
	var found = false;
	var types = nodeTypes[url];
	try{ var name = node.tagName; }catch(e){name=null;}
	
	//Handle background images separately since the object has no tag name
	if (!name && type == apiConstants.IMAGE && node.toString().indexOf("HTMLDocument")!=-1)
		name = "BGND";
	
	var found = false;
	var types = nodeTypes[url];
	for (var j=0; j<types.length; j++) {
		if (types[j] == name) {
			found = true;
			break; }
	}
	
	if (!found) {
		var prev = types.join(', '); // joins the types-array with comma separation
		types.push(name);
		
		datasource.Change(rdf.GetResource(url), rdf.GetResource(prefix + 'elements'), rdf.GetLiteral(prev), rdf.GetLiteral(types.join(', ')));
	}
	nodes[url].push(node);
}

// fill the list with all external references in a window
function addAllReferences(wnd) {
	var data = wnd._Adblock||wnd.document._Adblock||{};
	
	for (var i in data)
		addNodeReferences(data[i]);
}

// adds the filter to prefs
function addFilter(filter) {
	if (filter != "") {
		var wPatterns = null;
		try {
			var prefObj = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
			var Branch = prefObj.getBranch("adblock.");
			wPatterns = Branch.prefHasUserValue("patterns") ? Branch.getCharPref("patterns") : null;
		} catch(e) {}
		
		if (wPatterns) wPatterns += " " + filter;
		else wPatterns = filter;
		try {
			Branch.setCharPref("patterns", wPatterns);
			//prefObj.savePrefFile(null); // save the prefs to disk -- component.js "loadSettings()" handles this now
			var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
			observerService.notifyObservers(null, "Adblock-PrefChange", "FilterChange");
			observerService.notifyObservers(null, "Adblock-SavePrefFile", null);
		} catch(e) {}
	}
}

// refilters all nodes of a window
function refilter(wnd) {
	var wasActive = opener.toggleObjectOverride(wnd,false);
	var data = /*wnd._Adblock||*/wnd.document._Adblock||{};
	// we flush the data below -- delete data[i]
	var i, node, contentType, contentLocation;
	
	for (i in data) {
		if (wnd.closed) return;
		node = data[i].node;
		contentLocation = data[i].contentLocation;
		contentType = data[i].contentType;
		delete data[i];
		
		// the "immediate" boolean directs non-delayed collapsation
		for (var j=0; j<node.length; j++)
			policy.shouldLoad(contentType, contentLocation, apiConstants.oldStyleAPI?node[j]:null, apiConstants.oldStyleAPI?wnd:node[j], apiConstants.oldStyleAPI?((node._AdblockImmediate=true)?null:null):apiConstants.IMMEDIATE, null);
	}
	var callback = function(chrome, content){ 
		if (!chrome.closed && !content.closed && content.document) 
			chrome.toggleObjectOverride(content,true); 
	};
	if (wasActive) opener.setTimeout(callback, 500, opener,wnd);
}

