/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.TwoColumnConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Stroke;
import java.util.Vector;

public class TwoColumnLayout
implements LayoutManager2 {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    private Vector[] components = new Vector[]{new Vector(), new Vector()};
    private TwoColumnConstraints title = null;
    private int margin = 0;
    private int topBuffer = 0;
    private int indent = 0;
    private int gap = 5;
    private int alignment = 0;
    private int leftRule;
    private int rightRule;
    private int centerRule;
    private int titleHeight;

    public TwoColumnLayout(int margin, int gap, int indent, int topBuffer, int alignment) {
        this.indent = indent;
        this.gap = gap;
        if (margin >= 0 && margin <= 50) {
            this.margin = margin;
        }
        if (topBuffer >= 0 && topBuffer <= 100) {
            this.topBuffer = topBuffer;
        }
        if (alignment == 0 || alignment == 2 || alignment == 1) {
            this.alignment = alignment;
        }
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        block17: {
            TwoColumnConstraints component;
            block16: {
                if (constraints == null) {
                    return;
                }
                component = null;
                try {
                    component = (TwoColumnConstraints)constraints;
                    component = (TwoColumnConstraints)component.clone();
                }
                catch (Throwable exception) {
                    return;
                }
                component.component = comp;
                if (component.position != 9) break block16;
                this.title = component;
                if (!this.title.stretch) break block17;
                this.title.align = 0;
                break block17;
            }
            if (component.position == 29) {
                while (this.components[1].size() > this.components[0].size()) {
                    this.components[0].add(null);
                }
                while (this.components[0].size() > this.components[1].size()) {
                    this.components[1].add(null);
                }
                this.components[0].add(component);
                this.components[1].add(null);
            } else if (component.position == 15) {
                this.components[0].add(component);
            } else if (component.position == 16) {
                this.components[0].add(component);
                while (this.components[1].size() < this.components[0].size()) {
                    this.components[1].add(null);
                }
            } else if (component.position == 26) {
                this.components[1].add(component);
            } else if (component.position == 27) {
                this.components[1].add(component);
                while (this.components[0].size() < this.components[1].size()) {
                    this.components[0].add(null);
                }
            }
        }
    }

    public void layoutContainer(Container parent) {
        this.positionRules(parent);
        this.positionTitle(parent);
        this.positionComponents(parent);
    }

    private void positionRules(Container parent) {
        int margin = this.margin(parent);
        if (this.alignment == 0) {
            this.leftRule = margin;
            this.centerRule = this.leftRule + this.minimumColumnWidth(0, parent) + this.gap;
            this.rightRule = parent.getWidth() - margin;
        } else if (this.alignment == 2) {
            this.centerRule = (int)(parent.getMinimumSize().getWidth() / 2.0);
            this.leftRule = this.centerRule - this.minimumColumnWidth(0, parent) - this.gap;
            this.rightRule = parent.getWidth() - margin;
        } else if (this.alignment == 1) {
            this.rightRule = parent.getWidth() - margin;
            this.centerRule = this.rightRule - this.minimumColumnWidth(1, parent);
            this.leftRule = this.centerRule - this.minimumColumnWidth(0, parent) - this.gap;
        }
    }

    private void positionTitle(Container parent) {
        if (this.title != null) {
            Component component = this.title.component;
            int width = (int)component.getMinimumSize().getWidth();
            this.titleHeight = (int)component.getMinimumSize().getHeight();
            if (component != null) {
                if (this.title.stretch) {
                    width = this.rightRule - this.leftRule;
                    component.setBounds(this.leftRule, 0, width, this.titleHeight);
                } else if (this.title.align == 31) {
                    component.setBounds(this.leftRule, 0, width, this.titleHeight);
                } else if (this.title.align == 35) {
                    int left = this.centerRule - width / 2;
                    component.setBounds(left, 0, width, this.titleHeight);
                } else if (this.title.align == 47) {
                    int left = this.rightRule - width;
                    component.setBounds(left, 0, width, this.titleHeight);
                }
            }
        }
    }

    private void positionComponents(Container parent) {
        int usedHeight = this.titleHeight + this.minimumClusterHeight();
        int topBuffer = this.topBuffer(usedHeight, parent);
        int leftHeight = 0;
        int rightHeight = 0;
        if (topBuffer < 0) {
            topBuffer = 0;
        }
        int y = this.titleHeight + topBuffer;
        for (int i = 0; i < this.rows(); ++i) {
            int offset;
            leftHeight = this.height(i, 0);
            if (leftHeight > (rightHeight = this.height(i, 1))) {
                offset = (leftHeight - rightHeight) / 2;
                this.positionComponent(y, i, 0, parent);
                this.positionComponent(y + offset, i, 1, parent);
                y += leftHeight;
                continue;
            }
            if (leftHeight < rightHeight) {
                offset = (rightHeight - leftHeight) / 2;
                this.positionComponent(y + offset, i, 0, parent);
                this.positionComponent(y, i, 1, parent);
                y += rightHeight;
                continue;
            }
            this.positionComponent(y, i, 0, parent);
            this.positionComponent(y, i, 1, parent);
            y += leftHeight;
        }
    }

    private void positionComponent(int y, int row, int column, Container parent) {
        TwoColumnConstraints constraints = null;
        try {
            constraints = (TwoColumnConstraints)this.components[column].elementAt(row);
        }
        catch (Throwable exception) {
            return;
        }
        int x = 0;
        if (constraints != null) {
            Component component = constraints.component;
            int width = (int)component.getPreferredSize().getWidth();
            int height = (int)component.getPreferredSize().getHeight();
            x = column == 0 ? this.leftRule : this.centerRule;
            if (component != null) {
                if (constraints.stretch && constraints.position == 29) {
                    width = this.rightRule - this.leftRule;
                    x = this.leftRule;
                } else if (constraints.stretch && column == 0) {
                    width = this.centerRule - this.leftRule;
                } else if (constraints.stretch && column == 1) {
                    width = this.rightRule - this.centerRule;
                } else if (constraints.position == 29) {
                    if (width > this.rightRule - this.leftRule) {
                        width = this.rightRule - this.leftRule;
                    }
                    x = this.leftRule;
                }
                if (constraints.indent) {
                    width -= this.indent;
                    x += this.indent;
                }
                component.setBounds(x, y, width, height);
            }
        }
    }

    private int minimumColumnWidth(int column, Container parent) {
        Component component = null;
        TwoColumnConstraints constraints = null;
        int width = 0;
        int temp = 0;
        for (int i = 0; i < this.components[column].size(); ++i) {
            constraints = (TwoColumnConstraints)this.components[column].elementAt(i);
            if (constraints == null || constraints.position == 29) continue;
            component = constraints.component;
            temp = (int)component.getMinimumSize().getWidth();
            if (constraints.indent) {
                temp += this.indent;
            }
            if (temp <= width) continue;
            width = temp;
        }
        return width;
    }

    private int minimumBothColumnsWidth(Container parent) {
        Component component = null;
        TwoColumnConstraints constraints = null;
        int width = 0;
        int temp = 0;
        if (this.title != null) {
            component = this.title.component;
            width = (int)component.getMinimumSize().getWidth();
        }
        for (int i = 0; i < this.components[0].size(); ++i) {
            constraints = (TwoColumnConstraints)this.components[0].elementAt(i);
            if (constraints == null || constraints.position != 29) continue;
            component = constraints.component;
            temp = (int)component.getMinimumSize().getWidth();
            if (constraints.indent) {
                temp += this.indent;
            }
            if (temp <= width) continue;
            width = temp;
        }
        return width;
    }

    private int minimumClusterHeight() {
        int height = 0;
        for (int i = 0; i < this.rows(); ++i) {
            height += this.rowHeight(i);
        }
        return height;
    }

    private int rows() {
        int rightRows;
        int rows = 0;
        int leftRows = this.components[0].size();
        rows = leftRows > (rightRows = this.components[1].size()) ? leftRows : rightRows;
        return rows;
    }

    private int rowHeight(int row) {
        int height2;
        int height = 0;
        int height1 = this.height(row, 0);
        height = height1 > (height2 = this.height(row, 1)) ? height1 : height2;
        return height;
    }

    private int height(int row, int column) {
        int height = 0;
        int width = 0;
        try {
            TwoColumnConstraints constraints = (TwoColumnConstraints)this.components[column].elementAt(row);
            if (constraints != null) {
                Component component = constraints.component;
                width = (int)component.getMinimumSize().getWidth();
                height = (int)component.getMinimumSize().getHeight();
                if (constraints.position == 15) {
                    if (width > this.centerRule - this.leftRule) {
                        component.setBounds(0, 0, this.centerRule - this.leftRule, height);
                    }
                } else if (constraints.position == 26) {
                    if (width > this.rightRule - this.centerRule) {
                        component.setBounds(0, 0, this.rightRule - this.centerRule, height);
                    }
                } else if (constraints.position == 29 && width > this.rightRule - this.leftRule) {
                    component.setBounds(0, 0, this.rightRule - this.leftRule, height);
                }
                height = (int)component.getMinimumSize().getHeight();
            }
        }
        catch (Throwable exception) {
            // empty catch block
        }
        return height;
    }

    private int margin(Container parent) {
        int amount = (int)(parent.getSize().getWidth() * (double)this.margin / 100.0);
        return amount;
    }

    private int topBuffer(int usedHeight, Container parent) {
        int amount = (int)parent.getSize().getHeight() - usedHeight;
        amount = amount * this.topBuffer / 100;
        return amount;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.positionTitle(parent);
        int width = this.minimumBothColumnsWidth(parent);
        int height = this.minimumClusterHeight() + this.titleHeight;
        return new Dimension(width, height);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    public void invalidateLayout(Container parent) {
        this.leftRule = 0;
        this.rightRule = 0;
        this.centerRule = 0;
        this.titleHeight = 0;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
        Component ctemp;
        TwoColumnConstraints constraints;
        Vector left = this.components[0];
        Vector right = this.components[1];
        for (int i = 0; i < left.size(); ++i) {
            constraints = (TwoColumnConstraints)left.get(i);
            if (constraints == null || (ctemp = constraints.component) == null || !ctemp.equals(comp)) continue;
            if (constraints.position != 29 && constraints.position != 16) break;
            right.remove(i);
            break;
        }
        for (int j = 0; j < right.size(); ++j) {
            constraints = (TwoColumnConstraints)right.get(j);
            if (constraints == null || (ctemp = constraints.component) == null || !ctemp.equals(comp)) continue;
            if (constraints.position != 29 && constraints.position != 27) break;
            left.remove(j);
            break;
        }
    }

    public void showRules(Graphics2D graphics, Color color) {
        int height = graphics.getClipBounds().height;
        Stroke currentStroke = graphics.getStroke();
        Color currentColor = graphics.getColor();
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 1.5f, new float[]{10.0f, 5.0f}, 5.0f);
        graphics.setColor(color);
        graphics.drawLine(this.leftRule, 0, this.leftRule, height);
        graphics.drawLine(this.centerRule, this.titleHeight, this.centerRule, height);
        graphics.drawLine(this.rightRule, 0, this.rightRule, height);
        graphics.drawLine(this.leftRule, this.titleHeight, this.rightRule, this.titleHeight);
        graphics.setStroke(stroke);
        graphics.drawLine(this.leftRule + this.indent, this.titleHeight, this.leftRule + this.indent, height);
        graphics.drawLine(this.centerRule + this.indent, this.titleHeight, this.centerRule + this.indent, height);
        graphics.setStroke(currentStroke);
        graphics.setColor(currentColor);
    }
}

