/*
    window.arguments[0] - String: Permanent datasource path
    window.arguments[1] - String: Root Node for above datasource
    window.arguments[2] - String: Root node to use for rdf:local-store
    window.arguments[3] - String: Prefix for RDF:about to use for each entry, a number will be appended to this when writing to the 
                                  datasource
    window.arguments[4] - String: RDF location for the type to store
    window.argumnets[5] - String: Name of menu being customized
*/

var g_tc; //treechildren tag
var g_tree; //tree tag
var g_mainDSource;
var g_mainDSRootNode;
var g_localStore;
var g_localStoreRootNode;
var g_sLiteralPrefix;
var g_RDF;
var g_RDFC;
var g_RDFCUtils;
var g_nameRDF;
var g_miscRDF;
var g_insertBeforeRDF;
var g_sMenuBeingCustomized;

function initDialog()
{
    var stringRes = document.getElementById("stringRes");
    
    g_tree = document.getElementById("element-tree");
    g_tc = document.getElementById("children-tree");
    
    if(window.arguments.length < 6)
    {
        alert("Error in menuCustomization.js: Not enough arguments supplied!");
        window.close();
        return;
    }
    
    g_RDF = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    g_RDFCUtils = Components.classes['@mozilla.org/rdf/container-utils;1'].getService(Components.interfaces.nsIRDFContainerUtils);
    g_RDFC = Components.classes['@mozilla.org/rdf/container;1'].createInstance(Components.interfaces.nsIRDFContainer);
    
    g_nameRDF = g_RDF.GetResource("http://www.3dbuzz.com/rdf#name");
    g_miscRDF = g_RDF.GetResource(window.arguments[4]);
    g_insertBeforeRDF = g_RDF.GetResource("http://www.3dbuzz.com/rdf#insertbefore");
    
    g_localStore = g_RDF.GetDataSource("rdf:local-store");
    g_mainDSource = g_RDF.GetDataSource(window.arguments[0]);
    g_mainDSRootNode = g_RDF.GetResource(window.arguments[1]);
    g_localStoreRootNode = g_RDF.GetResource(window.arguments[2]);
    g_sLiteralPrefix = window.arguments[3];
    
    g_sMenuBeingCustomized = window.arguments[5];
    document.getElementById("menuCustomization-dialog").setAttribute("title", 
                                stringRes.getString("mcDialogTitlePre") + " " + window.arguments[5] + " " +
                                                                                        stringRes.getString("mcDialogTitlePost"));
    
    load();
}

function load2(dsource, rootNode, treechild)
{
    var entries;
    
    try {
        entries = g_RDFCUtils.MakeSeq(dsource, rootNode).GetElements();
    } catch(e) {
        return;
    }
    
    while(entries.hasMoreElements())
    {
        var entry = entries.getNext();
        entry = entry.QueryInterface(Components.interfaces.nsIRDFResource);
        
        var misc = dsource.GetTarget(entry, g_miscRDF, true);
        var sName = dsource.GetTarget(entry, g_nameRDF, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        var insertBefore = dsource.GetTarget(entry, g_insertBeforeRDF, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        
        if(misc == null)
        {
            var treechild2 = document.createElement("treechildren");
            var item = addTreeRowToChild(treechild, sName, "", insertBefore);
            item.appendChild(treechild2);
            item.setAttribute("container", true);
            item.setAttribute("open", true);
            load2(dsource, entry, treechild2);
        }
        else
        {
            misc = misc.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
            addTreeRowToChild(treechild, sName, misc, insertBefore);
        }
    }
}

function load()
{
    load2(g_localStore, g_localStoreRootNode, g_tc);
}

function addTreeRowToChild(treechild, sName, sId, sInsertBefore)
{
    var item = document.createElement("treeitem");
    var row = document.createElement("treerow");
    
    var nameCell = document.createElement("treecell");
    var idCell = document.createElement("treecell");
    var ibCell = document.createElement("treecell");
    nameCell.setAttribute("label", sName);
    idCell.setAttribute("label", sId);
    ibCell.setAttribute("label", sInsertBefore);
    
    row.appendChild(nameCell);
    row.appendChild(idCell);
    row.appendChild(ibCell);
    item.appendChild(row);
    treechild.appendChild(item);
    
    if(sName == "separator")
    {
        row.setAttribute("properties", "separator");
        nameCell.setAttribute("properties", "separator");
        ibCell.setAttribute("properties", "separator");
    }
    
    return item;
}

function addTreeRow(sName, sId, sInsertBefore)
{
    return addTreeRowToChild(g_tc, sName, sId, sInsertBefore);
}

/*
    ind == -1 : Create a new row
    ind != -1 : Modify the row with index of "ind"
*/
function addRow(ind, sName, sId, sInsertBefore)
{
    var item;
    
    if(ind == -1)
    {
        item = addTreeRow(sName, sId, sInsertBefore);
    }
    else
    {
        item = getItem(ind);
        item.childNodes[0].childNodes[0].setAttribute("label", sName);
        item.childNodes[0].childNodes[1].setAttribute("label", sId);
        item.childNodes[0].childNodes[2].setAttribute("label", sInsertBefore);
    }
    
    selectTreeNode(item);
}

function onTreeDblClick(evnt)
{
    if(g_tree.currentIndex < 0)
        onAddItem();
    else
        onModifyItem();
}

function onAddItem()
{
    window.openDialog("chrome://3dbuzz/content/additem.xul","additem",
                        "chrome,centerscreen,modal=yes,dialog=yes",
                        g_mainDSource,
                        g_mainDSRootNode,
                        addRow,
                        -1,
                        g_sMenuBeingCustomized
                     );
    g_tree.focus();
}

function onModifyItem()
{
    if(g_tree.currentIndex < 0)
        return;
        
    var item = getItem(g_tree.currentIndex);
    var sName = item.childNodes[0].childNodes[0].getAttribute("label");
    var sId = item.childNodes[0].childNodes[1].getAttribute("label");
    var sInsertBefore = item.childNodes[0].childNodes[2].getAttribute("label");
    var isSeparator = (sName == "separator");
    
    window.openDialog("chrome://3dbuzz/content/additem.xul","additem",
                        "chrome,centerscreen,modal=yes,dialog=yes",
                        g_mainDSource,
                        g_mainDSRootNode,
                        addRow,
                        g_tree.currentIndex,
                        g_sMenuBeingCustomized,
                        sName,
                        sId,
                        sInsertBefore,
                        isSeparator,
                        isSeparator || (item.hasAttribute("container") && item.getAttribute("container")),
                        item.parentNode.getAttribute("id") != "children-tree"
                     );
    g_tree.focus();
}

function onAddSeparator()
{
    window.openDialog("chrome://3dbuzz/content/additem.xul","additem",
                        "chrome,centerscreen,modal=yes,dialog=yes",
                        g_mainDSource,
                        g_mainDSRootNode,
                        addRow,
                        -1,
                        g_sMenuBeingCustomized,
                        "separator",
                        "",
                        "",
                        true,
                        true,
                        false
                     );
    g_tree.focus();
}

function onCloneItem()
{
    if(g_tree.currentIndex < 0)
        return;
        
    var item = getItem(g_tree.currentIndex);
    var item2 = item.cloneNode(true); // "true" informs to clone all children as well
    item.parentNode.insertBefore(item2, item);
    selectTreeNode(item);
}

function removeTreeNode(node)
{
    var parentNode = node.parentNode;
    var p = parentNode.parentNode;
    parentNode.removeChild(node);
    
    if(parentNode.childNodes.length == 0)
    {
        p.removeChild(parentNode);
        p.removeAttribute("container");
        p.removeAttribute("open");
    }
}

var g_selectIndex;
function selectTreeNode2(items, node)
{
    for(var i = 0; i < items.length ;i++)
    {
        if(items[i] == node)
            return true;
            
        g_selectIndex++;
            
        if(items[i].getAttribute("container"))
        {
            if(selectTreeNode2(items[i].childNodes[1].childNodes, node))
                return true;
        }
    }
    
    return false;
}

function selectTreeNode(node)
{
    var items = g_tc.childNodes;
    g_selectIndex = 0;
    selectTreeNode2(items, node);
    g_tree.currentIndex = g_selectIndex;
    g_tree.focus();
}

function onDeleteItem()
{
    var nextSelection = -1;
    
    if(g_tree.currentIndex >= 0)
    {
        var node = getItem(g_tree.currentIndex);
        
        if(node.nextSibling != null)
            nextSelection = g_tree.currentIndex;
        else if(node.previousSibling != null)
            nextSelection = g_tree.currentIndex-1;
            
        removeTreeNode(node);
        g_tree.currentIndex = nextSelection;
        g_tree.focus();
    }
}

function onDeleteAllItems()
{
    var children = g_tc.childNodes;
    for(var i = 0; i < children.length; i++)
        g_tc.removeChild(children[i]);
}

var g_getItemIndex;

function getItem2(items, ind)
{
    for(var i = 0; i < items.length; i++)
    {
        if(g_getItemIndex == ind)
            return items[i];
    
        g_getItemIndex++
            
        if(items[i].getAttribute("container"))
        {
            var t = getItem2(items[i].childNodes[1].childNodes, ind);
            
            if(t != null)
                return t;
        }
    }
    return null;
}

function getItem(ind)
{
    g_getItemIndex = 0;
    var c = getItem2(g_tc.childNodes, ind);
    return c;
}

function onMoveRight()
{
    var items = g_tc.childNodes;
    var cur = g_tree.currentIndex;
    var parentItem;
    var childItem;
    var parentTreechild;
    
    if(cur < 1) //move left only works if we have an item on top and there is a selection
        return;
        
    // Get the tree row above
    parentItem = getItem(cur-1);//items[cur-1];
    childItem = getItem(cur);
    /*
        parentItem - treeitem
        parentItem.parentNode - treechildren
    */
    while(parentItem.parentNode != childItem.parentNode)
        parentItem = parentItem.parentNode.parentNode;
    
    if(parentItem.childNodes[0].childNodes[0].getAttribute("label") == "separator")
        return;
     
    {
        var stringRes = document.getElementById("stringRes");
        var msg = stringRes.getString("msgOverWritePre") + " ";
        if(parentItem.childNodes[0].childNodes[1].getAttribute("label").length > 0)
            msg += stringRes.getString("msgOverWriteParentURL");
        if(childItem.childNodes[0].childNodes[2].getAttribute("label").length > 0)
        {
            if(msg != (stringRes.getString("msgOverWritePre") + " "))
                msg += " " + stringRes.getString("msgOverWriteJoin") + " ";
            msg += stringRes.getString("msgOverWriteChildIB");
        }
            
        if(msg != stringRes.getString("msgOverWritePre") + " ")
        {
            msg += " " + stringRes.getString("msgOverWritePost");
            if(!opener.opener.MsgConfirm(msg))
                return;
        }
        
        parentItem.childNodes[0].childNodes[1].setAttribute("label", "");
        childItem.childNodes[0].childNodes[2].setAttribute("label", "");
    }
           
    if(!parentItem.getAttribute("container"))
    {
        parentItem.setAttribute("container", "true");
        parentItem.setAttribute("open", "true");
        
        parentTreechild = document.createElement("treechildren");
        parentItem.appendChild(parentTreechild);
    }else{
        parentTreechild = parentItem.childNodes[1];
    }
    
    childItem.parentNode.removeChild(childItem);
    parentTreechild.appendChild(childItem);
    selectTreeNode(childItem);
}

function onMoveLeft()
{
    var cur = g_tree.currentIndex;
    var items = g_tc.childNodes;
    
    if(cur < 0)
        return;
    
    var node = getItem(cur);
    var parentItem = node.parentNode;
    var parentsParent = parentItem.parentNode.parentNode;
    
    var parentID = parentItem.getAttribute("id")
    var p = parentItem.parentNode;;
    
    if(parentID != null && parentID == "children-tree")
        return;
    
    removeTreeNode(node);
    
    parentsParent.insertBefore(node, p.nextSibling);
    selectTreeNode(node);
}

function onMoveUp()
{
    var cur = g_tree.currentIndex;
    var items = g_tc.childNodes;
    
    if(cur < 1) //can't move up unless there is an element above - cut extra processing
        return;
        
    var node = getItem(cur);
    var parentItem = node.parentNode;
    var prevSibling = node.previousSibling;
    
    if(prevSibling != null) // the item is not at the top
    {
        parentItem.removeChild(node);
        parentItem.insertBefore(node, prevSibling);
        
        //g_tree.currentIndex = cur-1;
    }
        
    //g_tree.focus();
    selectTreeNode(node);
}

function onMoveDown()
{
    // Alternative approach
    // Set the selection to the next item and call onMoveUp, then set the selection to it's original value
    
    var cur = g_tree.currentIndex;
    var items = g_tc.childNodes;
    
    if(cur < 0)
        return;
        
    var node = getItem(cur);
    var parentItem = node.parentNode;
    var nextSibling = node.nextSibling;
    var nextNextSibling = null;
    
    if(nextSibling != null)
        nextNextSibling = nextSibling.nextSibling;
    
    if(nextSibling != null)
    {
        parentItem.removeChild(node);
        parentItem.insertBefore(node, nextNextSibling);
    }
    
    selectTreeNode(node);
}

function emptyDatasource(dsource, rootNode)
{
    var entries;
    var count = 0;
    var RDFC = Components.classes['@mozilla.org/rdf/container;1'].createInstance(Components.interfaces.nsIRDFContainer);
    
    try {
        entries = g_RDFCUtils.MakeSeq(dsource, rootNode).GetElements();
        RDFC.Init(dsource, rootNode);
    } catch(e) {
        return 0;
    }
    
    var ent = new Array(RDFC.GetCount());
    
    while(entries.hasMoreElements())
    {
        var entry = entries.getNext();
        entry = entry.QueryInterface(Components.interfaces.nsIRDFResource);
        
        var misc = dsource.GetTarget(entry, g_miscRDF, true);
        var sName = dsource.GetTarget(entry, g_nameRDF, true).QueryInterface(Components.interfaces.nsIRDFLiteral);
        var insertBefore = dsource.GetTarget(entry, g_insertBeforeRDF, true).QueryInterface(Components.interfaces.nsIRDFLiteral);
        
        if(misc == null)
        {
            emptyDatasource(dsource, entry);
            
            dsource.Unassert(entry, g_nameRDF, sName, true);
            dsource.Unassert(entry, g_insertBeforeRDF, insertBefore, true);
        }
        else
        {
            misc = misc.QueryInterface(Components.interfaces.nsIRDFLiteral);
            dsource.Unassert(entry, g_nameRDF, sName, true);
            dsource.Unassert(entry, g_miscRDF, misc, true);
            dsource.Unassert(entry, g_insertBeforeRDF, insertBefore, true);
        }
        
        ent[count] = entry;
        //RDFC.RemoveElement(entry, true);
        
        count++;
    }
    
    for(var i = 0; i < ent.length; i++)
        RDFC.RemoveElement(ent[i], true);
    
    return count;
}

var g_saveNum;
function save2(items, dsource, rootNode)
{
    var RDFC = Components.classes['@mozilla.org/rdf/container;1'].createInstance(Components.interfaces.nsIRDFContainer);

    try
    {
        RDFC.Init(dsource, rootNode);
    }
    catch(e)
    {
        g_RDFCUtils.MakeSeq(dsource, rootNode);
        RDFC.Init(dsource, rootNode);
    }
    
    var res;

    for(var i = 0; i < items.length; i++)
    {
        g_saveNum++;
        
        if(items[i].getAttribute("container"))
        {
            res = save2(items[i].childNodes[1].childNodes, dsource, g_RDF.GetResource(g_sLiteralPrefix+g_saveNum));
            dsource.Assert(res, g_nameRDF, g_RDF.GetLiteral(items[i].childNodes[0].childNodes[0].getAttribute("label")), true);
            dsource.Assert(res, g_insertBeforeRDF, g_RDF.GetLiteral(items[i].childNodes[0].childNodes[2].getAttribute("label")), true);
        }
        else
        {
            res = g_RDF.GetResource(g_sLiteralPrefix+g_saveNum);
            dsource.Assert(res, g_nameRDF, g_RDF.GetLiteral(items[i].childNodes[0].childNodes[0].getAttribute("label")), true);
            dsource.Assert(res, g_miscRDF, g_RDF.GetLiteral(items[i].childNodes[0].childNodes[1].getAttribute("label")), true);
            dsource.Assert(res, g_insertBeforeRDF, g_RDF.GetLiteral(items[i].childNodes[0].childNodes[2].getAttribute("label")), true);
        }
        //RDFC.InsertElementAt(res, 1, true);
        RDFC.AppendElement(res, true);
    }
    
    return rootNode;
}

function save()
{
    g_saveNum = 0;
    save2(g_tc.childNodes, g_localStore, g_localStoreRootNode);
    g_localStore.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
}

function onOK()
{
    emptyDatasource(g_localStore, g_localStoreRootNode);
    save();
    return true;
}