/*
    window.arguments[0] - Reference to the browser tabs
    window.arguments[1] - Reference to the currently selected tab
    window.arguments[2] - Reference to the browsers
    window.arguments[3] - Function: called with the obtained url
    window.arguments[4] - [Optional] The event object
*/

var g_tabs;
var g_selectedTab;
var g_browsers;
var g_callbackFunc;

function getURL(tab)
{
    var url;
    
    if(tab.contentWindow.main)
        url = tab.contentWindow.main.location.href;
    else if(tab.contentWindow.frames.length > 0 && tab.contentWindow.frames[0].main)
        url = tab.contentWindow.frames[0].main.location.href;
    else
        url = tab.currentURI.spec;
    
    return url;
}

function getURLTitle(tab)
{
    var sTitle;
    
    if(tab.contentWindow.main)
        sTitle = tab.contentWindow.main.document.title;
    else if(tab.contentWindow.frames.length > 0 && tab.contentWindow.frames[0].main)
        sTitle = tab.contentWindow.frames[0].main.document.title;
    else
        sTitle = tab.contentTitle;
    
    return sTitle;
}

function onInit()
{
    if(window.arguments.length < 3)
    {
        alert("Error in geturl.js: Not enough arguments!");
        return;
    }
    
    g_tabs = window.arguments[0];
    g_selectedTab = window.arguments[1];
    g_browsers = window.arguments[2];
    g_callbackFunc = window.arguments[3];
    
    //Fill up the menupopup
    var list = document.getElementById("tablist-menulist");
    var menuPopup = document.getElementById("tablist-menupopup");
    var sel = 0;
    
    for(var i = 0; i < g_tabs.length; i++)
    {
        var menuitem = document.createElement("menuitem");
        menuitem.setAttribute("label", "Tab " + (i+1) + ": " + getURLTitle(g_browsers[i]));
        menuitem.setAttribute("tooltiptext", getURL(g_browsers[i]));
        menuPopup.appendChild(menuitem);
        
        if(g_selectedTab == g_tabs[i])
            sel = i;
    }
    list.selectedIndex = sel;
    
    if(window.arguments.length > 4)
    {
        var evnt = window.arguments[4];
        if(evnt.shiftKey || evnt.ctrlKey || evnt.altKey)
        {
            onOK();
            window.close();
        }
    }
}

function onOK()
{
    var list = document.getElementById("tablist-menulist");
    if(list.selectedIndex < 0)
    {
        alert("Error in geturl.js: list.selectedIndex is less than zero.");
        return false;
    }
    
    var tab = g_browsers[list.selectedIndex];
    var url = getURL(tab);
    var sTitle = getURLTitle(tab);
    
    if(document.getElementById("strip-checkbox").checked)
    {
        var t = "3DBuzz - ";
        if(sTitle.indexOf(t) == 0)
        {
            sTitle = sTitle.substring(t.length, sTitle.length);
        }
    }
    
    g_callbackFunc(url, sTitle);
    
    return true;
}
