//
// C++ Implementation: regexpengine
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "regexpengine.h"


RegExpEngine::~RegExpEngine()
{
}

#include <fstream>
#include <string>
#include <stack>
#include <iostream>
#include <stdlib.h>

#include "maingeneratormap.h"
#include "keys.h"
#include "langdefloader.h"
#include "messages.h"
#include "textformatter.h"

// purpose:
// takes the contents of a file and transform to
// syntax highlighted code in html format

using namespace std;

typedef stack<RegExpStatePtr> stack_of_states;

typedef enum { FOUND_EOF=0, FOUND_NL, FOUND_END } load_line_ret;

load_line_ret
load_line(std::string& s, std::istream& is)
{
   s.erase();
   if (is.bad() || is.eof())
     return FOUND_EOF;

   char c;
   while (is.get(c))
   {
     if (c == '\n')
       return FOUND_NL;
     if (c != '\r')
       s.append(1, c);
   }

   return FOUND_END;
}

void
RegExpEngine::process_file(const char *file)
{
  istream *is = 0;

  if (file)
  {
    is = new ifstream(file);
    if (!is || ! (*is))
    {
      cerr << "Error in opening " << file
          << " for input" << endl ;
      exit(1) ;
    }
  }
  else
    is = &cin;

  std::string s;

  std::string::const_iterator start, end;
  boost::match_results<std::string::const_iterator> what;
  boost::match_flag_type flags;
  stack_of_states states_stack;

  RegExpStatePtr initial_state = currentstate;

  load_line_ret ret;
  while ((ret = load_line(s, *is)) != FOUND_EOF)
    {
      bool matched = true;
      start = s.begin();
      end = s.end();
      flags = boost::match_default;

      while (matched) {
        if (boost::regex_search(start, end, what, currentstate->reg_exp, flags))
          {
            string prefix = what.prefix();
            if (prefix.size())
              formatter->format(currentstate->get_elem(), prefix);

            for (unsigned int i = 1; i < what.size(); ++i) {
              if (what[i].matched) {
                formatter->format(currentstate->get_elem(i), string(what[i].first, what[i].second));
                if (currentstate->formatters[i]->getNextState()) {
                  states_stack.push(currentstate);
                  currentstate = currentstate->formatters[i]->getNextState();
                } else if (currentstate->formatters[i]->exit_state) {
                  if (currentstate->formatters[i]->exit_all) {
                    currentstate = initial_state;
                    states_stack = stack_of_states();
                  } else {
                    currentstate = states_stack.top();
                    states_stack.pop();
                  }
                }
                start = what[i].second;
                break; // no other match is possible
              }
            }

            flags |= boost::match_not_bol;
          }
        else
          {
            formatter->format(currentstate->get_elem(), string(start, end));
            matched = false;
          }
      }

      if (ret == FOUND_NL)
        formatter->format_nl(currentstate->get_elem(), "\n");
    }

  if (file)
    delete is;

  currentstate = initial_state; // reset the initial state
}

int process_file(const char *file, TextFormatter *pre, const string &path, const string &lang_file)
{
  RegExpStatePtr initial_state = LangDefLoader::get_lang_def(path, lang_file);

  try{
    printMessage("Processing " + string((file ? file : "standard input")) + " with regex");
    printMessage("Using language definition " + lang_file);
    RegExpEngine engine(initial_state, pre);
    engine.process_file(file);
  }
  catch(...)
  {
    exitError("error during regex processing");
  }
  return 0;
}
