/*
 * Copyright (C) 1999, 2000, 2002, 2003  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef HTMLDOCGENERATOR_H
#define HTMLDOCGENERATOR_H

#include "docgenerator.h"

class HtmlDocGenerator : public DocGenerator
{
 protected:
  string input_file_name;
  string doc_header;
  string doc_footer;
  string css_url;

  virtual void generate_doctype();
  virtual void generate_standard_style();
  virtual void close_meta();

 public:
  HtmlDocGenerator(const string &t, const string &i,
                   const string &h, const string &f, const string &c) :
    DocGenerator (t), input_file_name (i), doc_header (h),
    doc_footer (f), css_url (c) {}

  virtual void generate_top();
  virtual void generate_bottom();

  virtual void generate_start_doc();
  virtual void generate_end_doc();
};

#endif // HTMLDOCGENERATOR_H

