/* broken start to a new HTML wrapper
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

#include <signal.h>
#include "capaParser.h"
#include "capaCommon.h"
#include "ranlib.h"

#include "capaCGI.h"

int main(int argc, char *argv[])
{
  int input_return=0;

  signal(SIGFPE, SIG_IGN);
  strcpy(g_prog_name,argv[0]);
  setbuf(stdout,NULL);

  fprintf(stdout,"Content-type: text/html%c%c",LF,LF);

  input_return = web_get_input();
  web_header(stdout);

#ifdef  CAPA_WEB
  fprintf(stdout,"<!-- new capasbin, CAPA Version %s, %s -->\n",CAPA_VER,
	  COMPILE_DATE);
#else
  fprintf(stdout,"<!-- new capahtml, CAPA Version %s, %s -->\n",CAPA_VER,
	  COMPILE_DATE);
#endif  

  if ( input_return ) {
  } else {
    switch( g_run_mode ) {
    case 0: break;
    case WEB_CHECKIN: web_menu(); break;
    case WEB_TRYSET: web_printset(); break;
    case WEB_VIEWPREV: web_viewprevious(); break;
    case WEB_VIEWSUMMARY: 
    case WEB_EXAMSUMMARY:
    case WEB_QUIZSUMMARY: web_summary(g_run_mode);break;
#ifdef CAPA_WEB 
    case WEB_CHECKANS: web_grade(); break;
#endif
    default: break;
    }
  }
  web_footer(stdout);
  return 0;
}
