/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var {Cc, Ci, Cu, Cm, Cr} = require("chrome");
var xpcom = require("xpcom");



Cu.import("resource://gre/modules/XPCOMUtils.jsm"); 

var observerService = Cc["@mozilla.org/observer-service;1"]
    .getService(Ci.nsIObserverService);

const processResponse = require('http_observer/process_response');

// these are our target mime types for response interception.
var targetMimeTypes = /.*(javascript|ecmascript|html).*/i;
//var targetMimeTypes = /.*(html).*/i;

// ensure xhr won't create an infinite loop
// with html content.
var urlTester = require("html_script_finder/url_seen_tester").urlSeenTester;

 
var httpRequestObserver = {

	observe: function(request, aTopic, aData) {

	    var url, newListener, status;

            if (aTopic == "http-on-examine-response" ||
	        aTopic == "http-on-examine-cached-response" ||
	        aTopic == "http-on-examine-merged-response") {

		request.QueryInterface(Ci.nsIHttpChannel);
		//console.log('is', request.URI.spec,'whitelisted?', urlTester.isWhitelisted(request.URI.spec));
		//console.log('request is', request.URI.spec);
		if ((request.responseStatus < 300 || 
		     request.responseStatus > 399) &&
		    (targetMimeTypes.test(request.contentType) || 
		     request.contentType == undefined) &&
		    (!urlTester.isWhitelisted(request.URI.spec) &&
		     !urlTester.isWhitelisted(request.originalURI.spec))) {

		    //console.log('reponseStatus is', request.responseStatus);
		    newListener = new TracingListener();
		    request.QueryInterface(Ci.nsITraceableChannel);
		    newListener.originalListener = request.setNewListener(newListener);

		} else if (urlTester.isWhitelisted(request.URI.spec) ||
			   urlTester.isWhitelisted(request.originalURI.spec)){
		    //console.log('this is whitelisted', request.URI.spec, 'or original', request.originalURI.spec);
		    urlTester.clearUrl(request.URI.spec);
		    urlTester.clearUrl(request.originalURI.spec);

		}

	    }
	},

	QueryInterface : function (aIID) {
            if (aIID.equals(Ci.nsIObserver) ||
		aIID.equals(Ci.nsISupports)) {
		return this;
            }
            throw Components.results.NS_NOINTERFACE;
	}
};

// Copy response listener implementation.
function TracingListener() {
    this.originalListener = null;
    this.receivedData = null;   // array for incoming data.
}

TracingListener.prototype = {

	onDataAvailable: function(request, context, inputStream, offset, count) {
            var binaryInputStream = Cc["@mozilla.org/binaryinputstream;1"].
		                        createInstance(Ci.nsIBinaryInputStream);
            binaryInputStream.setInputStream(inputStream);        
            var data = binaryInputStream.readBytes(count);
	    this.receivedData.push(data);
	},

	onStartRequest: function(request, context) {
	    this.receivedData = []; //initialize the array
            this.originalListener.onStartRequest(request, context);
	    this.charset = request.contentCharset;
	},

	onStopRequest: function(request, context, statusCode) {
	    try {
	    // pass method arguments as object.
		//console.log('onstoprequest triggered');
	    var responseInfo = {'request': request,
				'context': context, 
				'statusCode': statusCode};
	    var responseHandler = processResponse.ProcessResponse(this, responseInfo);

	    responseHandler.processAllTypes();
	    } catch (e) {
		console.log('error in onStopRequest', e, e.lineNumber);
	    }
	},

	QueryInterface: function (aIID) {
            if (aIID.equals(Ci.nsIStreamListener) ||
		aIID.equals(Ci.nsISupports)) {
		return this;
            }
            throw Components.results.NS_NOINTERFACE;
	}
    }

observerService.addObserver(httpRequestObserver,
			    "http-on-examine-response", false);

observerService.addObserver(httpRequestObserver,
  "http-on-examine-cached-response", false);

observerService.addObserver(httpRequestObserver,
  "http-on-examine-merged-response", false);


/* remove observer */
exports.removeHttpObserver = function () {
    try {

	observerService.removeObserver(httpRequestObserver,
				       "http-on-examine-response");

	observerService.removeObserver(httpRequestObserver,
				    "http-on-examine-cached-response");

	observerService.removeObserver(httpRequestObserver,
				    "http-on-examine-merged-response");

	console.log('turned off http observer');

    } catch (e) {
	console.log(e);
    }
}