#!/bin/sh
#$Id: check_cue.sh.in,v 1.19 2004/05/06 12:05:50 rocky Exp $
# Tests to see that BIN/CUE and cdrdao TOC file iamge reading is correct
# (via cd-info).

if test -n "-L/usr/local/lib -lvcdinfo -liso9660 -lcdio -lm  " ; then
  vcd_opt='--no-vcd'
fi

if test -z "$srcdir" ; then
  srcdir=`pwd`
fi

. ${srcdir}/check_common_fn

if test ! -x ../src/cd-info ; then
  exit 77
fi

BASE=`basename $0 .sh`

fname=cdda
testnum=CD-DA
opts="--quiet --cue-file ${srcdir}/${fname}.cue --no-cddb"
test_cdinfo "$opts" ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cd-info CUE test $testnum" "cd-info $opts"
  

opts="--quiet --bin-file ${srcdir}/${fname}.bin --no-cddb"
test_cdinfo "$opts" ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cd-info BIN test $testnum" "cd-info $opts"

opts="--quiet --toc-file ${srcdir}/${fname}.toc --no-cddb"
test_cdinfo "$opts" ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC "cd-info TOC test $testnum" "cd-info $opts"

fname=isofs-m1
testnum='ISO 9660 mode1 CUE'
if test -f  ${srcdir}/${fname}.bin ; then
  opts="-q --cue-file ${srcdir}/${fname}.cue --iso9660"
  test_cdinfo "$opts" ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cd-info CUE test $testnum" "$opts"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.bin. Test $testnum skipped."
fi

testnum='ISO 9660 mode1 TOC'
if test -f  ${srcdir}/${fname}.bin ; then
  opts="-q --toc-file ${srcdir}/${fname}.toc --iso9660"
  test_cdinfo "$opts" ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cd-info TOC test $testnum" "cd-info $opts"
else 
  echo "Don't see TOC file ${srcdir}/${fname}.bin. Test $testnum skipped."
fi

fname=vcd_demo
if test -z "-L/usr/local/lib -lvcdinfo -liso9660 -lcdio -lm  " ; then
  right=${srcdir}/${fname}.right
else
  right=${srcdir}/${fname}_vcdinfo.right
fi
testnum='Video CD'
if test -f ${srcdir}/${fname}.bin ; then
  opts="-q -c ${srcdir}/${fname}.cue --iso9660"
  test_cdinfo "$opts" ${fname}.dump $right
  RC=$?
  check_result $RC "cd-info CUE test $testnum" "cd-info $opts" 

  opts="-q -t ${srcdir}/${fname}.toc --iso9660"
  if test -f ${srcdir}/${fname}.toc ; then
    test_cdinfo "$opts" ${fname}.dump $right
    RC=$?
    check_result $RC "cd-info TOC test $testnum" "cd-info $opts"
  else 
    echo "Don't see TOC file ${srcdir}/${fname}.toc. Test $testnum skipped."
  fi
else 
  echo "Don't see CUE file ${srcdir}/${fname}.cue. Test $testnum skipped."
fi

fname=svcd_ogt_test_ntsc
testnum='Super Video CD'
if test -f ${srcdir}/${fname}.bin ; then
  opts="-q --cue-file ${srcdir}/${fname}.cue $vcd_opt --iso9660"
  test_cdinfo "$opts" ${fname}.dump ${srcdir}/${fname}.right
  RC=$?
  check_result $RC "cd-info CUE test $testnum" "cd-info $opts"
else 
  echo "Don't see CUE file ${srcdir}/${fname}.bin. Test $testnum skipped."
fi

exit $RC

#;;; Local Variables: ***
#;;; mode:shell-script ***
#;;; eval: (sh-set-shell "bash") ***
#;;; End: ***
