#! /bin/sh
#
# gnulib-version.sh -- creates gnulib-version.c (from ../import-gnulib.config)
# Copyright (C) 2007 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
# USA.
#

topsrcdir="$1"
srcdir="$2"
configfile="$3"

outfile="${srcdir}"/gnulib-version.c

source $configfile

if [ -z "$gnulib_version" ] 
then
    echo "Error: There should be a gnulib_version setting in $configfile, but there is not." >&2
    exit 1
fi


cat > "${outfile}".new <<EOF
/* This file is automatically generated by $0 and simply records which version of gnulib we used. */
const char * const gnulib_version = "$gnulib_version";
EOF

if test -f "$outfile" ; then
    if diff "${outfile}".new "${outfile}" > /dev/null 
    then
	# nothing to do
	rm "${outfile}".new
	exit 0
    fi
fi
mv "${outfile}".new "${outfile}"
