;; -*- Mode:Lisp; Package:CLIO-OPEN; Base:10; Lowercase:T; Fonts:(CPTFONT); Syntax:Common-Lisp -*-


;;;----------------------------------------------------------------------------------+
;;;                                                                                  |
;;;                          TEXAS INSTRUMENTS INCORPORATED                          |
;;;                                  P.O. BOX 149149                                 |
;;;                                AUSTIN, TEXAS 78714                               |
;;;                                                                                  |
;;;             Copyright (C) 1989, 1990 Texas Instruments Incorporated.             |
;;;                                                                                  |
;;; Permission is granted to any individual or institution to use, copy, modify, and |
;;; distribute this software, provided that  this complete copyright and  permission |
;;; notice is maintained, intact, in all copies and supporting documentation.        |
;;;                                                                                  |
;;; Texas Instruments Incorporated provides this software "as is" without express or |
;;; implied warranty.                                                                |
;;;                                                                                  |
;;;----------------------------------------------------------------------------------+

(in-package "CLIO-OPEN")

;;;----------------------------------------------------------------------------+
;;;                                                                            |
;;;                         Scroll Bar Geometry                                |
;;;                                                                            |
;;;----------------------------------------------------------------------------+

(defconstant
  *scrollbar-dimensions*
  (list
    :small       (make-scrollbar
		   :anchor-height 5 
		   :anchor-width 13 
		   :arrow-height 4    
		   :arrow-width 6
		   :cable-margin 1
		   :cable-width 3
		   :margin 2
		   )
    :medium      (make-scrollbar
		   :anchor-height 6 
		   :anchor-width 15 
		   :arrow-height 5    
		   :arrow-width 8
		   :cable-margin 1 
		   :cable-width 3 
		   :margin 2 
		   )
    :large       (make-scrollbar
		   :anchor-height 7 
		   :anchor-width 17 
		   :arrow-height 6    
		   :arrow-width 10
		   :cable-margin 1
		   :cable-width 3
		   :margin 3
		   )
    :extra-large (make-scrollbar
		   :anchor-height 9
		   :anchor-width 21
		   :arrow-height 8   
		   :arrow-width 14
		   :cable-margin 2
		   :cable-width 5
		   :margin 3
		   ))
  "OPEN LOOK dimensions for scrollbar bitmaps (in pixels).")

(defimage small-vertical-elevator
  '#*0111111111110
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000011000011
  '#*1000111100011
  '#*1001111110011
  '#*1001111110011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1111111111111
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1111111111111
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1001111110011
  '#*1001111110011
  '#*1000111100011
  '#*1000011000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1000000000011
  '#*1111111111111
  '#*0111111111110
  )

(defimage medium-vertical-elevator
  '#*011111111111110
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000110000011
  '#*100001111000011
  '#*100011111100011
  '#*100111111110011
  '#*100111111110011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*111111111111111
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*111111111111111
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100111111110011
  '#*100111111110011
  '#*100011111100011
  '#*100001111000011
  '#*100000110000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*100000000000011
  '#*111111111111111
  '#*011111111111110
  )

(defimage large-vertical-elevator
  '#*01111111111111110
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000001100000011
  '#*10000011110000011
  '#*10000111111000011
  '#*10001111111100011
  '#*10011111111110011
  '#*10011111111110011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*11111111111111111
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*11111111111111111
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10011111111110011
  '#*10011111111110011
  '#*10001111111100011
  '#*10000111111000011
  '#*10000011110000011
  '#*10000001100000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*01111111111111111
  '#*01111111111111100  
  )

(defimage extra-large-vertical-elevator
  '#*011111111111111111110
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000110000000011
  '#*100000001111000000011
  '#*100000011111100000011
  '#*100000111111110000011
  '#*100001111111111000011
  '#*100011111111111100011
  '#*100111111111111110011
  '#*100111111111111110011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*111111111111111111111
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*111111111111111111111
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100111111111111110011
  '#*100111111111111110011
  '#*100011111111111100011
  '#*100001111111111000011
  '#*100000111111110000011
  '#*100000011111100000011
  '#*100000001111000000011
  '#*100000000110000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*100000000000000000011
  '#*111111111111111111111
  '#*011111111111111111100	  
  )



(defimage small-horizontal-elevator
  '#*01111111111111111111111111111111111111110
  '#*10000000000001000000000000100000000000011
  '#*10000000000001000000000000100000000000011
  '#*10000001100001000000000000100001100000011
  '#*10000011100001000000000000100001110000011
  '#*10000111100001000000000000100001111000011
  '#*10000111100001000000000000100001111000011
  '#*10000011100001000000000000100001110000011
  '#*10000001100001000000000000100001100000011
  '#*10000000000001000000000000100000000000011
  '#*10000000000001000000000000100000000000011
  '#*11111111111111111111111111111111111111111
  '#*01111111111111111111111111111111111111110)


(defimage medium-horizontal-elevator
  '#*01111111111111111111111111111111111111111111110
  '#*10000000000000010000000000000010000000000000011
  '#*10000000000000010000000000000010000000000000011
  '#*10000000110000010000000000000010000011000000011
  '#*10000001110000010000000000000010000011100000011
  '#*10000011110000010000000000000010000011110000011
  '#*10000111110000010000000000000010000011111000011
  '#*10000111110000010000000000000010000011111000011
  '#*10000011110000010000000000000010000011110000011
  '#*10000001110000010000000000000010000011100000011
  '#*10000000110000010000000000000010000011000000011
  '#*10000000000000010000000000000010000000000000011
  '#*10000000000000010000000000000010000000000000011
  '#*11111111111111111111111111111111111111111111111
  '#*01111111111111111111111111111111111111111111110)


(defimage large-horizontal-elevator
  '#*01111111111111111111111111111111111111111111111111100
  '#*10000000000000000100000000000000001000000000000000011
  '#*10000000000000000100000000000000001000000000000000011
  '#*10000000011000000100000000000000001000000110000000011
  '#*10000000111000000100000000000000001000000111000000011
  '#*10000001111000000100000000000000001000000111100000011
  '#*10000011111000000100000000000000001000000111110000011
  '#*10000111111000000100000000000000001000000111111000011
  '#*10000111111000000100000000000000001000000111111000011
  '#*10000011111000000100000000000000001000000111110000011
  '#*10000001111000000100000000000000001000000111100000011
  '#*10000000111000000100000000000000001000000111000000011
  '#*10000000011000000100000000000000001000000110000000011
  '#*10000000000000000100000000000000001000000000000000011
  '#*10000000000000000100000000000000001000000000000000011
  '#*11111111111111111111111111111111111111111111111111110
  '#*01111111111111111111111111111111111111111111111111110)


(defimage extra-large-horizontal-elevator
  '#*01111111111111111111111111111111111111111111111111111111111111110
  '#*10000000000000000000010000000000000000000010000000000000000000011
  '#*10000000000000000000010000000000000000000010000000000000000000011
  '#*10000000000011000000010000000000000000000010000000110000000000011
  '#*10000000000111000000010000000000000000000010000000111000000000011
  '#*10000000001111000000010000000000000000000010000000111100000000011
  '#*10000000011111000000010000000000000000000010000000111110000000011
  '#*10000000111111000000010000000000000000000010000000111111000000011
  '#*10000001111111000000010000000000000000000010000000111111100000011
  '#*10000011111111000000010000000000000000000010000000111111110000011
  '#*10000011111111000000010000000000000000000010000000111111110000011
  '#*10000001111111000000010000000000000000000010000000111111100000011
  '#*10000000111111000000010000000000000000000010000000111111000000011
  '#*10000000011111000000010000000000000000000010000000111110000000011
  '#*10000000001111000000010000000000000000000010000000111100000000011
  '#*10000000000111000000010000000000000000000010000000111000000000011
  '#*10000000000011000000010000000000000000000010000000110000000000011
  '#*10000000000000000000010000000000000000000010000000000000000000011
  '#*10000000000000000000010000000000000000000010000000000000000000011
  '#*11111111111111111111111111111111111111111111111111111111111111110
  '#*01111111111111111111111111111111111111111111111111111111111111110)

(defparameter
  *scrollbar-images*
  (list
    :vertical   (list
		  :small       small-vertical-elevator
		  :medium      medium-vertical-elevator
		  :large       large-vertical-elevator
		  :extra-large extra-large-vertical-elevator
		  )
    :horizontal (list
		  :small       small-horizontal-elevator
		  :medium      medium-horizontal-elevator
		  :large       large-horizontal-elevator
		  :extra-large extra-large-horizontal-elevator
		  )
    ))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; text images

(defparameter
  *text-caret-dimensions*
  (list
    :small        (make-text-caret 
		    :height    5
		    :width     5
		    :baseline-offset  2)
    :medium       (make-text-caret 
		    :height    6
		    :width     5
		    :inactive-height  7
		    :baseline-offset  2)
    :large        (make-text-caret 
		    :height    7
		    :width     7
		    :baseline-offset  2)
    :extra-large  (make-text-caret 
		    :height    9
		    :width     9
		    :baseline-offset  3)))

(defimage small-active-text-caret
   '#*00100
   '#*00100
   '#*01110
   '#*01110
   '#*11111)

(defimage small-inactive-text-caret
   '#*00100
   '#*01010
   '#*10101
   '#*01010
   '#*00100)

(defimage medium-active-text-caret
   '#*00100
   '#*00100
   '#*01110
   '#*01110
   '#*11111
   '#*11111)

(defimage medium-inactive-text-caret
   '#*0001000
   '#*0010100
   '#*0101010
   '#*1010101
   '#*0101010
   '#*0010100
   '#*0001000)

(defimage large-active-text-caret
   '#*0001000
   '#*0001000
   '#*0011100
   '#*0011100
   '#*0111110
   '#*0111110
   '#*1111111)

(defimage large-inactive-text-caret
   '#*0001000
   '#*0010100
   '#*0101010
   '#*1010101
   '#*0101010
   '#*0010100
   '#*0001000)

(defimage extra-large-active-text-caret
   '#*000010000
   '#*000010000
   '#*000111000
   '#*000111000
   '#*001111100
   '#*001111100
   '#*011111110
   '#*011111110
   '#*111111111)

(defimage extra-large-inactive-text-caret
   '#*000010000
   '#*000101000
   '#*001010100
   '#*010101010
   '#*101010101
   '#*010101010
   '#*001010100
   '#*000101000
   '#*000010000)

(defparameter
  *text-caret-images*
  (list :active   (list
		    :small        small-active-text-caret
		    :medium       medium-active-text-caret
		    :large        large-active-text-caret
		    :extra-large  extra-large-active-text-caret)
	:inactive (list
		    :small        small-inactive-text-caret
		    :medium       medium-inactive-text-caret
		    :large        large-inactive-text-caret
		    :extra-large  extra-large-inactive-text-caret)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; scrolling text button images

(defimage small-text-scroll-left-arrow
   '#*0111111111100
   '#*1000000000010
   '#*1000000000011
   '#*1000001100011
   '#*1000011100011
   '#*1000111100011
   '#*1000111100011
   '#*1000011100011
   '#*1000001100011
   '#*1000000000011
   '#*1000000000011
   '#*0111111111111
   '#*0011111111110)

(defimage small-text-scroll-left-highlighted-arrow
   '#*0111111111100
   '#*1000000000010
   '#*1011111111011
   '#*1011110011011
   '#*1011100011011
   '#*1011000011011
   '#*1011000011011
   '#*1011100011011
   '#*1011110011011
   '#*1011111111011
   '#*1000000000011
   '#*0111111111111
   '#*0011111111110)

(defimage small-text-scroll-right-arrow
   '#*0111111111100
   '#*1000000000010
   '#*1000000000011
   '#*1000110000011
   '#*1000111000011
   '#*1000111100011
   '#*1000111100011
   '#*1000111000011
   '#*1000110000011
   '#*1000000000011
   '#*1000000000011
   '#*0111111111111
   '#*0011111111110)

(defimage small-text-scroll-right-highlighted-arrow
   '#*0111111111100
   '#*1000000000010
   '#*1011111111011
   '#*1011001111011
   '#*1011000111011
   '#*1011000011011
   '#*1011000011011
   '#*1011000111011
   '#*1011001111011
   '#*1011111111011
   '#*1000000000011
   '#*0111111111111
   '#*0011111111110)


(defimage medium-text-scroll-left-arrow 
   '#*011111111111100
   '#*100000000000010
   '#*100000000000011
   '#*100000011000011
   '#*100000111000011
   '#*100001111000011
   '#*100011111000011
   '#*100011111000011
   '#*100001111000011
   '#*100000111000011
   '#*100000011000011
   '#*100000000000011
   '#*100000000000011
   '#*011111111111111
   '#*001111111111110)

(defimage medium-text-scroll-left-highlighted-arrow
   '#*011111111111100
   '#*100000000000010
   '#*101111111111011
   '#*101111100111011
   '#*101111000111011
   '#*101110000111011
   '#*101100000111011
   '#*101100000111011
   '#*101110000111011
   '#*101111000111011
   '#*101111100111011
   '#*101111111111011
   '#*100000000000011
   '#*011111111111111
   '#*001111111111110)

(defimage medium-text-scroll-right-arrow
   '#*011111111111100
   '#*100000000000010
   '#*100000000000011
   '#*100001100000011
   '#*100001110000011
   '#*100001111000011
   '#*100001111100011
   '#*100001111100011
   '#*100001111000011
   '#*100001110000011
   '#*100001100000011
   '#*100000000000011
   '#*100000000000011
   '#*011111111111111
   '#*001111111111110)

(defimage medium-text-scroll-right-highlighted-arrow
   '#*011111111111100
   '#*100000000000010
   '#*101111111111011
   '#*101110011111011
   '#*101110001111011
   '#*101110000111011
   '#*101110000011011
   '#*101110000011011
   '#*101110000111011
   '#*101110001111011
   '#*101110011111011
   '#*101111111111011
   '#*100000000000011
   '#*011111111111111
   '#*001111111111110)


(defimage large-text-scroll-left-arrow 
   '#*01111111111111100
   '#*10000000000000010
   '#*10000000000000011
   '#*10000000011000011
   '#*10000000111000011
   '#*10000001111000011
   '#*10000011111000011
   '#*10000111111000011
   '#*10000111111000011
   '#*10000011111000011
   '#*10000001111000011
   '#*10000000111000011
   '#*10000000011000011
   '#*10000000000000011
   '#*10000000000000011
   '#*01111111111111111
   '#*00111111111111110)

(defimage large-text-scroll-left-highlighted-arrow
   '#*01111111111111100
   '#*10000000000000010
   '#*10111111111111011
   '#*10111111100111011
   '#*10111111000111011
   '#*10111110000111011
   '#*10111100000111011
   '#*10111000000111011
   '#*10111000000111011
   '#*10111100000111011
   '#*10111110000111011
   '#*10111111000111011
   '#*10111111100111011
   '#*10111111111111011
   '#*10000000000000011
   '#*01111111111111111
   '#*00111111111111110)

(defimage large-text-scroll-right-arrow
   '#*01111111111111100
   '#*10000000000000010
   '#*10000000000000011
   '#*10000110000000011
   '#*10000111000000011
   '#*10000111100000011
   '#*10000111110000011
   '#*10000111111000011
   '#*10000111111000011
   '#*10000111110000011
   '#*10000111100000011
   '#*10000111000000011
   '#*10000110000000011
   '#*10000000000000011
   '#*10000000000000011
   '#*01111111111111111
   '#*00111111111111110)



(defimage large-text-scroll-right-highlighted-arrow
   '#*01111111111111100
   '#*10000000000000010
   '#*10111111111111011
   '#*10111001111111011
   '#*10111000111111011
   '#*10111000011111011
   '#*10111000001111011
   '#*10111000000111011
   '#*10111000000111011
   '#*10111000001111011
   '#*10111000011111011
   '#*10111000111111011
   '#*10111001111111011
   '#*10111111111111011
   '#*10000000000000011
   '#*01111111111111111
   '#*00111111111111110)


(defimage extra-large-text-scroll-left-arrow 
   '#*0111111111111111111111100
   '#*1000000000000000000000010
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000011000000011
   '#*1000000000000111000000011
   '#*1000000000001111000000011
   '#*1000000000011111000000011
   '#*1000000000111111000000011
   '#*1000000001111111000000011
   '#*1000000011111111000000011
   '#*1000000011111111000000011
   '#*1000000001111111000000011
   '#*1000000000111111000000011
   '#*1000000000011111000000011
   '#*1000000000001111000000011
   '#*1000000000000111000000011
   '#*1000000000000011000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*0111111111111111111111111
   '#*0011111111111111111111110)

(defimage extra-large-text-scroll-left-highlighted-arrow
   '#*0111111111111111111111100
   '#*1000000000000000000000010
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1011111111111100111111011
   '#*1011111111111000111111011
   '#*1011111111110000111111011
   '#*1011111111100000111111011
   '#*1011111111000000111111011
   '#*1011111110000000111111011
   '#*1011111100000000111111011
   '#*1011111100000000111111011
   '#*1011111110000000111111011
   '#*1011111111000000111111011
   '#*1011111111100000111111011
   '#*1011111111110000111111011
   '#*1011111111111000111111011
   '#*1011111111111100111111011
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1000000000000000000000011
   '#*0111111111111111111111111
   '#*0011111111111111111111110)

(defimage extra-large-text-scroll-right-arrow
   '#*0111111111111111111111100
   '#*1000000000000000000000010
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000011000000000000011
   '#*1000000011100000000000011
   '#*1000000011110000000000011
   '#*1000000011111000000000011
   '#*1000000011111100000000011
   '#*1000000011111110000000011
   '#*1000000011111111000000011
   '#*1000000011111111000000011
   '#*1000000011111110000000011
   '#*1000000011111100000000011
   '#*1000000011111000000000011
   '#*1000000011110000000000011
   '#*1000000011100000000000011
   '#*1000000011000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*1000000000000000000000011
   '#*0111111111111111111111111
   '#*0011111111111111111111110)

(defimage extra-large-text-scroll-right-highlighted-arrow
   '#*0111111111111111111111100
   '#*1000000000000000000000010
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1011111100111111111111011
   '#*1011111100011111111111011
   '#*1011111100001111111111011
   '#*1011111100000111111111011
   '#*1011111100000011111111011
   '#*1011111100000001111111011
   '#*1011111100000000111111011
   '#*1011111100000000111111011
   '#*1011111100000001111111011
   '#*1011111100000011111111011
   '#*1011111100000111111111011
   '#*1011111100001111111111011
   '#*1011111100011111111111011
   '#*1011111100111111111111011
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1011111111111111111111011
   '#*1000000000000000000000011
   '#*0111111111111111111111111
   '#*0011111111111111111111110)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; scrolling numeric button images

(defimage small-numeric-scroll-button
   '#*011111111111111111111100
   '#*100000000001000000000010
   '#*100000000001000000000011
   '#*100000000001000000000011
   '#*100001100001001111110011
   '#*100011110001001111110011
   '#*100111111001000111100011
   '#*100111111001000011000011
   '#*100000000001000000000011
   '#*100000000001000000000011
   '#*100000000001000000000011
   '#*011111111111111111111111
   '#*001111111111111111111110)

(defimage small-numeric-scroll-up-highlighted-button
   '#*011111111111111111111100
   '#*100000000001000000000010
   '#*101111111101000000000011
   '#*101111111101000000000011
   '#*101110011101001111110011
   '#*101100001101001111110011
   '#*101000000101000111100011
   '#*101000000101000011000011
   '#*101111111101000000000011
   '#*101111111101000000000011
   '#*100000000001000000000011
   '#*011111111111111111111111
   '#*001111111111111111111110)

(defimage small-numeric-scroll-down-highlighted-button
   '#*011111111111111111111100
   '#*100000000001000000000010
   '#*100000000001011111111011
   '#*100000000001011111111011
   '#*100001100001010000001011
   '#*100011110001010000001011
   '#*100111111001011000011011
   '#*100111111001011100111011
   '#*100000000001011111111011
   '#*100000000001011111111011
   '#*100000000001000000000011
   '#*011111111111111111111111
   '#*001111111111111111111110)

(defimage medium-numeric-scroll-button
   '#*0111111111111111111111111100
   '#*1000000000000100000000000010
   '#*1000000000000100000000000011
   '#*1000000000000100000000000011
   '#*1000001100000100111111110011
   '#*1000011110000100111111110011
   '#*1000111111000100011111100011
   '#*1001111111100100001111000011
   '#*1001111111100100000110000011
   '#*1000000000000100000000000011
   '#*1000000000000100000000000011
   '#*1000000000000100000000000011
   '#*1000000000000100000000000011
   '#*0111111111111111111111111111
   '#*0011111111111111111111111110)

(defimage medium-numeric-scroll-up-highlighted-button
   '#*0111111111111111111111111100
   '#*1000000000000100000000000010
   '#*1011111111110100000000000011
   '#*1011111111110100000000000011
   '#*1011110011110100111111110011
   '#*1011100001110100111111110011
   '#*1011000000110100011111100011
   '#*1010000000010100001111000011
   '#*1010000000010100000110000011
   '#*1011111111110100000000000011
   '#*1011111111110100000000000011
   '#*1011111111110100000000000011
   '#*1000000000000100000000000011
   '#*0111111111111111111111111111
   '#*0011111111111111111111111110)

(defimage medium-numeric-scroll-down-highlighted-button
   '#*0111111111111111111111111100
   '#*1000000000000100000000000010
   '#*1000000000000101111111111011
   '#*1000000000000101111111111011
   '#*1001111111100101111001111011
   '#*1001111111100101110000111011
   '#*1000111111000101100000011011
   '#*1000011110000101000000001011
   '#*1000001100000101000000001011
   '#*1000000000000101111111111011
   '#*1000000000000101111111111011
   '#*1000000000000101111111111011
   '#*1000000000000100000000000011
   '#*0111111111111111111111111111
   '#*0011111111111111111111111110)

(defimage large-numeric-scroll-button
   '#*01111111111111111111111111111100
   '#*10000000000000010000000000000010
   '#*10000000000000010000000000000011
   '#*10000000000000010000000000000011
   '#*10000000000000010000000000000011
   '#*10000001100000010011111111110011
   '#*10000011110000010011111111110011
   '#*10000111111000010001111111100011
   '#*10001111111100010000111111000011
   '#*10011111111110010000011110000011
   '#*10011111111110010000001100000011
   '#*10000000000000010000000000000011
   '#*10000000000000010000000000000011
   '#*10000000000000010000000000000011
   '#*10000000000000010000000000000011
   '#*01111111111111111111111111111111
   '#*00111111111111111111111111111110)

(defimage large-numeric-scroll-up-highlighted-button
   '#*01111111111111111111111111111100
   '#*10000000000000010000000000000010
   '#*10111111111111010000000000000011
   '#*10111111111111010000000000000011
   '#*10111111111111010000000000000011
   '#*10111110011111010011111111110011
   '#*10111100001111010011111111110011
   '#*10111000000111010001111111100011
   '#*10110000000011010000111111000011
   '#*10100000000001010000011110000011
   '#*10100000000001010000001100000011
   '#*10111111111111010000000000000011
   '#*10111111111111010000000000000011
   '#*10111111111111010000000000000011
   '#*10000000000000010000000000000011
   '#*01111111111111111111111111111111
   '#*00111111111111111111111111111110)

(defimage large-numeric-scroll-down-highlighted-button
   '#*01111111111111111111111111111100
   '#*10000000000000010000000000000010
   '#*10000000000000010111111111111011
   '#*10000000000000010111111111111011
   '#*10000000000000010111111111111011
   '#*10000001100000010100000000001011
   '#*10000011110000010100000000001011
   '#*10000111111000010110000000011011
   '#*10001111111100010111000000111011
   '#*10011111111110010111100001111011
   '#*10011111111110010111110011111011
   '#*10000000000000010111111111111011
   '#*10000000000000010111111111111011
   '#*10000000000000010111111111111011
   '#*10000000000000010000000000000011
   '#*01111111111111111111111111111111
   '#*00111111111111111111111111111110)

(defimage extra-large-numeric-scroll-button
   '#*011111111111111111111111111111111111111111111100
   '#*100000000000000000000001000000000000000000000010
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000001100000000001000011111111111111000011
   '#*100000000011110000000001000011111111111111000011
   '#*100000000111111000000001000001111111111110000011
   '#*100000001111111100000001000000111111111100000011
   '#*100000011111111110000001000000011111111000000011
   '#*100000111111111111000001000000001111110000000011
   '#*100001111111111111100001000000000111100000000011
   '#*100001111111111111100001000000000011000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*011111111111111111111111111111111111111111111111
   '#*001111111111111111111111111111111111111111111110)

(defimage extra-large-numeric-scroll-up-highlighted-button
   '#*011111111111111111111111111111111111111111111100
   '#*100000000000000000000001000000000000000000000010
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111110011111111101000011111111111111000011
   '#*101111111100001111111101000011111111111111000011
   '#*101111111000000111111101000001111111111110000011
   '#*101111110000000011111101000000111111111100000011
   '#*101111100000000001111101000000011111111000000011
   '#*101111000000000000111101000000001111110000000011
   '#*101110000000000000011101000000000111100000000011
   '#*101110000000000000011101000000000011000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*101111111111111111111101000000000000000000000011
   '#*100000000000000000000001000000000000000000000011
   '#*011111111111111111111111111111111111111111111111
   '#*001111111111111111111111111111111111111111111110)

(defimage extra-large-numeric-scroll-down-highlighted-button
   '#*011111111111111111111111111111111111111111111100
   '#*100000000000000000000001000000000000000000000010
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000001100000000001011100000000000000111011
   '#*100000000011110000000001011100000000000000111011
   '#*100000000111111000000001011110000000000001111011
   '#*100000001111111100000001011111000000000011111011
   '#*100000011111111110000001011111100000000111111011
   '#*100000111111111111000001011111110000001111111011
   '#*100001111111111111100001011111111000011111111011
   '#*100001111111111111100001011111111100111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001011111111111111111111011
   '#*100000000000000000000001000000000000000000000011
   '#*011111111111111111111111111111111111111111111111
   '#*001111111111111111111111111111111111111111111110)



;;;----------------------------------------------------------------------------+
;;;                                                                            |
;;;                         Slider Geometry                                    |
;;;                                                                            |
;;;----------------------------------------------------------------------------+


(defconstant
  *slider-dimensions*
  (list
    :small       (make-slidebar	;;10pt
		   :drag-box-width 	10
		   :gap			1
		   :bar-thickness	4
		   :bar-drag-offset	5
		   :tick-mark-length	5
		   :tick-mark-offset	5
		   :bar-text-offset	'(:horizontal (0 18) :vertical (10 9))
		   )
    :medium      (make-slidebar	;;12pt
		   :drag-box-width 	10
		   :gap			1
		   :bar-thickness	5
		   :bar-drag-offset	5
		   :tick-mark-length	6
		   :tick-mark-offset	5
		   :bar-text-offset	'(:horizontal (0 21) :vertical (12 11))
		   )
    :large       (make-slidebar	;;14pt
		   :drag-box-width 	12
		   :gap			1
		   :bar-thickness	6
		   :bar-drag-offset	5
		   :tick-mark-length	7
		   :tick-mark-offset	6
		   :bar-text-offset	'(:horizontal (0 24) :vertical (14 11))
		   )
    :extra-large (make-slidebar	;;19pt
		   :drag-box-width 	15
		   :gap			2
		   :bar-thickness	8
		   :bar-drag-offset	6
		   :tick-mark-length	9
		   :tick-mark-offset	7
		   :bar-text-offset	'(:horizontal (0 31) :vertical (18 11))
		   ))
  "OPEN LOOK dimensions for slider bitmaps (in pixels).")

;; Slider masks :
;; first 1/2 of width is min end & second half is max end
;; width = 2 times (floor (slider-drag-box-width slider) 2) ;; offset to center of tick mark
;; width = height to make symmetrical for use in either orientation

(defimage small-bar-mask 	;;  HxW= 4x4 
  '#*0110
  '#*1111
  '#*1111
  '#*0110
  )

(defimage medium-bar-mask 	;;  HxW= 5x5 
  '#*01110
  '#*11111
  '#*11111
  '#*11111
  '#*01110
  )


(defimage large-bar-mask 	;;  HxW= 6x6 
  '#*011110
  '#*111111
  '#*111111
  '#*111111
  '#*111111
  '#*011110
  )

(defimage extra-large-bar-mask ;;  HxW= 6x6 
  '#*00111100
  '#*01111110
  '#*11111111
  '#*11111111
  '#*11111111
  '#*11111111
  '#*01111110
  '#*00111100
  )

(defimage small-bar-border 	;;  HxW= 4x4 
  '#*0110
  '#*1001
  '#*1001
  '#*0110
  )

(defimage medium-bar-border 	;;  HxW= 5x5 
  '#*01110
  '#*10001
  '#*10001
  '#*10001
  '#*01110
  )


(defimage large-bar-border 	;;  HxW= 6x6 
  '#*011110
  '#*100001
  '#*100001
  '#*100001
  '#*100001
  '#*011110
  )

(defimage extra-large-bar-border ;;  HxW= 8x8 
  '#*00111100
  '#*01000010
  '#*10000001
  '#*10000001
  '#*10000001
  '#*10000001
  '#*01000010
  '#*00111100
  )

(defparameter
  *slider-bar-images*
  (list
    :masks   (list
		  :small       small-bar-mask
		  :medium      medium-bar-mask
		  :large       large-bar-mask
		  :extra-large extra-large-bar-mask
		  )
    :borders (list
		  :small       small-bar-border
		  :medium      medium-bar-border
		  :large       large-bar-border
		  :extra-large extra-large-bar-border
		  )))



(defimage small-horizontal-drag-box ;; HxW=15x12
  '#*000000000000
  '#*001111111100
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*011111111110
  '#*001111111100
  '#*000000000000
  )

(defimage small-vertical-drag-box ;; HxW=12x15
  '#*000000000000000
  '#*001111111111100
  '#*010000000000110
  '#*010000000000110
  '#*010000000000110
  '#*010000000000110
  '#*010000000000110
  '#*010000000000110
  '#*010000000000110
  '#*011111111111110
  '#*001111111111100
  '#*000000000000000
  )


(defimage medium-horizontal-drag-box ;; HxW=16x12
  '#*000000000000
  '#*001111111100
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*010000000110
  '#*011111111110
  '#*001111111100
  '#*000000000000
  )


(defimage medium-vertical-drag-box ;; HxW=12x16
  '#*0000000000000000
  '#*0011111111111100
  '#*0100000000000110
  '#*0100000000000110
  '#*0100000000000110
  '#*0100000000000110
  '#*0100000000000110
  '#*0100000000000110
  '#*0100000000000110
  '#*0111111111111110
  '#*0011111111111100
  '#*0000000000000000
  )


(defimage large-horizontal-drag-box ;; HxW=19x14
  '#*00000000000000
  '#*00111111111100
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01000000000110
  '#*01111111111110
  '#*00111111111100
  '#*00000000000000
  )

(defimage large-vertical-drag-box ;; HxW=14x19
  '#*0000000000000000000
  '#*0011111111111111100
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0100000000000000110
  '#*0111111111111111110
  '#*0011111111111111100
  '#*0000000000000000000
  )


(defimage extra-large-horizontal-drag-box ;; HxW=25x19
  '#*0000000000000000000
  '#*0000000000000000000
  '#*0001111111111111000
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0010000000000001100
  '#*0011111111111111000
  '#*0001111111111111000
  '#*0000000000000000000
  '#*0000000000000000000
  )

;; Note: the shadow-width here is 1 less than you may expect, but matches engineering bitmaps
(defimage extra-large-vertical-drag-box ;; HxW=19x25
  '#*0000000000000000000000000
  '#*0000000000000000000000000
  '#*0001111111111111111111000
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0010000000000000000001100
  '#*0011111111111111111111000
  '#*0001111111111111111111000
  '#*0000000000000000000000000
  '#*0000000000000000000000000
  )

(defvar
  *slider-drag-box-images*
  (list
    :vertical   (list 
		  :small       small-vertical-drag-box
		  :medium      medium-vertical-drag-box
		  :large       large-vertical-drag-box
		  :extra-large extra-large-vertical-drag-box
		  )
    :horizontal (list 
		  :small       small-horizontal-drag-box
		  :medium      medium-horizontal-drag-box
		  :large       large-horizontal-drag-box
		  :extra-large extra-large-horizontal-drag-box
		  )))



;================================================================;
;								 ;
;	   OPEN LOOK MENU & PUSHPIN GEOMETRY	  		 ;
;								 ;
;================================================================;


(DEFCONSTANT *OL-menu-spec-alist*
  (let
    ((small/medium-pushpin-in
       (bitmap-image ()
		     '#*00000001110000000000000000
		     '#*00001110001100000000000000
		     '#*00110100000100000000000000
		     '#*01001000000010000000000000
		     '#*01001000000010000000000000
		     '#*10001000000010000000000000
		     '#*10001100000100000000000000
		     '#*10000110001100000000000000
		     '#*11000111111100000000000000
		     '#*01000001111000000000000000
		     '#*01110000111000000000000000
		     '#*11111111110000000000000000
		     '#*11001111000000000000000000))
     
     (small/medium-pushpin-out
       (bitmap-image ()
		     '#*00000000000000000000000000
		     '#*00000000000001110000000000
		     '#*00000000000001001000000110
		     '#*00000000000001001000001001
		     '#*00000000000001001111111001
		     '#*00000000000001001000001001
		     '#*00000111111111001000001001
		     '#*00000011111111001000001001 
		     '#*00000000000001001111111001
		     '#*01100000000001001111111111
		     '#*10010000000001111000001111
		     '#*10010000000001111000000110
		     '#*01100000000001110000000000))
     
     (large/extra-large-pushpin-in
       (bitmap-image ()
		     '#*00000000111000000000000000000
		     '#*00000111000110000000000000000
		     '#*00011100000001000000000000000
		     '#*00100100000001000000000000000
		     '#*01001000000000100000000000000
		     '#*01001000000000100000000000000
		     '#*10001000000000100000000000000
		     '#*10001100000001100000000000000
		     '#*10000100000001000000000000000
		     '#*11000111000111000000000000000
		     '#*01000011111110000000000000000
		     '#*01100000111110000000000000000
		     '#*01111000011100000000000000000
		     '#*11111111111000000000000000000
		     '#*11000111100000000000000000000))
     
     (large/extra-large-pushpin-out
       (bitmap-image ()
		     '#*00000000000000000000000000000
		     '#*00000000000000011100000000110
		     '#*00000000000000010010000001001
		     '#*00000000000000010010000001001
		     '#*00000000000000010011111111001
		     '#*00000000000000010010000001001
		     '#*00000000000000010010000001001
		     '#*00000111111111110010000001001
		     '#*00000011111111110010000001001
		     '#*00000000000000010010000001001
		     '#*00000000000000010011111111001
		     '#*01100000000000010011111111111
		     '#*10010000000000011110000001111
		     '#*10010000000000011110000000110
		     '#*01100000000000011100000000000)))
    
    (let
      ((small-OL-menu-spec
	  (make-OL-menu-spec
	    :scale :small
	    :pushpin  (make-pushpin-spec
			:scale :small
			:box-width 26
			:box-height 13
			:baseline 9		;Relative top of box
			:image-in small/medium-pushpin-in
			:image-out small/medium-pushpin-out
			:default-ring-image ()	;These are 
			:ring-x -1		; all 
			:ring-y -1		;  dummies for now
			:left-margin 0
			:top-margin 0	
			:bottom-margin 0)
	    
	    :pushpin-dx    7			;horizontal distance from border to left of image
	    :pushpin-dy   13			;vertical distance from border to pushpin baseline
	    :title-bar-dx  2			;horizontal distance from border to title bar (left & right)
	    :title-bar-dy  7			;vertical distance from title baseline to title bar
	    :title-dx	   8			;horizontal (minimum) left & right title margins
	    :title-dy     13			;vertical distance from menu border to title baseline
	    :drop-shadow-width  5
	    :drop-shadow-offset 6 ))
    
       (medium-OL-menu-spec
	  (make-OL-menu-spec
	    :scale :medium
	    :pushpin  (make-pushpin-spec
			:scale :medium
			:box-width 26
			:box-height 13
			:baseline 10		;Relative top of box
			:image-in small/medium-pushpin-in
			:image-out small/medium-pushpin-out
			:default-ring-image ()	;These are 
			:ring-x -1		; all 
			:ring-y -1		;  dummies for now
			:left-margin 0
			:top-margin 0
			:bottom-margin 0)
	    
	    :pushpin-dx    8			;horizontal distance from border to left of image
	    :pushpin-dy   15			;vertical distance from border to pushpin baseline
	    :title-bar-dx  2			;horizontal distance from border to title bar (left & right)
	    :title-bar-dy  7			;vertical distance from title baseline to title bar
	    :title-dx	   9			;horizontal (minimum) left & right title margins
	    :title-dy     15			;vertical distance from menu border to title baseline
	    :drop-shadow-width  6
	    :drop-shadow-offset 7 ))
    
       (large-OL-menu-spec
	  (make-OL-menu-spec
	    :scale :large
	    :pushpin  (make-pushpin-spec
			:scale :large
			:box-width 29
			:box-height 15
			:baseline 11		;Relative top of box
			:image-in large/extra-large-pushpin-in
			:image-out large/extra-large-pushpin-out
			:default-ring-image ()	;These are 
			:ring-x -1		; all 
			:ring-y -1		;  dummies for now
			:left-margin 0
			:top-margin 0		;pushpin baseline relative to image
			:bottom-margin 0)
	    
	    :pushpin-dx    9			;horizontal distance from border to left of image
	    :pushpin-dy   18			;vertical distance from border to pushpin baseline
	    :title-bar-dx  3			;horizontal distance from border to title bar (left & right)
	    :title-bar-dy 10			;vertical distance from title baseline to title bar
	    :title-dx	  10			;horizontal (minimum) left & right title margins
	    :title-dy     18			;vertical distance from menu border to title baseline
	    :drop-shadow-width  7
	    :drop-shadow-offset 8 ))
    
       (extra-large-OL-menu-spec
	  (make-OL-menu-spec
	    :scale :extra-large
	    :pushpin  (make-pushpin-spec
			:scale :extra-large
			:box-width 29
			:box-height 15
			:baseline 11		;Relative top of box
			:image-in large/extra-large-pushpin-in
			:image-out large/extra-large-pushpin-out
			:default-ring-image ()	;These are 
			:ring-x -1		; all 
			:ring-y -1		;  dummies for now
			:left-margin 0
			:top-margin  0		;pushpin baseline relative to image
			:bottom-margin  0)
	    
	    :pushpin-dx   13			;horizontal distance from border to left of image
	    :pushpin-dy   21			;vertical distance from border to pushpin baseline
	    :title-bar-dx  3			;horizontal distance from border to title bar (left & right)
	    :title-bar-dy 11			;vertical distance from title baseline to title bar
	    :title-dx	14			;horizontal (minimum) left & right title margins
	    :title-dy     21			;vertical distance from menu border to title baseline
	    :drop-shadow-width  9
	    :drop-shadow-offset 10)))
    
  `((:small . ,small-OL-menu-spec)
    (:medium . ,medium-OL-menu-spec)
    (:large . ,large-OL-menu-spec)
    (:extra-large . ,extra-large-OL-menu-spec)) )))

;;; ==========================================================================================	;;;
;;; ==========================================================================================	;;;
;;;												;;;
;;;		     Action Button Ends, Default Rings, and Menu Marks				;;;
;;;												;;;
;;; ==========================================================================================	;;;
;;; ==========================================================================================	;;;

(defimage small-horizontal-menu-mark
  '#*00000000
  '#*01100000
  '#*01011000
  '#*01000110
  '#*01000001
  '#*01000110
  '#*01011000
  '#*01100000)

(defimage small-vertical-menu-mark
  '#*00000000
  '#*11111110
  '#*10000010
  '#*01000100
  '#*01000100
  '#*00101000
  '#*00101000
  '#*00010000)

(defimage medium-horizontal-menu-mark
  '#*00000000
  '#*01100000
  '#*01011000
  '#*01000110
  '#*01000001
  '#*01000110
  '#*01011000
  '#*01100000)

(defimage medium-vertical-menu-mark
  '#*00000000
  '#*11111110
  '#*10000010
  '#*01000100
  '#*01000100
  '#*00101000
  '#*00101000
  '#*00010000)

(defimage large-horizontal-menu-mark
  '#*000000000000
  '#*011000000000
  '#*010110000000
  '#*010001100000
  '#*010000011000
  '#*010000000110
  '#*010000000001
  '#*010000000110
  '#*010000011000
  '#*010001100000
  '#*010110000000
  '#*011000000000)

(defimage large-vertical-menu-mark
  '#*000000000000
  '#*111111111110
  '#*100000000010
  '#*010000000100
  '#*010000000100
  '#*001000001000
  '#*001000001000
  '#*000100010000
  '#*000100010000
  '#*000010100000
  '#*000010100000
  '#*000001000000)

(defimage extra-large-horizontal-menu-mark
  '#*00000000000000
  '#*01100000000000
  '#*01011000000000
  '#*01000110000000
  '#*01000001100000
  '#*01000000011000
  '#*01000000000110
  '#*01000000000001
  '#*01000000000110
  '#*01000000011000
  '#*01000001100000
  '#*01000110000000
  '#*01011000000000
  '#*01100000000000)

(defimage extra-large-vertical-menu-mark
  '#*00000000000000
  '#*11111111111110
  '#*10000000000010
  '#*01000000000100
  '#*01000000000100
  '#*00100000001000
  '#*00100000001000
  '#*00010000010000
  '#*00010000010000
  '#*00001000100000
  '#*00001000100000
  '#*00000101000000
  '#*00000101000000
  '#*00000010000000)


;;;
;;;	The following abbreviated menu button definitions define only the border.
;;;	The left/down facing menu marks or ellipses are considered to be the label of
;;;	the button.  The abbreviated-menu-button-specs describe how to draw each size.
;;;

(defimage small-abbreviated-menu-button-border
  '#*01111111111100
  '#*10000000000010
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*10000000000011
  '#*01111111111111
  '#*00111111111110)

(defimage medium-abbreviated-menu-button-border
  '#*0111111111111100
  '#*1000000000000010
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*1000000000000011
  '#*0111111111111111
  '#*0011111111111110)

(defimage large-abbreviated-menu-button-border
  '#*011111111111111100
  '#*100000000000000010
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*100000000000000011
  '#*011111111111111111
  '#*001111111111111110)

(defimage extra-large-abbreviated-menu-button-border
  '#*0011111111111111111000
  '#*0100000000000000000100
  '#*1000000000000000000010
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*1000000000000000000011
  '#*0100000000000000000111
  '#*0011111111111111111110
  '#*0001111111111111111100)


	  
(defimage small-action-button-ends
  '#*00000011110000000
  '#*00001100001100000
  '#*00010000000010000
  '#*00100000000001000
  '#*01000000000000100
  '#*01000000000000110
  '#*10000000000000010
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*10000000000000011
  '#*01000000000000111
  '#*01000000000000110
  '#*00100000000001110
  '#*00010000000011100
  '#*00001100001111000
  '#*00000111111110000
  '#*00000001111000000)

(defimage medium-action-button-ends
  '#*0000001111110000000
  '#*0000110000001100000
  '#*0001000000000010000
  '#*0010000000000001000
  '#*0100000000000000100
  '#*0100000000000000110
  '#*1000000000000000010
  '#*1000000000000000011
  '#*1000000000000000011
  '#*1000000000000000011
  '#*1000000000000000011
  '#*1000000000000000011
  '#*1000000000000000011
  '#*0100000000000000111
  '#*0100000000000000110
  '#*0010000000000001110
  '#*0001000000000011100
  '#*0000110000001111000
  '#*0000011111111110000
  '#*0000001111111000000)

(defimage large-action-button-ends
  '#*00000001111111100000000
  '#*00000110000000011000000
  '#*00001000000000000100000
  '#*00010000000000000010000
  '#*00100000000000000001000
  '#*01000000000000000000100
  '#*01000000000000000000110
  '#*10000000000000000000010
  '#*10000000000000000000011
  '#*10000000000000000000011
  '#*10000000000000000000011
  '#*10000000000000000000011
  '#*10000000000000000000011
  '#*10000000000000000000011
  '#*01000000000000000000111
  '#*01000000000000000000110
  '#*00100000000000000001110
  '#*00010000000000000011100
  '#*00001000000000000111000
  '#*00000110000000011110000
  '#*00000011111111111100000
  '#*00000000111111110000000)

(defimage extra-large-action-button-ends
  '#*000000000011111100000000000
  '#*000000011100000011100000000
  '#*000000110000000000110000000
  '#*000011000000000000001100000
  '#*000110000000000000000110000
  '#*000100000000000000000011000
  '#*001000000000000000000001000
  '#*011000000000000000000001100
  '#*010000000000000000000000110
  '#*010000000000000000000000110
  '#*100000000000000000000000010
  '#*100000000000000000000000011
  '#*100000000000000000000000011
  '#*100000000000000000000000011
  '#*100000000000000000000000011
  '#*100000000000000000000000011
  '#*100000000000000000000000011
  '#*010000000000000000000000111
  '#*010000000000000000000000110
  '#*011000000000000000000001110
  '#*001000000000000000000001110
  '#*000100000000000000000011100
  '#*000110000000000000000111000
  '#*000011000000000000001111000
  '#*000001110000000000111110000
  '#*000000011100000001111100000
  '#*000000001111111111111000000
  '#*000000000011111111000000000)



;;;
;;;	Note that the following default-ring images for use in the ends of an
;;;	action-button/action-item are sized to be positioned *within* the border of an
;;;	action-button.  That is, they are 3 pixels shorter in height than the above button-end
;;;	images.  This is because they must be displayed within a (borderless) action-item as well
;;;	as an action-button.  Their :y coordinate is always (ab-top-border-width ab), which is 1
;;;	for an action-button, 0 for an action-item.

(defimage small-action-button-default-ring
  '#*00000000000000000
  '#*00000001100000000
  '#*00000110011000000
  '#*00001000000100000
  '#*00010000000010000
  '#*00010000000010000
  '#*00100000000001000
  '#*00100000000001000
  '#*00100000000001000
  '#*00010000000010000
  '#*00010000000010000
  '#*00001000000100000
  '#*00000110011000000
  '#*00000001100000000
  '#*00000000000000000)

(defimage medium-action-button-default-ring
  '#*0000000000000000000
  '#*0000000111100000000
  '#*0000011000011000000
  '#*0000100000000100000
  '#*0001000000000010000
  '#*0001000000000010000
  '#*0010000000000001000
  '#*0010000000000001000
  '#*0010000000000001000
  '#*0010000000000001000
  '#*0010000000000001000
  '#*0001000000000010000
  '#*0001000000000010000
  '#*0000100000000100000
  '#*0000011000011000000
  '#*0000000111100000000
  '#*0000000000000000000)

(defimage large-action-button-default-ring
  '#*00000000000000000000000
  '#*00000000111111000000000
  '#*00000011000000110000000
  '#*00000100000000001000000
  '#*00001000000000000100000
  '#*00010000000000000010000
  '#*00010000000000000010000
  '#*00100000000000000001000
  '#*00100000000000000001000
  '#*00100000000000000001000
  '#*00100000000000000001000
  '#*00100000000000000001000
  '#*00010000000000000010000
  '#*00010000000000000010000
  '#*00001000000000000100000
  '#*00000100000000001000000
  '#*00000110000000011000000
  '#*00000001111110000000000
  '#*00000000000000000000000)

(defimage extra-large-action-button-default-ring
  '#*000000000000000000000000000
  '#*000000000001111000000000000
  '#*000000000110000110000000000
  '#*000000011000000001100000000
  '#*000000100000000000010000000
  '#*000001000000000000001000000
  '#*000010000000000000000100000
  '#*000010000000000000000100000
  '#*000100000000000000000010000
  '#*000100000000000000000010000
  '#*001000000000000000000001000
  '#*001000000000000000000001000
  '#*001000000000000000000001000
  '#*001000000000000000000001000
  '#*001000000000000000000001000
  '#*000100000000000000000010000
  '#*000100000000000000000010000
  '#*000010000000000000000100000
  '#*000010000000000000000100000
  '#*000001000000000000001000000
  '#*000000100000000000010000000
  '#*000000011000000001100000000
  '#*000000000110000110000000000
  '#*000000000001111000000000000
  '#*000000000000000000000000000)


(defimage small-action-item-default-ring
  '#*0000011111100000
  '#*0001100000011000
  '#*0010000000000100
  '#*0100000000000010
  '#*0100000000000010
  '#*1000000000000001
  '#*1000000000000001
  '#*1000000000000001
  '#*1000000000000001
  '#*1000000000000001
  '#*1000000000000001
  '#*0100000000000010
  '#*0100000000000010
  '#*0010000000000100
  '#*0001100000011000
  '#*0000011111100000)

(defimage medium-action-item-default-ring
  '#*000000111111000000
  '#*000011000000110000
  '#*000100000000001000
  '#*001000000000000100
  '#*010000000000000010
  '#*010000000000000010
  '#*100000000000000001
  '#*100000000000000001
  '#*100000000000000001
  '#*100000000000000001
  '#*100000000000000001
  '#*100000000000000001
  '#*010000000000000010
  '#*010000000000000010
  '#*001000000000000100
  '#*000100000000001000
  '#*000011000000110000
  '#*000000111111000000)


(defimage large-action-item-default-ring
  '#*00000001111110000000
  '#*00000110000001100000
  '#*00001000000000010000
  '#*00010000000000001000
  '#*00100000000000000100
  '#*01000000000000000010
  '#*01000000000000000010
  '#*10000000000000000001
  '#*10000000000000000001
  '#*10000000000000000001
  '#*10000000000000000001
  '#*10000000000000000001
  '#*10000000000000000001
  '#*01000000000000000010
  '#*01000000000000000010
  '#*00100000000000000100
  '#*00010000000000001000
  '#*00001000000000010000
  '#*00000110000001100000
  '#*00000001111110000000)

(defimage extra-large-action-item-default-ring
  '#*0000000011111111111100000000
  '#*0000001100000000000011000000
  '#*0000110000000000000000110000
  '#*0001000000000000000000001000
  '#*0010000000000000000000000100
  '#*0010000000000000000000000100
  '#*0100000000000000000000000010
  '#*0100000000000000000000000010
  '#*1000000000000000000000000001
  '#*1000000000000000000000000001
  '#*1000000000000000000000000001
  '#*1000000000000000000000000001
  '#*1000000000000000000000000001
  '#*1000000000000000000000000001
  '#*1000000000000000000000000001
  '#*0100000000000000000000000010
  '#*0100000000000000000000000010
  '#*0010000000000000000000000100
  '#*0010000000000000000000000100
  '#*0001000000000000000000001000
  '#*0000110000000000000000110000
  '#*0000001100000000000011000000
  '#*0000000011111111111100000000)

;;; ==========================================================================================	;;;
;;; ==========================================================================================	;;;
;;;												;;;
;;;		     			More-Text Arrows					;;;
;;;												;;;
;;; ==========================================================================================	;;;
;;; ==========================================================================================	;;;

;;;  Note:  These arrows are "tightly" sized.  They are not the height of their scales' text.
;;;  The More-Text-Arrow structure entry :offset-from-baseline is the amount to add to the text
;;;  baseline to get the position of the top of the arrow.  

(defimage small-more-text-arrow
  '#*10000
  '#*01000
  '#*10100
  '#*01010
  '#*10101
  '#*01010
  '#*10100
  '#*01000
  '#*10000)

(defimage medium-more-text-arrow
  '#*10000
  '#*01000
  '#*10100
  '#*01010
  '#*10101
  '#*01010
  '#*10100
  '#*01000
  '#*10000)

(defimage large-more-text-arrow
  '#*100000
  '#*010000
  '#*101000
  '#*010100
  '#*101010
  '#*010101
  '#*101010
  '#*010100
  '#*101000
  '#*010000
  '#*100000)

(defimage extra-large-more-text-arrow
  '#*10000000
  '#*01000000
  '#*10100000
  '#*01010000
  '#*10101000
  '#*01010100
  '#*10101010
  '#*01010101
  '#*10101010
  '#*01010100
  '#*10101000
  '#*01010000
  '#*10100000
  '#*01000000
  '#*10000000)





(defparameter *more-text-arrows-by-scale*
  (list
    :small       (make-more-text-arrow
		   :image 		 small-more-text-arrow
		   :name  		 'small-more-text-arrow
		   :offset-from-baseline -8
		   :offset-from-text     4)
    :medium      (make-more-text-arrow
		   :image 		 medium-more-text-arrow
		   :name  		 'medium-more-text-arrow
		   :offset-from-baseline -9
		   :offset-from-text     4)
    :large       (make-more-text-arrow
		   :image 		 large-more-text-arrow
		   :name  		 'large-more-text-arrow
		   :offset-from-baseline -11
		   :offset-from-text     5)
    :extra-large (make-more-text-arrow
		   :image 		 extra-large-more-text-arrow
		   :name  		 'extra-large-more-text-arrow
		   :offset-from-baseline -13
		   :offset-from-text     7)))


;;; ==========================================================================================	;;;
;;; ==========================================================================================	;;;
;;;												;;;
;;;		     		   The Standard Open Look Cursor				;;;
;;;												;;;
;;; ==========================================================================================	;;;
;;; ==========================================================================================	;;;

(defimage open-look-arrow-cursor
   '#*000000000000000000
   '#*011000000000000000
   '#*011110000000000000
   '#*001111100000000000
   '#*001111111000000000
   '#*000111111110000000
   '#*000111111111100000
   '#*000011111111100000
   '#*000011111100000000
   '#*000001111110000000
   '#*000001110111000000
   '#*000000110011100000
   '#*000000110001110000
   '#*000000000000111000
   '#*000000000000011100
   '#*000000000000001110
   '#*000000000000000110
   '#*000000000000000000)

(defimage open-look-arrow-cursor-mask
   '#*111100000000000000
   '#*111111000000000000
   '#*111111110000000000
   '#*111111111100000000
   '#*011111111111000000
   '#*011111111111110000
   '#*001111111111110000
   '#*001111111111110000
   '#*000111111111110000
   '#*000111111111000000
   '#*000011111111100000
   '#*000011111111110000
   '#*000001111011111000
   '#*000001111001111100
   '#*000000000000111110
   '#*000000000000011111
   '#*000000000000001111
   '#*000000000000000111)

