/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style.impl;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.BooleanPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.actions.BooleanStyleAction;

public final class BooleanUsingEqualsStylePropertyImpl
extends SubStylePropertyImpl {
    private final String m_sFlag;
    private final long m_flag;
    private final String m_className;

    public BooleanUsingEqualsStylePropertyImpl(StylePropertyEditor editor, String title, String sFlag, long flag, String className) {
        super(editor, title);
        this.m_sFlag = sFlag;
        this.m_flag = flag;
        this.m_className = className;
    }

    @Override
    public void getAsString(StringBuilder builder) {
        builder.append(this.getTitle());
        builder.append(" boolean: ");
        builder.append(this.m_sFlag);
    }

    @Override
    public PropertyEditor createEditor() {
        return BooleanPropertyEditor.INSTANCE;
    }

    @Override
    public long getFlag(String sFlag) {
        return this.m_flag;
    }

    @Override
    public String getFlagValue(Property property) throws Exception {
        String expressionString;
        if (property instanceof GenericProperty && (expressionString = this.getCurrentSource((GenericProperty)property)).indexOf(String.valueOf('.') + this.m_sFlag) != -1) {
            return this.m_sFlag;
        }
        return null;
    }

    private boolean isSet(Property property) throws Exception {
        return this.getFlagValue(property) != null;
    }

    @Override
    public Object getValue(Property property) throws Exception {
        return this.isSet(property) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setValue(Property property, Object value) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        String source = this.getSource(genericProperty, value != Property.UNKNOWN_VALUE && (Boolean)value != false);
        genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
    }

    @Override
    public void contributeActions(Property property, IMenuManager manager) throws Exception {
        BooleanStyleAction action = new BooleanStyleAction(property, this);
        action.setChecked(this.isSet(property));
        manager.add((IAction)action);
    }

    private String getCurrentSource(GenericProperty genericProperty) throws Exception {
        return genericProperty.getExpression().toString();
    }

    private String getSource(GenericProperty genericProperty, boolean boolValue) throws Exception {
        return this.getSource(genericProperty, boolValue, true, " | ");
    }

    private String getSource(GenericProperty genericProperty, boolean boolValue, boolean addClassAndDefault, String separator) throws Exception {
        boolean isFlagInSource;
        String currentSource = this.getCurrentSource(genericProperty);
        boolean bl = isFlagInSource = (currentSource = currentSource.trim()).indexOf(String.valueOf('.') + this.m_sFlag) != -1;
        if (boolValue && !isFlagInSource) {
            if (addClassAndDefault) {
                return String.valueOf(currentSource) + separator + this.m_className + '.' + this.m_sFlag;
            }
            return String.valueOf(currentSource) + separator + this.m_sFlag;
        }
        if (boolValue && isFlagInSource) {
            return currentSource;
        }
        if (!boolValue && !isFlagInSource) {
            return currentSource;
        }
        if (!boolValue && isFlagInSource) {
            int beginIndex = currentSource.indexOf(String.valueOf('.') + this.m_sFlag);
            int endIndex = currentSource.indexOf(String.valueOf('.') + this.m_sFlag) + this.m_sFlag.length() + 1;
            while (beginIndex > 0) {
                char ch = currentSource.charAt(beginIndex);
                if (!Character.isLetter(ch) && ch != '.') break;
                --beginIndex;
            }
            int firstSeparatorOccurrence = currentSource.indexOf(124);
            if (firstSeparatorOccurrence == -1) {
                return currentSource;
            }
            if (firstSeparatorOccurrence <= beginIndex) {
                beginIndex = firstSeparatorOccurrence;
            } else if (firstSeparatorOccurrence >= endIndex) {
                endIndex = firstSeparatorOccurrence + 1;
            }
            return (String.valueOf(currentSource.substring(0, beginIndex)) + currentSource.substring(endIndex)).trim();
        }
        throw new IllegalStateException();
    }
}

