/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.wb.core.gef.part.menu.IMenuObjectEditPart;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.DragPermissionRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.AsyncExecutor;
import org.eclipse.wb.internal.core.gef.part.menu.MenuEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MenuPopupEditPart;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectListener;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.gef.core.EditPartVisitor;
import org.eclipse.wb.internal.gef.core.IActiveToolListener;

public abstract class MenuObjectEditPart
extends GraphicalEditPart
implements IMenuObjectEditPart {
    private final IMenuObjectInfo m_object;
    private ISelectionChangedListener m_selectionListener;
    private IActiveToolListener m_activeToolListener;
    private IMenuObjectListener m_objectListener;

    public MenuObjectEditPart(Object toolkitModel, IMenuObjectInfo menuModel) {
        this.setModel(toolkitModel);
        this.m_object = menuModel;
    }

    @Override
    public IMenuObjectInfo getMenuModel() {
        return this.m_object;
    }

    @Override
    public void activate() {
        super.activate();
        this.addListeners();
    }

    @Override
    public void deactivate() {
        this.removeListeners();
        super.deactivate();
    }

    @Override
    public void removeNotify() {
        for (EditPart child : this.getChildren()) {
            this.removeChildVisual(child);
        }
        super.removeNotify();
    }

    private void addListeners() {
        if (this.isRootMenuEditPart()) {
            this.createListeners();
            this.getViewer().addSelectionChangedListener(this.m_selectionListener);
            this.getViewer().getEditDomain().addActiveToolListener(this.m_activeToolListener);
            this.m_object.addListener(this.m_objectListener);
        }
    }

    private void removeListeners() {
        if (this.isRootMenuEditPart()) {
            this.getViewer().removeSelectionChangedListener(this.m_selectionListener);
            this.getViewer().getEditDomain().removeActiveToolListener(this.m_activeToolListener);
            this.m_object.removeListener(this.m_objectListener);
        }
    }

    private boolean isRootMenuEditPart() {
        return !(this.getParent() instanceof MenuObjectEditPart);
    }

    private void createListeners() {
        if (this.m_selectionListener != null) {
            return;
        }
        this.m_selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MenuObjectEditPart.this.refresh();
            }
        };
        this.m_activeToolListener = new IActiveToolListener(){

            @Override
            public void toolActivated(Tool tool) {
                MenuObjectEditPart.this.refresh();
            }
        };
        this.m_objectListener = new IMenuObjectListener(){
            private EditPart m_pendingSelection;

            @Override
            public void refresh() {
                if (this.m_pendingSelection != null) {
                    MenuObjectEditPart.this.getViewer().select(this.m_pendingSelection);
                    this.m_pendingSelection = null;
                } else {
                    MenuObjectEditPart.this.refresh();
                }
            }

            @Override
            public void deleting(Object toolkitModel) {
                EditPart objectPart = MenuObjectEditPart.this.getViewer().getEditPartByModel(toolkitModel);
                if (objectPart != null) {
                    EditPart parentPart = objectPart.getParent();
                    List<EditPart> siblings = parentPart.getChildren();
                    int index = siblings.indexOf(objectPart);
                    if (siblings.size() == 1) {
                        this.m_pendingSelection = parentPart;
                        if (this.m_pendingSelection instanceof MenuEditPart || this.m_pendingSelection instanceof MenuPopupEditPart) {
                            this.m_pendingSelection = this.m_pendingSelection.getParent();
                        }
                    } else {
                        this.m_pendingSelection = index == 0 ? siblings.get(index + 1) : siblings.get(index - 1);
                    }
                }
            }
        };
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        boolean isOperationRequest;
        request = this.processRequestProcessors(request);
        EditPart target = super.getTargetEditPart(request);
        boolean bl = isOperationRequest = request.getType() == "create child" || request.getType() == "paste" || request.getType() == "add children";
        if (target == this && isOperationRequest) {
            AsyncExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        MenuObjectInfoUtils.m_selectingObject = MenuObjectEditPart.this.m_object;
                        MenuObjectEditPart.this.getViewer().getRootEditPart().accept(new EditPartVisitor(){

                            @Override
                            public boolean visit(EditPart editPart) {
                                if (editPart instanceof MenuObjectEditPart) {
                                    editPart.refresh();
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                    finally {
                        MenuObjectInfoUtils.m_selectingObject = null;
                    }
                }
            });
        }
        return target;
    }

    @Override
    public void refresh() {
        this.removeListeners();
        try {
            super.refresh();
        }
        finally {
            this.addListeners();
        }
    }

    @Override
    public void performRequest(Request request) {
        super.performRequest(request);
        if (request instanceof DragPermissionRequest) {
            DragPermissionRequest permissionRequest = (DragPermissionRequest)request;
            permissionRequest.setMove(this.m_object.canMove());
            permissionRequest.setReparent(this.m_object.canReparent());
        }
    }
}

