/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.utils;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.AbstractMorphingSupport;
import org.eclipse.wb.internal.core.utils.ui.ImageImageDescriptor;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.xml.model.description.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.xml.model.utils.GlobalStateXml;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public abstract class MorphingSupport<T extends XmlObjectInfo>
extends AbstractMorphingSupport<T> {
    private final EditorContext m_editor;

    protected MorphingSupport(String toolkitClassName, T component) {
        super(toolkitClassName, component);
        this.m_editor = ((XmlObjectInfo)this.m_component).getContext();
    }

    protected IJavaProject getJavaProject() {
        return this.m_editor.getJavaProject();
    }

    protected ClassLoader getClassLoader() {
        return this.m_editor.getClassLoader();
    }

    protected Class<?> getComponentClass() {
        return ((XmlObjectInfo)this.m_component).getDescription().getComponentClass();
    }

    protected List<MorphingTargetDescription> getMorphingTargets() {
        return ((XmlObjectInfo)this.m_component).getDescription().getMorphingTargets();
    }

    protected String getTargetText(MorphingTargetDescription target) throws Exception {
        return this.getComponentPresentation(target).getName();
    }

    protected ImageDescriptor getTargetImageDescriptor(MorphingTargetDescription target) throws Exception {
        ComponentPresentation presentation = this.getComponentPresentation(target);
        return new ImageImageDescriptor(presentation.getIcon());
    }

    private ComponentPresentation getComponentPresentation(MorphingTargetDescription target) throws Exception {
        return ComponentPresentationHelper.getPresentation(this.m_editor, target.getComponentClass().getName(), target.getCreationId());
    }

    public static void contribute(String toolkitClassName, XmlObjectInfo component, IContributionManager manager) throws Exception {
        if (component.isRoot()) {
            return;
        }
        MorphingSupport<XmlObjectInfo> morphingSupport = new MorphingSupport<XmlObjectInfo>(toolkitClassName, component){};
        MorphingSupport.contribute((AbstractMorphingSupport)morphingSupport, (IContributionManager)manager);
    }

    protected void morph(MorphingTargetDescription target) throws Exception {
        if (((XmlObjectInfo)this.m_component).getCreationSupport() instanceof ElementCreationSupport) {
            super.morph(target);
        }
    }

    protected T morph_create(MorphingTargetDescription target) throws Exception {
        Class componentClass = target.getComponentClass();
        ComponentDescription newDescription = ComponentDescriptionHelper.getDescription(this.m_editor, componentClass);
        ElementCreationSupport creationSupport = new ElementCreationSupport(((XmlObjectInfo)this.m_component).getCreationSupport().getElement());
        XmlObjectInfo newComponent = XmlObjectUtils.createObject(this.m_editor, newDescription, (CreationSupport)creationSupport);
        GlobalStateXml.activate(newComponent);
        return (T)((Object)newComponent);
    }

    protected void morph_replace(T newComponent) throws Exception {
        ObjectInfo parent = ((XmlObjectInfo)this.m_component).getParent();
        if (parent != null) {
            parent.replaceChild(this.m_component, newComponent);
        }
    }

    protected void morph_properties(T newComponent) throws Exception {
        Property[] propertyArray = ((XmlObjectInfo)this.m_component).getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (newComponent.getPropertyByTitle(property.getTitle()) == null && property.isModified()) {
                property.setValue(Property.UNKNOWN_VALUE);
            }
            ++n2;
        }
    }

    protected void morph_children(T newComponent) throws Exception {
        for (XmlObjectInfo child : ((XmlObjectInfo)this.m_component).getChildrenXML()) {
            newComponent.addChild((ObjectInfo)child);
        }
    }

    protected void morph_source(T newComponent) throws Exception {
        CreationSupport creationSupport = ((XmlObjectInfo)((Object)newComponent)).getCreationSupport();
        Class<?> componentClass = ((XmlObjectInfo)((Object)newComponent)).getDescription().getComponentClass();
        String newComponentTag = XmlObjectUtils.getTagForClass(newComponent, componentClass);
        creationSupport.getElement().setTag(newComponentTag);
    }

    protected void morph_finish(T newComponent) throws Exception {
        if (((XmlObjectInfo)this.m_component).isRoot()) {
            ((XmlObjectInfo)this.m_component).getContext().commit();
            DesignPageSite.Helper.getSite((ObjectInfo)this.m_component).reparse();
        }
    }

    public static String validate(String toolkitClassName, XmlObjectInfo component, MorphingTargetDescription target) throws Exception {
        MorphingSupport<XmlObjectInfo> morphingSupport = new MorphingSupport<XmlObjectInfo>(toolkitClassName, component){};
        return morphingSupport.validate(target);
    }

    public static void morph(String toolkitClassName, XmlObjectInfo component, MorphingTargetDescription target) throws Exception {
        MorphingSupport<XmlObjectInfo> morphingSupport = new MorphingSupport<XmlObjectInfo>(toolkitClassName, component){};
        morphingSupport.morph(target);
    }
}

