"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUriMap = void 0;
function createUriMap(caseSensitive = false) {
    const map = new Map();
    const rawUriToNormalizedUri = new Map();
    const normalizedUriToRawUri = new Map();
    return {
        clear: _clear,
        values: _values,
        keys: _keys,
        delete: _delete,
        get: _get,
        has: _has,
        set: _set,
    };
    function _clear() {
        rawUriToNormalizedUri.clear();
        normalizedUriToRawUri.clear();
        return map.clear();
    }
    function _values() {
        return map.values();
    }
    function* _keys() {
        for (const normalizedUri of map.keys()) {
            yield normalizedUriToRawUri.get(normalizedUri);
        }
    }
    function _delete(uri) {
        return map.delete(getUriByUri(uri));
    }
    function _get(uri) {
        return map.get(getUriByUri(uri));
    }
    function _has(uri) {
        return map.has(getUriByUri(uri));
    }
    function _set(uri, item) {
        return map.set(getUriByUri(uri), item);
    }
    function getUriByUri(uri) {
        const rawUri = uri.toString();
        if (!rawUriToNormalizedUri.has(rawUri)) {
            let normalizedUri = uri.toString();
            if (!caseSensitive) {
                normalizedUri = normalizedUri.toLowerCase();
            }
            rawUriToNormalizedUri.set(rawUri, normalizedUri);
            normalizedUriToRawUri.set(normalizedUri, uri);
        }
        return rawUriToNormalizedUri.get(rawUri);
    }
}
exports.createUriMap = createUriMap;
//# sourceMappingURL=uriMap.js.map