"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var typescript_template_language_service_decorator_1 = require("typescript-template-language-service-decorator");
var _configuration_1 = require("./_configuration");
var _language_service_1 = require("./_language-service");
var _logger_1 = require("./_logger");
var _substituter_1 = require("./_substituter");
var _virtual_document_provider_1 = require("./_virtual-document-provider");
var StyledPlugin = /** @class */ (function () {
    function StyledPlugin(typescript) {
        this.typescript = typescript;
    }
    StyledPlugin.prototype.create = function (info) {
        var logger = new _logger_1.LanguageServiceLogger(info);
        var config = _configuration_1.loadConfiguration(info.config);
        logger.log('config: ' + JSON.stringify(config));
        return typescript_template_language_service_decorator_1.decorateWithTemplateLanguageService(this.typescript, info.languageService, info.project, new _language_service_1.StyledTemplateLanguageService(this.typescript, config, new _virtual_document_provider_1.StyledVirtualDocumentFactory(), logger), getTemplateSettings(config), { logger: logger });
    };
    return StyledPlugin;
}());
exports.StyledPlugin = StyledPlugin;
function getTemplateSettings(config) {
    return {
        tags: config.tags,
        enableForStringWithSubstitutions: true,
        getSubstitutions: function (templateString, spans) {
            return _substituter_1.getSubstitutions(templateString, spans);
        },
    };
}
exports.getTemplateSettings = getTemplateSettings;
