/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.JavaType;

public class JavaTypeTests
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.JavaTypeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.JavaTypeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaTypeTests(String name) {
        super(name);
    }

    public void testInvalidElementTypeNull() throws Exception {
        boolean exCaught = false;
        try {
            JavaType javaType = new JavaType(null, 0);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidElementTypeEmpty() throws Exception {
        boolean exCaught = false;
        try {
            JavaType javaType = new JavaType("", 0);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidElementTypeArray() throws Exception {
        boolean exCaught = false;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Ljava.lang.Object;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JavaType javaType = new JavaType(clazz.getName(), 0);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidArrayDepthNegative() throws Exception {
        boolean exCaught = false;
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JavaType javaType = new JavaType(clazz.getName(), -2);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidVoidArray() throws Exception {
        boolean exCaught = false;
        try {
            JavaType javaType = new JavaType(Void.TYPE.getName(), 2);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testElementTypeName() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaType javaType = new JavaType((Class)clazz);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getElementTypeName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz2);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getElementTypeName());
        javaType = new JavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.getElementTypeName());
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz3);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.getElementTypeName());
        javaType = new JavaType(Void.TYPE);
        JavaTypeTests.assertEquals((String)"void", (String)javaType.getElementTypeName());
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz4);
        JavaTypeTests.assertEquals((String)"java.util.Map$Entry", (String)javaType.getElementTypeName());
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz5);
        JavaTypeTests.assertEquals((String)"java.util.Map$Entry", (String)javaType.getElementTypeName());
    }

    public void testArrayDepth() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaType javaType = new JavaType((Class)clazz);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz2);
        JavaTypeTests.assertEquals((int)1, (int)javaType.getArrayDepth());
        javaType = new JavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz3);
        JavaTypeTests.assertEquals((int)1, (int)javaType.getArrayDepth());
        javaType = new JavaType(Void.TYPE);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz4);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz5);
        JavaTypeTests.assertEquals((int)2, (int)javaType.getArrayDepth());
    }

    public void testIsArray() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaType javaType = new JavaType((Class)clazz);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz2);
        JavaTypeTests.assertTrue((boolean)javaType.isArray());
        javaType = new JavaType(Integer.TYPE);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz3);
        JavaTypeTests.assertTrue((boolean)javaType.isArray());
        javaType = new JavaType(Void.TYPE);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz4);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz5);
        JavaTypeTests.assertTrue((boolean)javaType.isArray());
    }

    public void testJavaClass() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyJavaClass(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyJavaClass(clazz2);
        this.verifyJavaClass(Integer.TYPE);
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyJavaClass(clazz3);
        this.verifyJavaClass(Void.TYPE);
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyJavaClass(clazz4);
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyJavaClass(clazz5);
    }

    private void verifyJavaClass(Class javaClass) throws Exception {
        JavaType javaType = new JavaType(javaClass);
        JavaTypeTests.assertEquals((Object)javaClass, (Object)javaType.javaClass());
    }

    public void testJavaClassName() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaType javaType = new JavaType((Class)clazz);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.javaClassName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz2);
        JavaTypeTests.assertEquals((String)"[Ljava.lang.Object;", (String)javaType.javaClassName());
        javaType = new JavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.javaClassName());
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz3);
        JavaTypeTests.assertEquals((String)"[I", (String)javaType.javaClassName());
        javaType = new JavaType(Void.TYPE);
        JavaTypeTests.assertEquals((String)"void", (String)javaType.javaClassName());
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz4);
        JavaTypeTests.assertEquals((String)"java.util.Map$Entry", (String)javaType.javaClassName());
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz5);
        JavaTypeTests.assertEquals((String)"[[Ljava.util.Map$Entry;", (String)javaType.javaClassName());
    }

    public void testDescribes() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyDescribes(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyDescribes(clazz2);
        this.verifyDescribes(Integer.TYPE);
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyDescribes(clazz3);
        this.verifyDescribes(Void.TYPE);
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyDescribes(clazz4);
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.verifyDescribes(clazz5);
    }

    private void verifyDescribes(Class javaClass) throws Exception {
        JavaType javaType = new JavaType(javaClass);
        JavaTypeTests.assertTrue((boolean)javaType.describes(javaClass));
    }

    public void testDeclaration() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaType javaType = new JavaType((Class)clazz);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.declaration());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz2);
        JavaTypeTests.assertEquals((String)"java.lang.Object[]", (String)javaType.declaration());
        javaType = new JavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.declaration());
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz3);
        JavaTypeTests.assertEquals((String)"int[]", (String)javaType.declaration());
        javaType = new JavaType(Void.TYPE);
        JavaTypeTests.assertEquals((String)"void", (String)javaType.declaration());
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz4);
        JavaTypeTests.assertEquals((String)"java.util.Map.Entry", (String)javaType.declaration());
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz5);
        JavaTypeTests.assertEquals((String)"java.util.Map.Entry[][]", (String)javaType.declaration());
    }

    public void testIsPrimitive() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaType javaType = new JavaType((Class)clazz);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz2);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        javaType = new JavaType(Integer.TYPE);
        JavaTypeTests.assertTrue((boolean)javaType.isPrimitive());
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz3);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        javaType = new JavaType(Void.TYPE);
        JavaTypeTests.assertTrue((boolean)javaType.isPrimitive());
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.util.Map$Entry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz4);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("[[Ljava.util.Map$Entry;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaType = new JavaType((Class)clazz5);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
    }
}

