/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.SequenceGenerator;
import org.eclipse.dali.orm.TableGenerator;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.ISequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.ITableGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.JavaIdMappingModelAdapter;

public class JavaIdMappingModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    private IdMapping testClassIdMapping;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaIdMappingModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaIdMappingModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
        this.testClassIdMapping = (IdMapping)((PersistentAttribute)this.testClassType.getPersistentAttributes().get(0)).getAttributeMapping();
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    private JavaIdMappingModelAdapter getIdModelAdapter() {
        return (JavaIdMappingModelAdapter)this.testClassIdMapping.getModelAdapter();
    }

    public void testGeneratedValueChangesInJavaUpdatesPersistenceModel() {
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        attribute.addAnnotation("GeneratedValue");
        JavaIdMappingModelAdapterTests.assertNotNull((Object)this.testClassIdMapping.getGeneratedValue());
        attribute.removeAnnotation("GeneratedValue");
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
    }

    public void testGeneratedValueChangesInPersistenceModelUpdatesJava() {
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
        IGeneratedValueModelAdapter generatedValueModelAdapter = this.getIdModelAdapter().createGeneratedValueModelAdapter();
        GeneratedValue generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(generatedValueModelAdapter);
        this.testClassIdMapping.setGeneratedValue(generatedValue);
        JavaIdMappingModelAdapterTests.assertNotNull((Object)attribute.getAnnotation("GeneratedValue"));
        this.testClassIdMapping.setGeneratedValue(null);
        JavaIdMappingModelAdapterTests.assertNull((Object)attribute.getAnnotation("GeneratedValue"));
    }

    public void testTableGeneratorChangesInJavaUpdatesPersistenceModel() {
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getTableGenerator());
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        attribute.addAnnotation("TableGenerator");
        JavaIdMappingModelAdapterTests.assertNotNull((Object)this.testClassIdMapping.getTableGenerator());
        attribute.removeAnnotation("TableGenerator");
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getTableGenerator());
    }

    public void testTableGeneratorChangesInPersistenceModelUpdatesJava() {
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getTableGenerator());
        ITableGeneratorModelAdapter tableGeneratorModelAdapter = (ITableGeneratorModelAdapter)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"createTableGeneratorModelAdapter");
        TableGenerator tableGenerator = OrmFactory.eINSTANCE.createTableGenerator(tableGeneratorModelAdapter);
        this.testClassIdMapping.setTableGenerator(tableGenerator);
        JavaIdMappingModelAdapterTests.assertNotNull((Object)attribute.getAnnotation("TableGenerator"));
        this.testClassIdMapping.setTableGenerator(null);
        JavaIdMappingModelAdapterTests.assertNull((Object)attribute.getAnnotation("TableGenerator"));
        IGeneratedValueModelAdapter generatedValueModelAdapter = this.getIdModelAdapter().createGeneratedValueModelAdapter();
        GeneratedValue generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(generatedValueModelAdapter);
        this.testClassIdMapping.setGeneratedValue(generatedValue);
        generatedValue.setSpecifiedGeneratorName("fooGen");
    }

    public void testSequenceGeneratorChangesInJavaUpdatesPersistenceModel() {
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getSequenceGenerator());
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        attribute.addAnnotation("SequenceGenerator");
        JavaIdMappingModelAdapterTests.assertNotNull((Object)this.testClassIdMapping.getSequenceGenerator());
        attribute.removeAnnotation("SequenceGenerator");
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getSequenceGenerator());
    }

    public void testSequenceGeneratorChangesInPersistenceModelUpdatesJava() {
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        JavaIdMappingModelAdapterTests.assertNull((Object)this.testClassIdMapping.getSequenceGenerator());
        ISequenceGeneratorModelAdapter sequenceGeneratorModelAdapter = (ISequenceGeneratorModelAdapter)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"createSequenceGeneratorModelAdapter");
        SequenceGenerator sequenceGenerator = OrmFactory.eINSTANCE.createSequenceGenerator(sequenceGeneratorModelAdapter);
        this.testClassIdMapping.setSequenceGenerator(sequenceGenerator);
        JavaIdMappingModelAdapterTests.assertNotNull((Object)attribute.getAnnotation("SequenceGenerator"));
        this.testClassIdMapping.setSequenceGenerator(null);
        JavaIdMappingModelAdapterTests.assertNull((Object)attribute.getAnnotation("SequenceGenerator"));
    }
}

