/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.schemas.Html401Strict;
import org.eclipse.vjet.dsf.html.schemas.Html401Transitional;
import org.eclipse.vjet.dsf.html.schemas.ISchema;

public class DHtmlDocType
extends DDocumentType {
    public static final String QUALIFIED_NAME = "html";
    public static final Type HTML_FRAMESET = new Type("HTML_FRAMESET");
    public static final Type HTML_STRICT = new Type("HTML_STRICT");
    public static final Type HTML_TRANSITIONAL = new Type("HTML_TRANSITIONAL");
    public static final Type XHTML_STRICT = new Type("XHTML_STRICT");
    public static final Type XHTML_TRANSITIONAL = new Type("XHTML_TRANSITIONAL");
    public static final Type XHTML_FRAMESET = new Type("XHTML_FRAMESET");
    public static final Type HTML_50 = new Type("HTML");
    public static final Type NONE = new Type("NONE");
    private ISchema m_schema;

    DHtmlDocType(DHtmlDocument doc, String qualifiedName, String publicId, String systemId) {
        super((DDocument)doc, qualifiedName, publicId, systemId);
    }

    public static DHtmlDocType createDocType(DHtmlDocument doc, Type desiredDocTypeEnum) {
        DHtmlDocType docType;
        if (desiredDocTypeEnum == HTML_STRICT) {
            docType = new DHtmlDocType(doc, QUALIFIED_NAME, "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd");
            docType.setSchema(Html401Strict.getInstance());
        } else if (desiredDocTypeEnum == HTML_TRANSITIONAL) {
            docType = new DHtmlDocType(doc, QUALIFIED_NAME, "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd");
            docType.setSchema(Html401Transitional.getInstance());
        } else if (desiredDocTypeEnum == HTML_FRAMESET) {
            docType = new DHtmlDocType(doc, QUALIFIED_NAME, "-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd");
        } else if (desiredDocTypeEnum == XHTML_STRICT) {
            docType = new DHtmlDocType(doc, QUALIFIED_NAME, "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        } else if (desiredDocTypeEnum == XHTML_TRANSITIONAL) {
            docType = new DHtmlDocType(doc, QUALIFIED_NAME, "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        } else if (desiredDocTypeEnum == XHTML_FRAMESET) {
            docType = new DHtmlDocType(doc, QUALIFIED_NAME, "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        } else if (desiredDocTypeEnum == NONE) {
            docType = null;
        } else {
            throw new DsfRuntimeException("unexpected document type '" + desiredDocTypeEnum + "'");
        }
        return docType;
    }

    public ISchema getSchema() {
        return this.m_schema;
    }

    public void setSchema(ISchema schema) {
        this.m_schema = schema;
    }

    public DHtmlDocType jif(String jif) {
        super.jif(jif);
        return this;
    }

    public static final class Type {
        final String m_name;

        private Type(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

