/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.Vector;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.js.JSOption;
import org.eclipse.vjet.dsf.html.js.JSSelect;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.NativeObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.w3c.dom.NodeList;

public class JSOptionsArray
extends ScriptableObject {
    private JSWindow window = null;
    private JSSelect jsSelect = null;
    private Scriptable scope = null;
    private DSelect select = null;
    private String name = null;
    private String formId = null;
    private Vector options = new Vector();

    private JSOptionsArray() {
    }

    public JSOptionsArray(JSWindow window, JSSelect jsSelect) {
        this.window = window;
        this.jsSelect = jsSelect;
        this.scope = window.getScope();
        this.select = jsSelect.getHtmlSelect();
        this.name = this.select.getHtmlName();
        this.formId = this.select.getAttribute("form-id");
        this.defineProperty("selectedIndex", JSOptionsArray.class, 2);
        this.updateOptions();
    }

    public String getClassName() {
        return "JSOptionssArray";
    }

    public boolean has(int index, Scriptable start) {
        DHtmlCollection options = this.select.getHtmlOptions();
        if (options == null) {
            return false;
        }
        return index >= 0 && index < options.getLength();
    }

    public Object get(int index, Scriptable start) {
        if (index < 0) {
            return Scriptable.NOT_FOUND;
        }
        if (this.window.windowState == JSWindow.IN_LOADING) {
            NodeList options = this.select.getElementsByTagName(HtmlTypeEnum.OPTION);
            if (options == null || index >= options.getLength()) {
                return Scriptable.NOT_FOUND;
            }
            return Context.toObject((Object)options.item(index), (Scriptable)this.scope);
        }
        if (this.options == null || index >= this.options.size()) {
            return Scriptable.NOT_FOUND;
        }
        return Context.toObject(this.options.get(index), (Scriptable)this.scope);
    }

    public void put(int index, Scriptable start, Object obj) {
        if (index < 0) {
            return;
        }
        if (this.window.windowState == JSWindow.IN_LOADING) {
            NativeObject nativeOptionObj = (NativeObject)obj;
            String text = nativeOptionObj.get("text", start).toString();
            DOption option = null;
            NodeList options = this.select.getElementsByTagName(HtmlTypeEnum.OPTION);
            if (options == null || index >= options.getLength()) {
                option = new DOption();
                this.select.add((DNode)option);
            } else {
                option = (DOption)options.item(index);
            }
            option.setHtmlText(text);
        }
    }

    public int getSelectedIndex() {
        return this.jsSelect.getSelectedIndex();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.jsSelect.setSelectedIndex(selectedIndex);
    }

    private void updateOptions() {
        DHtmlCollection domOptions = this.select.getHtmlOptions();
        int numOptions = 0;
        if (domOptions == null || (numOptions = domOptions.getLength()) == 0) {
            return;
        }
        this.options.removeAllElements();
        int i = 0;
        while (i < numOptions) {
            this.options.add(new JSOption(this.window, (DOption)domOptions.item(i), this.name, this.formId));
            ++i;
        }
    }

    public JSOption getOption(int index) {
        if (index >= 0 && index < this.options.size()) {
            return (JSOption)((Object)this.options.get(index));
        }
        return null;
    }

    public int numOptions() {
        return this.options.size();
    }

    public int getIndex(String optionValue) {
        optionValue = optionValue.trim();
        int size = this.options.size();
        int index = 0;
        while (index < size) {
            JSOption option = (JSOption)((Object)this.options.get(index));
            String value = option.getValue().trim();
            if (value.length() == 0 && optionValue.length() != 0) {
                value = option.getText().trim();
            }
            if (value.equals(optionValue)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public void add(JSOption option) {
        this.select.add((DNode)option.getDNode());
        this.options.add(option);
    }

    public void removeAll() {
        DHtmlCollection domOptions = this.select.getHtmlOptions();
        if (domOptions == null || domOptions.getLength() == 0) {
            return;
        }
        int i = domOptions.getLength() - 1;
        while (i >= 0) {
            this.select.removeChild(domOptions.item(i));
            --i;
        }
        this.options.removeAllElements();
    }
}

