/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.js.JSElement;
import org.eclipse.vjet.dsf.html.js.JSWindow;

public class JSOption
extends JSElement {
    private DOption option = null;
    public String name = null;
    public String formId = null;

    private JSOption() {
    }

    public JSOption(JSWindow window) {
        super(window, (BaseHtmlElement)new DOption());
        this.option = (DOption)super.getDNode();
    }

    public JSOption(JSWindow window, DOption option, String name, String formId) {
        super(window, (BaseHtmlElement)option);
        this.option = option;
        this.name = name;
        this.formId = formId;
        this.defineProperty("defaultSelected", JSOption.class, 2);
        this.defineProperty("text", JSOption.class, 2);
        this.defineProperty("index", JSOption.class, 2);
        this.defineProperty("disabled", JSOption.class, 2);
        this.defineProperty("label", JSOption.class, 2);
        this.defineProperty("selected", JSOption.class, 2);
        this.defineProperty("value", JSOption.class, 2);
    }

    @Override
    public String getClassName() {
        return "JSOptionElement";
    }

    public boolean getDefaultSelected() {
        return this.option.getHtmlDefaultSelected();
    }

    public void setDefaultSelected(boolean defaultSelected) {
        this.option.setHtmlDefaultSelected(defaultSelected);
    }

    public String getText() {
        return this.option.getHtmlText();
    }

    public void setText(String text) {
        this.option.setHtmlText(text);
    }

    public int getIndex() {
        return this.option.getHtmlIndex();
    }

    public void setIndex(int index) {
        this.option.setHtmlIndex(index);
    }

    public boolean getDisabled() {
        return this.option.getHtmlDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.option.setHtmlDisabled(disabled);
    }

    public String getLabel() {
        return this.option.getHtmlLabel();
    }

    public void setLabel(String label) {
        this.option.setHtmlLabel(label);
    }

    public boolean getSelected() {
        return this.option.getHtmlSelected();
    }

    public void setSelected(boolean selected) {
    }

    public String getValue() {
        String value = null;
        value = this.option.getHtmlValue();
        if (this.window.windowState == JSWindow.IN_ANALYSIS) {
            value = this.window.getJSListener().doAction(17, this.name, value, this.formId);
        }
        return value;
    }

    public void setValue(String value) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            this.option.setHtmlValue(value);
        } else {
            this.window.getJSListener().doAction(10, this.name, value, this.formId);
        }
    }

    public DOption getDNode() {
        return this.option;
    }
}

