/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlType;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.jsnative.HtmlBody;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.Text;
import org.w3c.dom.DOMException;

abstract class Document {
    Document() {
    }

    public static HtmlElement getDocumentElement() {
        return Document.document().getDocumentElement();
    }

    public static HtmlCollection getAnchors() {
        return Document.document().getAnchors();
    }

    public static HtmlCollection getApplets() {
        return Document.document().getApplets();
    }

    public static HtmlCollection getForms() {
        return Document.document().getForms();
    }

    public static HtmlCollection getImages() {
        return Document.document().getImages();
    }

    public static HtmlCollection getLinks() {
        return Document.document().getLinks();
    }

    public static HtmlBody getBody() {
        return Document.document().getBody();
    }

    public static String getCookie() {
        return Document.document().getCookie();
    }

    public static void setCookie(String cookie) {
        Document.document().setCookie(cookie);
    }

    public static String getDomain() {
        return Document.document().getDomain();
    }

    public static String getReferrer() {
        return Document.document().getReferrer();
    }

    public static String getTitle() {
        return Document.document().getTitle();
    }

    public static void setTitle(String title) {
        Document.document().setTitle(title);
    }

    public static String getURL() {
        return Document.document().getURL();
    }

    public static HtmlElement createElement(String tagName) throws DOMException {
        return Document.document().createElement(tagName);
    }

    public static <T extends HtmlElement> T createElement(AHtmlType<T> type) throws DOMException {
        return type.create(Document.document());
    }

    public static Text createTextNode(String data) {
        return Document.document().createTextNode(data);
    }

    public static HtmlElement getElementById(String elementId) {
        return Document.document().getElementById(elementId);
    }

    public static NodeList getElementsByTagName(String tagName) {
        return Document.document().getElementsByTagName(tagName);
    }

    public static NodeList getElementsByName(String elementName) {
        return Document.document().getElementsByName(elementName);
    }

    public static Node importNode(Node importedNode, boolean deep) {
        return Document.document().importNode(importedNode, deep);
    }

    public static void close() {
        Document.document().close();
    }

    public static void open() {
        Document.document().open();
    }

    public void write(String text) {
        Document.document().write((Object)text);
    }

    public void writeln(String text) {
        Document.document().writeln((Object)text);
    }

    private static HtmlDocument document() {
        AHtmlDocument document = DapCtx.document();
        if (document == null) {
            throw new DsfRuntimeException("document did not exist");
        }
        return document;
    }
}

