/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.svc.IDapHostSvcMsg;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.service.ServiceIdHelper;
import org.eclipse.vjet.dsf.service.serializer.JsonSerializer;
import org.eclipse.vjet.dsf.services.ServiceResponse;
import org.mozilla.mod.javascript.Scriptable;

public final class DapHostMessage
extends BaseScriptable
implements IDapHostSvcMsg {
    private String m_svcId;
    private String m_objType = "dsf_Message";
    private Object m_request;
    private Object m_response;
    private String m_rawRequest = "";
    private Object m_clientContext;
    private String m_trspType = "InProc";
    private String m_status;
    private Object m_svcConfig;
    private String m_trace = "";
    private static final String[] PTY_NAMES = new String[]{"objType", "svcId", "request", "response", "rawRequest", "clientContext", "trspType", "status", "svcConfig", "trace"};
    private static final String[] MTD_NAMES = new String[]{"valueOf"};

    public DapHostMessage() {
        this.defineProperties(PTY_NAMES);
        this.defineFunctionProperties(MTD_NAMES);
    }

    public Object getClientContext() {
        return this.m_clientContext;
    }

    public void setClientContext(Object clientContext) {
        this.m_clientContext = clientContext;
    }

    public String getObjType() {
        return this.m_objType;
    }

    public void setObjType(String objType) {
        this.m_objType = objType;
    }

    public String getRawRequest() {
        return this.m_rawRequest;
    }

    public void setRawRequest(String rawRequest) {
        this.m_rawRequest = rawRequest;
    }

    public Object getRequest() {
        if (this.m_request == null || this.m_request instanceof String) {
            return this.m_request;
        }
        JsonSerializer rpcSerializer = JsonSerializer.getInstance();
        String jsonReq = null;
        try {
            jsonReq = rpcSerializer.serialize(this.m_request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AWindow w = DapCtx.ctx().getWindow();
        return w.getContext().evaluateString((Scriptable)w, "(" + jsonReq + ")", "dap", 1, null);
    }

    public void setRequest(Object request) {
        this.m_request = request;
    }

    public Object getResponse() {
        return this.m_response;
    }

    public ServiceResponse getSvcResponse() {
        String resp = this.m_response.toString();
        if (resp != null) {
            ServiceResponse svcResp = new ServiceResponse();
            JsonSerializer rpcSerializer = JsonSerializer.getInstance();
            try {
                svcResp.setData(rpcSerializer.deserialize(resp, ServiceResponse.class, null));
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
            return (ServiceResponse)svcResp.getData();
        }
        return null;
    }

    public void setResponse(Object response) {
        this.m_response = response;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public Object getSvcConfig() {
        return this.m_svcConfig;
    }

    public void setSvcConfig(Object svcConfig) {
        this.m_svcConfig = svcConfig;
    }

    public String getSvcId() {
        return this.m_svcId;
    }

    public void setSvcId(String svcId) {
        this.m_svcId = svcId;
    }

    public String getOpName() {
        return ServiceIdHelper.getOperationName((String)this.m_svcId);
    }

    public String getTrace() {
        return this.m_trace;
    }

    public void setTrace(String trace) {
        this.m_trace = trace;
    }

    public String getTrspType() {
        return this.m_trspType;
    }

    public void setTrspType(String trspType) {
        this.m_trspType = trspType;
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }
}

