/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.event.listener.DapEventListenerHelper;
import org.eclipse.vjet.dsf.dap.event.listener.IDapEventListener;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapEventHandlerAdapter;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.events.EventHandlerContainer;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.IDomEventType;
import org.eclipse.vjet.dsf.html.events.IDomType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;

public final class DapEventListenerRegistry {
    private static final String BODY = "body";
    private Map<String, List<IDapEventListener>> m_listeners = new LinkedHashMap<String, List<IDapEventListener>>();

    public void addBodyListener(IDapEventListener listener) {
        this.addListener(BODY, listener);
    }

    public void addBodyListener(EventType eventType, IDapEventListener listener) {
        this.addListener(BODY, eventType, listener);
    }

    public void addListener(BaseHtmlElement elem, IDapEventListener listener) {
        this.addListener(DapDomHelper.getId(elem), listener);
    }

    public void addListener(String elemId, IDapEventListener listener) {
        Class<?>[] interfaces;
        if (elemId == null) {
            throw new AssertionError((Object)"elemId cannot be null");
        }
        if (listener == null) {
            throw new AssertionError((Object)"listener cannot be null");
        }
        Class<?>[] classArray = interfaces = listener.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> itf = classArray[n2];
            if (IDapEventListener.class.isAssignableFrom(itf)) {
                for (EventType evtType : DapEventListenerHelper.getSupportedEventTypes(itf)) {
                    this.addListener(elemId, evtType, listener);
                }
            }
            ++n2;
        }
    }

    public void addListener(BaseHtmlElement elem, EventType eventType, IDapEventListener listener) {
        this.addListener(DapDomHelper.getId(elem), eventType, listener);
    }

    public void addListener(String elemId, EventType eventType, IDapEventListener listener) {
        IJsFunc handler;
        if (elemId == null) {
            throw new AssertionError((Object)"elemId cannot be null");
        }
        if (eventType == null) {
            throw new AssertionError((Object)"eventType cannot be null");
        }
        if (listener == null) {
            throw new AssertionError((Object)"listener cannot be null");
        }
        EventHandlerContainer container = HtmlCtx.ctx().getEventHandlerContainer();
        if (DapCtx.ctx().isActiveMode()) {
            int index = this.add(elemId, listener);
            ISimpleJsEventHandler handler2 = listener.getEventHandlerAdapter(elemId, index);
            if (BODY.equals(elemId)) {
                container.add((IDomType)HtmlTypeEnum.BODY, (IDomEventType)eventType, handler2);
            } else {
                container.add(elemId, (IDomEventType)eventType, handler2);
            }
            return;
        }
        Map handlers = listener.getProxyEventHandlers();
        if (handlers != null && (handler = this.getHandler(handlers, eventType)) != null) {
            container.add(elemId, (IDomEventType)eventType, listener.getEventHandlerAdapter(handler));
            return;
        }
        throw new DsfRuntimeException("js proxy handlers are required for non-active modes:mode=" + (Object)((Object)DapCtx.ctx().getExeMode()) + ", elem=" + elemId + ", eventType=" + eventType + ", listenerType=" + listener.getClass().getName());
    }

    public void remove(BaseHtmlElement elem, EventType eventType, IDapEventListener listener) {
        EventHandlerContainer container = HtmlCtx.ctx().getEventHandlerContainer();
        String elemId = DapDomHelper.getId(elem);
        if (DapCtx.ctx().isActiveMode()) {
            List<IDapEventListener> listeners = this.getListeners(elemId, true);
            if (listeners.contains(listener)) {
                listeners.remove(listener);
            }
            container.removeHandler((DElement)elem, listener.getEventHandlerAdapter(elemId, listeners.indexOf(listener)));
            return;
        }
        if (listener.getProxyEventHandlers() != null) {
            IJsFunc handler = this.getHandler(listener.getProxyEventHandlers(), eventType);
            this.removeHandler(elem, eventType, handler, container);
        }
        throw new DsfRuntimeException("js proxy handlers are required for non-active mode:mode=" + (Object)((Object)DapCtx.ctx().getExeMode()) + ", elem=" + elemId + ", eventType=" + eventType + ", listenerType=" + listener.getClass().getName());
    }

    List<IDapEventListener> getListeners(String id) {
        List<IDapEventListener> list = this.getListeners(id, false);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    synchronized Map<String, List<IDapEventListener>> getAllListeners() {
        if (this.m_listeners == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_listeners);
    }

    private synchronized int add(String elemId, IDapEventListener listener) {
        if (elemId == null) {
            return -1;
        }
        List<IDapEventListener> listeners = this.getListeners(elemId, true);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            return listeners.size() - 1;
        }
        return listeners.indexOf(listener);
    }

    private synchronized List<IDapEventListener> getListeners(String id, boolean create) {
        if (id == null) {
            return null;
        }
        List<IDapEventListener> list = this.m_listeners.get(id);
        if (list == null) {
            if (!create) {
                return null;
            }
            list = new ArrayList<IDapEventListener>(2);
            this.m_listeners.put(id, list);
        }
        return list;
    }

    private IJsFunc getHandler(Map<EventType, IJsFunc> handlers, EventType eventType) {
        if (handlers == null) {
            return null;
        }
        for (Map.Entry<EventType, IJsFunc> entry : handlers.entrySet()) {
            if (!entry.getKey().equals((Object)eventType)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void removeHandler(BaseHtmlElement elem, EventType eventType, IJsFunc handler, EventHandlerContainer container) {
        if (handler == null) {
            return;
        }
        List pairs = (List)container.getElements().get(elem);
        if (pairs == null) {
            return;
        }
        for (EventHandlerContainer.EventsToHandlerPair pair : pairs) {
            DapEventHandlerAdapter adapter;
            if (pair.getEventType() != eventType || !(pair.getHandler() instanceof DapEventHandlerAdapter) || (adapter = (DapEventHandlerAdapter)pair.getHandler()) == null || adapter.getJsFunc() != handler) continue;
            pairs.remove(pair);
            return;
        }
    }
}

