/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.vjet.dsf.dap.cnr.IEventFilter;
import org.eclipse.vjet.dsf.dap.rt.DapCaptureReplay;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;

public class DapConsoleCaptureHandler
implements IDapConsoleHandler {
    public static final String START = "CAPTURE_START";
    public static final String PAUSE = "CAPTURE_PAUSE";
    public static final String RESUME = "CAPTURE_RESUME";
    public static final String STOP = "CAPTURE_STOP";
    public static final String FILTER_EVENTS = "FILTER_EVENTS";
    private static final String[] INPUTS = new String[]{"CAPTURE_START", "CAPTURE_PAUSE", "CAPTURE_RESUME", "CAPTURE_STOP", "FILTER_EVENTS"};
    private static DapConsoleCaptureHandler s_instance = new DapConsoleCaptureHandler();

    private DapConsoleCaptureHandler() {
    }

    public static DapConsoleCaptureHandler getInstance() {
        return s_instance;
    }

    @Override
    public String[] getSupportedInputs() {
        return INPUTS;
    }

    @Override
    public void handle(String input) {
        if (input == null) {
            return;
        }
        if (input.startsWith(START)) {
            StringTokenizer tokenizer = new StringTokenizer(input, " ");
            tokenizer.nextToken();
            String name = null;
            if (tokenizer.hasMoreTokens()) {
                name = tokenizer.nextToken();
            }
            this.getCaptureReplay().startCapture(name);
        } else if (PAUSE.equalsIgnoreCase(input)) {
            this.getCaptureReplay().pauseCapture();
        } else if (RESUME.equalsIgnoreCase(input)) {
            this.getCaptureReplay().resumeCapture();
        } else if (STOP.equalsIgnoreCase(input)) {
            this.getCaptureReplay().stopCapture();
        } else if (input.startsWith(FILTER_EVENTS)) {
            int index = input.indexOf(FILTER_EVENTS);
            this.filterEvents(input.substring(index + FILTER_EVENTS.length()));
        }
    }

    private DapCaptureReplay getCaptureReplay() {
        return DapCtx.ctx().getSession().getCaptureReplay();
    }

    private void filterEvents(String options) {
        if (options == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(options, " ");
        EventType eventType = null;
        final HashSet<String> eventTypes = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || token.trim().length() == 0 || (eventType = EventType.get((String)token.trim())) == null) continue;
            eventTypes.add(eventType.getName());
        }
        if (!eventTypes.isEmpty()) {
            DapCtx.ctx().getSession().getCaptureReplay().getCapture().addEventFilter(new IEventFilter(){

                @Override
                public boolean filter(DLCEvent event) {
                    return eventTypes.contains(event.getType());
                }
            });
        }
    }
}

