/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEmulator;
import org.eclipse.vjet.dsf.dap.rt.DapConsoleHelpHandler;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleProxy;

public class DapConsole
implements Runnable {
    public static final String OPT_SESSION = "-sid ";
    private DapBrowserEmulator m_emulator;
    private DapConsoleHelpHandler m_menuHelper;

    public DapConsole(DapBrowserEmulator emulator) {
        this.m_emulator = emulator;
        this.m_menuHelper = new DapConsoleHelpHandler();
        Collection<IDapConsoleProxy> proxies = DapCtx.ctx().getDapConfig().getDapConsoleProxies();
        for (IDapConsoleProxy dapConsoleProxy : proxies) {
            dapConsoleProxy.setBrowserEmulator(this.m_emulator);
            Thread t = new Thread(dapConsoleProxy);
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                block3: while (true) {
                    if ("HELP".equalsIgnoreCase(line = in.readLine())) {
                        this.m_menuHelper.handle(line);
                        continue;
                    }
                    sessionId = this.getSessionId(line);
                    if (sessionId != null) {
                        session = this.m_emulator.getSession(sessionId);
                        if (session == null) {
                            System.out.println("Invalid session id: " + sessionId);
                            continue;
                        }
                    } else {
                        sessions = this.m_emulator.getSessions();
                        if (sessions.size() == 1) {
                            session = sessions.values().iterator().next();
                        } else {
                            System.out.println("Please provide session id");
                            continue;
                        }
                    }
                    session.getCurrentView().setupCtx();
                    var6_7 = this.m_emulator.getDapConfig().getConsoleHandlers().iterator();
                    while (true) {
                        if (var6_7.hasNext()) ** break;
                        continue block3;
                        h = var6_7.next();
                        h.handle(line);
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private String getSessionId(String cmd) {
        if (cmd == null) {
            return null;
        }
        int start = cmd.indexOf(OPT_SESSION);
        if (start < 0) {
            return null;
        }
        int end = cmd.indexOf(" ", start + OPT_SESSION.length());
        if (end < start) {
            return cmd.substring(start + OPT_SESSION.length());
        }
        return cmd.substring(start + OPT_SESSION.length(), end);
    }

    public void onload(DapSession session) {
        Collection<IDapConsoleProxy> proxies = DapCtx.ctx().getDapConfig().getDapConsoleProxies();
        for (IDapConsoleProxy dapConsoleProxy : proxies) {
            dapConsoleProxy.onLoad(session);
        }
    }

    public void onUnload(DapSession session) {
        Collection<IDapConsoleProxy> proxies = DapCtx.ctx().getDapConfig().getDapConsoleProxies();
        for (IDapConsoleProxy dapConsoleProxy : proxies) {
            dapConsoleProxy.onUnload(session);
        }
    }
}

