/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.proxy;

import org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class NativeJsFuncProxy<T>
implements INativeJsFuncProxy<T> {
    private static final long serialVersionUID = 1L;
    private final Function m_func;

    public NativeJsFuncProxy(Function func) {
        assert (func != null) : "Passed in Rhino function must not be null";
        this.m_func = func;
    }

    public NativeJsFuncProxy(T obj, String funcName) {
        Scriptable type = obj instanceof Class ? NativeJsHelper.getNativeClzType(((Class)obj).getName()) : this.toScriptable(obj);
        this.m_func = (Function)ScriptableObject.getProperty((Scriptable)type, (String)funcName);
    }

    @Override
    public Object apply(T thisObj, Object[] args) {
        Object ret = this.m_func.call(NativeJsHelper.getContext(), NativeJsHelper.getScope(), this.toScriptable(thisObj), NativeJsHelper.toNatives(args));
        return this.convert(ret);
    }

    @Override
    public Object call(T thisObj, Object ... args) {
        return this.apply(thisObj, args);
    }

    @Override
    public Function getJsNative() {
        return this.m_func;
    }

    public static <E extends IJsJavaProxy> NativeJsFuncProxy<E> create(E obj, String funcName) {
        return new NativeJsFuncProxy<E>(obj, funcName);
    }

    protected Object convert(Object nativeObj) {
        return NativeJsHelper.convert(Object.class, nativeObj);
    }

    private Scriptable toScriptable(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IJsJavaProxy) {
            return ((IJsJavaProxy)obj).getJsNative();
        }
        return (Scriptable)NativeJsHelper.toNative(obj);
    }
}

