/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.proxy;

import org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.proxy.JFunction;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.Scriptable;

public class FuncX {
    private static final String VJO_HITCH = "vjo.hitch";
    private static final String VJO_CURRY = "vjo.curry";
    private static final String VJO_BIND = "vjo.bind";

    public static <T, E> JFunction<T, E> hitch(T ctx, JFunction<T, E> func) {
        return FuncX.hitch(ctx, func, false);
    }

    public static <T, E> JFunction<T, E> hitch(T ctx, JFunction<T, E> func, boolean openCtx) {
        Function hFunc = FuncX.getHitchedFunc(ctx, func.getJsNative(), openCtx);
        JFunction newJFunc = new JFunction(hFunc);
        newJFunc.setReturnType(func.getReturnType());
        return newJFunc;
    }

    public static <T> INativeJsFuncProxy<T> hitch(T ctx, INativeJsFuncProxy<T> func) {
        return FuncX.hitch(ctx, func, false);
    }

    public static <T> INativeJsFuncProxy<T> hitch(T ctx, INativeJsFuncProxy<T> func, boolean openCtx) {
        Function hFunc = FuncX.getHitchedFunc(ctx, func.getJsNative(), openCtx);
        return new NativeJsFuncProxy(hFunc);
    }

    public static <T, E> JFunction<T, E> curry(JFunction<T, E> func, Object ... args) {
        Function curriedFunc = FuncX.getCurriedFunc(func.getJsNative(), args);
        JFunction newJFunc = new JFunction(curriedFunc);
        newJFunc.setReturnType(func.getReturnType());
        return newJFunc;
    }

    public static <T> INativeJsFuncProxy<T> curry(INativeJsFuncProxy<T> func, Object ... args) {
        Function curriedFunc = FuncX.getCurriedFunc(func.getJsNative(), args);
        return new NativeJsFuncProxy(curriedFunc);
    }

    public static <T, E> JFunction<T, E> bind(T obj, JFunction<T, E> func, Object ... args) {
        Function boundFunc = FuncX.getBoundFunc(obj, func.getJsNative(), args);
        JFunction newJFunc = new JFunction(boundFunc);
        newJFunc.setReturnType(func.getReturnType());
        return newJFunc;
    }

    public static <T> INativeJsFuncProxy<T> bind(T obj, INativeJsFuncProxy<T> func, Object ... args) {
        Function boundFunc = FuncX.getBoundFunc(obj, func.getJsNative(), args);
        return new NativeJsFuncProxy(boundFunc);
    }

    private static Function getHitchedFunc(Object obj, Function func, boolean openCtx) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        Function hitch = (Function)ctx.evaluateString(scope, VJO_HITCH, VJO_HITCH, 0, null);
        Object[] args = openCtx ? new Object[]{func, obj, openCtx} : new Object[]{func, obj};
        return (Function)hitch.call(ctx, scope, null, NativeJsHelper.toNatives(args));
    }

    private static Function getCurriedFunc(Function func, Object[] args) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        Function curry = (Function)ctx.evaluateString(scope, VJO_CURRY, VJO_CURRY, 0, null);
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = func;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return (Function)curry.call(ctx, scope, null, NativeJsHelper.toNatives(newArgs));
    }

    private static Function getBoundFunc(Object obj, Function func, Object[] args) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        Function bind = (Function)ctx.evaluateString(scope, VJO_BIND, VJO_BIND, 0, null);
        Object[] newArgs = new Object[args.length + 2];
        newArgs[0] = obj;
        newArgs[1] = func;
        System.arraycopy(args, 0, newArgs, 2, args.length);
        return (Function)bind.call(ctx, scope, null, NativeJsHelper.toNatives(newArgs));
    }
}

