/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ScriptingSessionClassLoader
extends ClassLoader {
    public ScriptingSessionClassLoader() {
        super(ScriptingSessionClassLoader.class.getClassLoader());
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> loadedClz = this.findLoadedClass(className);
        if (loadedClz != null) {
            return loadedClz;
        }
        ClassLoader parent = this.getParent();
        if (parent.getResource(String.valueOf(this.getOuterClassName(className).replace('.', '/')) + ".js") == null) {
            loadedClz = parent.loadClass(className);
        } else {
            URL url = parent.getResource(String.valueOf(className.replace('.', '/')) + ".class");
            if (url == null) {
                throw new ClassNotFoundException(className);
            }
            byte[] classByte = this.loadClassData(url);
            loadedClz = this.defineClass(className, classByte, 0, classByte.length, null);
        }
        return loadedClz;
    }

    private byte[] loadClassData(URL url) {
        byte[] buffer = new byte[1024];
        int numRead = 0;
        try {
            InputStream is = url.openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((numRead = is.read(buffer)) > 0) {
                os.write(buffer, 0, numRead);
            }
            is.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getOuterClassName(String name) {
        int index = name.indexOf("$");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }
}

