/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DFrame;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlFrame;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlFrame
extends AHtmlElement
implements HtmlFrame {
    private static final long serialVersionUID = 1L;
    private AHtmlDocument m_contentDocument = null;

    protected AHtmlFrame(AHtmlDocument doc, DFrame node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlFrame.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public HtmlDocument getDocument() {
        return this.m_contentDocument;
    }

    public HtmlDocument getContentDocument() {
        return this.m_contentDocument;
    }

    public String getFrameBorder() {
        return this.getDFrame().getHtmlFrameBorder();
    }

    public String getLongDesc() {
        return this.getDFrame().getHtmlLongDesc();
    }

    public String getMarginHeight() {
        return this.getDFrame().getHtmlMarginHeight();
    }

    public String getMarginWidth() {
        return this.getDFrame().getHtmlMarginWidth();
    }

    public String getName() {
        return this.getDFrame().getHtmlName();
    }

    public boolean getNoResize() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.noresize, this.getHtmlAttribute(EHtmlAttr.noresize));
    }

    public String getScrolling() {
        return this.getDFrame().getHtmlScrolling();
    }

    public String getSrc() {
        return this.getDFrame().getHtmlSrc();
    }

    public void setFrameBorder(String frameBorder) {
        this.getDFrame().setHtmlFrameBorder(frameBorder);
        this.onAttrChange(EHtmlAttr.frameborder, frameBorder);
    }

    public void setLongDesc(String longDesc) {
        this.getDFrame().setHtmlLongDesc(longDesc);
        this.onAttrChange(EHtmlAttr.longdesc, longDesc);
    }

    public void setMarginHeight(String marginHeight) {
        this.getDFrame().setHtmlMarginHeight(marginHeight);
        this.onAttrChange(EHtmlAttr.marginheight, marginHeight);
    }

    public void setMarginWidth(String marginWidth) {
        this.getDFrame().setHtmlMarginWidth(marginWidth);
        this.onAttrChange(EHtmlAttr.marginwidth, marginWidth);
    }

    public void setName(String name) {
        this.getDFrame().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setNoResize(boolean noResize) {
        this.setHtmlAttribute(EHtmlAttr.noresize, noResize);
        this.onAttrChange(EHtmlAttr.noresize, noResize);
    }

    public void setScrolling(String scrolling) {
        this.getDFrame().setHtmlScrolling(scrolling);
        this.onAttrChange(EHtmlAttr.scrolling, scrolling);
    }

    public void setSrc(String src) {
        this.getDFrame().setHtmlSrc(src);
        this.setContentDocument(AHtmlHelper.getContentDocument(this, src));
        this.onAttrChange(EHtmlAttr.src, src);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnload() {
        return this.getOnLoad();
    }

    public void setOnload(Object functionRef) {
        this.setOnLoad(functionRef);
    }

    public Object getOnunload() {
        return this.getOnLoad();
    }

    public void setOnunload(Object functionRef) {
        this.setOnLoad(functionRef);
    }

    private DFrame getDFrame() {
        return (DFrame)this.getDNode();
    }

    void setContentDocument(AHtmlDocument frameDoc) {
        this.m_contentDocument = frameDoc;
    }
}

