/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlType;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlUnknown;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.ANodeInternal;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DElementConstructor;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.BaseHeading;
import org.eclipse.vjet.dsf.html.dom.BaseTableSection;
import org.eclipse.vjet.dsf.html.dom.DObject;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AHtmlFactory {
    private static HashMap<String, Constructor<?>> s_elementTypesHTML;
    private static HashMap<String, Constructor<?>> s_objectConstructors;

    static {
        s_objectConstructors = new HashMap();
        AHtmlFactory.populateElementTypes();
    }

    public static synchronized void setObjectConstructor(String objectId, Constructor<?> objConstructor) {
        if (objectId == null || objConstructor == null) {
            throw new RuntimeException("objectId or objConstructor is null: objectId=" + objectId + "; objConstructor=" + objConstructor);
        }
        s_objectConstructors.put(objectId, objConstructor);
    }

    public static HtmlElement createElement(HtmlDocument owner, String tagName) {
        AHtmlType<?> htmlType = AHtmlType.Type.get(tagName);
        if (htmlType == null) {
            return AHtmlFactory.createUnknownElement(owner, tagName);
        }
        return AHtmlFactory.createElement(owner, htmlType);
    }

    public static HtmlElement createElement(HtmlDocument owner, HtmlTypeEnum htmlType) {
        if (htmlType == null) {
            throw new RuntimeException("htmlType is null");
        }
        try {
            DNode dNode = (DNode)htmlType.getTypeClass().newInstance();
            if (owner != null) {
                DomHelper.setOwnerDocument((DDocument)ANodeHelper.getDNode((ANode)owner), dNode);
            }
            return AHtmlFactory.createElement(owner, dNode);
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    public static HtmlElement createElement(HtmlDocument owner, AHtmlType<?> htmlType) {
        DElement dNode;
        if (htmlType == null) {
            throw new RuntimeException("htmlType is null");
        }
        if (owner == null) {
            throw new RuntimeException("owner document is null");
        }
        try {
            dNode = (DElement)htmlType.getType().getTypeClass().newInstance();
            if (owner != null) {
                DomHelper.setOwnerDocument((DDocument)ANodeHelper.getDNode((ANode)owner), (DNode)dNode);
            }
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return AHtmlFactory.createElement(htmlType.getTagName(), owner, (DNode)dNode);
    }

    public static HtmlElement createElement(HtmlDocument owner, DNode dNode) {
        return AHtmlFactory.createElement(dNode.getNodeName(), owner, dNode);
    }

    static HtmlElement createUnknownElement(HtmlDocument owner, String tagName) {
        return new AHtmlUnknown((AHtmlDocument)owner, new DElement(tagName));
    }

    static HtmlElement createElement(String tagName, HtmlDocument owner, DNode dNode) {
        if (dNode == null) {
            throw new RuntimeException("DNode is null");
        }
        Constructor<?> cnst = null;
        if ("object".equals(tagName)) {
            cnst = s_objectConstructors.get(((DObject)dNode).getHtmlId());
        }
        if (cnst == null) {
            cnst = s_elementTypesHTML.get(tagName);
        }
        if (cnst == null) {
            throw new RuntimeException("Unknown tagName " + tagName);
        }
        Object[] args = new Object[]{owner, dNode};
        try {
            return (HtmlElement)cnst.newInstance(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Tag '" + tagName + "' associated with an Element class failed to construct" + " with following message: " + ex.getMessage(), ex);
        }
    }

    static void appendChild(AElement parent, DNode child) {
        if (child instanceof DText) {
            AText text = new AText((AHtmlDocument)parent.getOwnerDocument(), (DText)child);
            parent.appendChild(text);
        } else {
            boolean hasChildren = child.hasChildNodes();
            ArrayList<DNode> dNodeChildren = null;
            if (hasChildren) {
                NodeList children = child.getChildNodes();
                int size = children.getLength();
                dNodeChildren = new ArrayList<DNode>(size);
                int i = 0;
                while (i < size) {
                    dNodeChildren.add((DNode)children.item(i));
                    ++i;
                }
                i = 0;
                while (i < size) {
                    child.removeChild((Node)dNodeChildren.get(i));
                    ++i;
                }
            }
            AHtmlElement element = (AHtmlElement)AHtmlFactory.createElement((HtmlDocument)((AHtmlDocument)parent.getOwnerDocument()), child);
            if (hasChildren) {
                int i = 0;
                while (i < dNodeChildren.size()) {
                    child.appendChild((Node)dNodeChildren.get(i));
                    AHtmlFactory.appendChild(element, (DNode)dNodeChildren.get(i));
                    ++i;
                }
            }
            parent.appendChild(element);
        }
    }

    private static void populateElementTypes() {
        Iterable<AHtmlType<?>> iter = AHtmlType.Type.valueIterable();
        s_elementTypesHTML = new HashMap(64);
        for (AHtmlType<?> htmlType : iter) {
            AHtmlFactory.populateElementType(htmlType);
        }
    }

    private static void populateElementType(AHtmlType<?> htmlType) {
        String tagName = htmlType.getTagName();
        Class<?> elemClz = htmlType.getTypeClass();
        Class[] elemClassSig = new Class[]{AHtmlDocument.class, AHtmlFactory.getDNodeType(htmlType.getType())};
        try {
            s_elementTypesHTML.put(tagName, elemClz.getDeclaredConstructor(elemClassSig));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find proper constructor for " + elemClz.getName() + " for " + tagName, e);
        }
    }

    private static Class<?> getDNodeType(HtmlTypeEnum htmlType) {
        if (htmlType == HtmlTypeEnum.TBODY || htmlType == HtmlTypeEnum.TFOOT || htmlType == HtmlTypeEnum.THEAD) {
            return BaseTableSection.class;
        }
        if (htmlType == HtmlTypeEnum.H1 || htmlType == HtmlTypeEnum.H2 || htmlType == HtmlTypeEnum.H3 || htmlType == HtmlTypeEnum.H4 || htmlType == HtmlTypeEnum.H5 || htmlType == HtmlTypeEnum.H6) {
            return BaseHeading.class;
        }
        return htmlType.getTypeClass();
    }

    private static class ANodeHelper
    extends ANodeInternal {
        private ANodeHelper() {
        }

        private static DNode getDNode(ANode node) {
            return ANodeInternal.getInternalNode(node);
        }
    }

    private static class DomHelper
    extends DElementConstructor {
        private DomHelper() {
        }

        protected static void setOwnerDocument(DDocument doc, DNode node) {
            DElementConstructor.setOwnerDocument((DDocument)doc, (DNode)node);
        }
    }
}

