/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.util.ScriptingSessionClassLoader;
import org.eclipse.vjet.dsf.active.util.VJContextFactory;
import org.eclipse.vjet.dsf.active.util.WindowTaskManager;
import org.eclipse.vjet.dsf.dap.event.EventConverter;
import org.eclipse.vjet.dsf.dap.event.KeyEventConverter;
import org.eclipse.vjet.dsf.dap.event.MouseEventConverter;
import org.eclipse.vjet.dsf.dap.event.UIEventConverter;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.js.dbgp.JsDebuggerEnabler;
import org.eclipse.vjet.dsf.jsdebugger.DebuggerAdapter;
import org.eclipse.vjet.dsf.jsnative.Window;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.KeyboardEvent;
import org.eclipse.vjet.dsf.jsnative.events.MouseEvent;
import org.eclipse.vjet.dsf.jsnative.events.UIEvent;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ContextFactory;
import org.mozilla.mod.javascript.IJsJavaConverter;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class WindowFactory {
    private WindowFactory() {
    }

    public static Window createWindow() {
        return WindowFactory.createWindow(null, BrowserType.IE_6P, new WindowTaskManager());
    }

    public static Window createWindow(BrowserType type) {
        return WindowFactory.createWindow(null, type == null ? BrowserType.IE_6P : type, new WindowTaskManager());
    }

    public static Window createWindow(Window parent) {
        return WindowFactory.createWindow(parent, parent == null ? BrowserType.IE_6P : ((AWindow)parent).getBrowserType(), new WindowTaskManager());
    }

    public static Window createWindow(BrowserType browserType, WindowTaskManager taskMgr) {
        return WindowFactory.createWindow(null, browserType == null ? BrowserType.IE_6P : browserType, taskMgr);
    }

    public static Window createWindow(Window parent, BrowserType type, WindowTaskManager taskMgr) {
        Context cx = null;
        Object scope = null;
        AWindow window = null;
        DebuggerAdapter dbg = null;
        try {
            if (parent == null) {
                if (!ContextFactory.hasExplicitGlobal()) {
                    ContextFactory.initGlobal((ContextFactory)new VJContextFactory());
                }
                if (ActiveJsExecutionControlCtx.ctx().needExecuteJavaScript()) {
                    String debuggerServiceIp = System.getProperty("VJETDebugHost");
                    String debuggerServicePort = System.getProperty("VJETDebugPort");
                    String debuggerServiceSessionID = System.getProperty("VJETDebugSessionID");
                    if (debuggerServiceIp == null || debuggerServicePort == null || debuggerServiceSessionID == null) {
                        dbg = org.eclipse.vjet.dsf.jsdebugger.JsDebuggerEnabler.enable();
                    } else {
                        JsDebuggerEnabler.enable();
                    }
                }
            }
            cx = WindowFactory.setupContext((AWindow)parent);
            scope = cx.initStandardObjects(null);
            ScriptableObject.defineClass((Scriptable)scope, AWindow.class);
            window = (AWindow)cx.newObject(scope, "AWindow");
            window.setParentScope((Scriptable)scope);
            window.setPrototype((Scriptable)scope);
            if (dbg != null) {
                window.setDebugger(dbg);
            }
            scope = window;
            window.init((AWindow)parent, cx, (Scriptable)scope, type, taskMgr);
            if (parent != null) {
                ((AWindow)parent).addChildWindow(window);
            }
            if (DapCtx.ctx().isActiveMode()) {
                DapCtx.ctx().setWindow(window);
            }
            return window;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void contextSwitch(AWindow window) {
        WindowFactory.setupContext(null);
    }

    private static Context setupContext(AWindow parent) {
        if (parent != null) {
            return parent.getContext();
        }
        Context cx = ContextFactory.getGlobal().enterContext();
        if (DapCtx.ctx().isActiveMode()) {
            cx.setApplicationClassLoader((ClassLoader)new ScriptingSessionClassLoader());
            cx.registerConverter(MouseEvent.class, (IJsJavaConverter)new MouseEventConverter());
            cx.registerConverter(KeyboardEvent.class, (IJsJavaConverter)new KeyEventConverter());
            cx.registerConverter(UIEvent.class, (IJsJavaConverter)new UIEventConverter());
            cx.registerConverter(Event.class, (IJsJavaConverter)new EventConverter());
        }
        cx.setLanguageVersion(150);
        cx.setOptimizationLevel(-1);
        return cx;
    }
}

