/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import org.eclipse.vjet.dsf.active.client.ATextRange;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.jsnative.Selection;
import org.eclipse.vjet.dsf.jsnative.TextRange;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class ASelection
extends ActiveObject
implements Selection {
    private static final long serialVersionUID = 2708447508280395592L;
    private IBrowserBinding m_browserBinding;
    private BrowserType m_browserType;
    private static final String SELECTION_CLEAR_JS = "document.selection.clear()";
    private static final String SELECTION_EMPTY_JS = "document.selection.empty()";
    private static final String SELECTION_TYPE_JS = "document.selection.type";
    private static final String SELECTION_TYPE_DETAIL_JS = "document.selection.typeDetail";

    public ASelection(BrowserType browserType, IBrowserBinding bowserBinding) {
        this.m_browserBinding = bowserBinding;
        this.m_browserType = browserType;
        this.populateScriptable(ASelection.class, browserType);
    }

    public void clear() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(SELECTION_CLEAR_JS);
        }
    }

    public void empty() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(SELECTION_EMPTY_JS);
        }
    }

    public String getType() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs(SELECTION_TYPE_JS);
        }
        return null;
    }

    public String getTypeDetail() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs(SELECTION_TYPE_DETAIL_JS);
        }
        return null;
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return ((Object)((Object)this)).getClass().getName();
        }
        return null;
    }

    public TextRange createRange() {
        return new ATextRange(this.m_browserType, this.m_browserBinding);
    }

    public TextRange[] createRangeCollection() {
        TextRange[] trArray = new TextRange[]{new ATextRange(this.m_browserType, this.m_browserBinding)};
        return trArray;
    }
}

