/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select.translator;

import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.DefaultNodeTranslator;

public class JstMethodTranslator
extends DefaultNodeTranslator {
    @Override
    public IModelElement[] convert(IVjoSourceModule module, IJstNode node) {
        IJstMethod jstMethod = (IJstMethod)node;
        IJstType ownerType = jstMethod.getOwnerType();
        IModelElement[] convert = JstNodeDLTKElementResolver.convert(module, (IJstNode)ownerType);
        if (convert == null || convert.length == 0) {
            return null;
        }
        IType dltkType = (IType)convert[0];
        if (dltkType == null) {
            return null;
        }
        try {
            if (jstMethod.getParentNode() instanceof FuncExpr || jstMethod.getParentNode() instanceof JstMethod) {
                IModelElement element = CodeassistUtils.findDeclaringMethodChain(dltkType, (IJstNode)jstMethod);
                String name = jstMethod.getName().getName();
                if (element.getElementName().equals(name)) {
                    return new IModelElement[]{element};
                }
                if ((element = CodeassistUtils.findDeclaringObjectLiteralChain((ModelElement)element, node)) != null) {
                    return new IModelElement[]{element};
                }
            } else if (jstMethod.getParentNode() instanceof IJstType) {
                IMethod[] converted = CodeassistUtils.getMethod(dltkType, jstMethod);
                if (converted == null) {
                    converted = CodeassistUtils.getLocalVar((ISourceModule)dltkType.getSourceModule(), jstMethod.getName().getName(), "Function", jstMethod.getSource());
                }
                return converted != null ? converted : new IModelElement[]{};
            }
        }
        catch (ModelException e) {
            VjetPlugin.error(e.getLocalizedMessage(), e);
        }
        return null;
    }
}

